/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.modules.websvc.manager.swing.outline.DefaultOutlineCellRenderer;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.RenderDataProvider;
import org.netbeans.modules.websvc.manager.swing.outline.TreePathSupport;

public final class Outline
extends JTable {
    private boolean initialized = false;
    private Boolean cachedRootVisible = null;
    private RenderDataProvider renderDataProvider = null;
    private ComponentListener componentListener = null;
    private boolean needCalcRowHeight = true;

    public Outline() {
        this.init();
    }

    public Outline(OutlineModel outlineModel) {
        super(outlineModel);
        this.init();
    }

    private void init() {
        this.initialized = true;
        this.setDefaultRenderer(Object.class, new DefaultOutlineCellRenderer());
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = n2 == 0 ? this.getDefaultRenderer(Object.class) : super.getCellRenderer(n, n2);
        return tableCellRenderer;
    }

    public RenderDataProvider getRenderDataProvider() {
        return this.renderDataProvider;
    }

    public void setRenderDataProvider(RenderDataProvider renderDataProvider) {
        if (renderDataProvider != this.renderDataProvider) {
            RenderDataProvider renderDataProvider2 = this.renderDataProvider;
            this.renderDataProvider = renderDataProvider;
            this.firePropertyChange("renderDataProvider", renderDataProvider2, renderDataProvider);
        }
    }

    TreePathSupport getTreePathSupport() {
        OutlineModel outlineModel = this.getOutlineModel();
        if (outlineModel != null) {
            return outlineModel.getTreePathSupport();
        }
        return null;
    }

    AbstractLayoutCache getLayoutCache() {
        OutlineModel outlineModel = this.getOutlineModel();
        if (outlineModel != null) {
            return outlineModel.getLayout();
        }
        return null;
    }

    boolean isTreeColumnIndex(int n) {
        return n == 0;
    }

    public boolean isVisible(TreePath treePath) {
        if (this.getTreePathSupport() != null) {
            return this.getTreePathSupport().isVisible(treePath);
        }
        return false;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.getLayoutCache() != null) {
            this.getLayoutCache().setRowHeight(n);
        }
    }

    public void setRootVisible(boolean bl) {
        if (this.getOutlineModel() == null) {
            Boolean bl2 = this.cachedRootVisible = bl ? Boolean.TRUE : Boolean.FALSE;
        }
        if (bl != this.isRootVisible()) {
            this.getLayoutCache().setRootVisible(bl);
            this.firePropertyChange("rootVisible", !bl, bl);
        }
    }

    public boolean isRootVisible() {
        if (this.getLayoutCache() == null) {
            return this.cachedRootVisible != null ? this.cachedRootVisible : true;
        }
        return this.getLayoutCache().isRootVisible();
    }

    public void setModel(TableModel tableModel) {
        if (this.initialized && !(tableModel instanceof OutlineModel)) {
            throw new IllegalArgumentException("Table model for an Outline must be an instance of OutlineModel");
        }
        if (tableModel instanceof OutlineModel) {
            AbstractLayoutCache abstractLayoutCache = ((OutlineModel)tableModel).getLayout();
            if (this.cachedRootVisible != null) {
                abstractLayoutCache.setRootVisible(this.cachedRootVisible);
            }
            abstractLayoutCache.setRowHeight(this.getRowHeight());
            if (((OutlineModel)tableModel).isLargeModel()) {
                this.addComponentListener(this.getComponentListener());
                abstractLayoutCache.setNodeDimensions(new ND());
            } else if (this.componentListener != null) {
                this.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        }
        super.setModel(tableModel);
    }

    public OutlineModel getOutlineModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof OutlineModel) {
            return (OutlineModel)this.getModel();
        }
        return null;
    }

    public void expandPath(TreePath treePath) {
        this.getTreePathSupport().expandPath(treePath);
    }

    public void collapsePath(TreePath treePath) {
        this.getTreePathSupport().collapsePath(treePath);
    }

    public Rectangle getPathBounds(TreePath treePath) {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getLayoutCache().getBounds(treePath, null);
        if (rectangle != null && insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
        }
        return rectangle;
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        Insets insets = this.getInsets();
        if (insets != null) {
            return this.getLayoutCache().getPathClosestTo(n - insets.left, n2 - insets.top);
        }
        return this.getLayoutCache().getPathClosestTo(n, n2);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        if (this.isTreeColumnIndex(n2) && eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            TreePath treePath = this.getLayoutCache().getPathClosestTo(mouseEvent.getX(), mouseEvent.getY());
            if (!this.getOutlineModel().isLeaf(treePath.getLastPathComponent())) {
                int n3 = DefaultOutlineCellRenderer.getExpansionHandleWidth();
                Insets insets = this.getInsets();
                int n4 = insets.left + (treePath.getPathCount() - 1) * DefaultOutlineCellRenderer.getNestingWidth();
                int n5 = insets.left + n4 + n3;
                if (mouseEvent.getX() > insets.left && mouseEvent.getX() >= n4 && mouseEvent.getX() <= n5 || mouseEvent.getClickCount() > 1) {
                    boolean bl = this.getLayoutCache().isExpanded(treePath);
                    if (!bl) {
                        this.getTreePathSupport().expandPath(treePath);
                    } else {
                        this.getTreePathSupport().collapsePath(treePath);
                    }
                    return false;
                }
            }
        }
        return super.editCellAt(n, n2, eventObject);
    }

    private void calcRowHeight(Graphics graphics) {
        int n;
        Integer n2 = (Integer)UIManager.get("netbeans.outline.rowHeight");
        if (n2 != null) {
            n = n2;
        } else {
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            n = Math.max(fontMetrics.getHeight() + 3, DefaultOutlineCellRenderer.getExpansionHandleHeight());
        }
        this.needCalcRowHeight = false;
        this.setRowHeight(n);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
    }

    public void paint(Graphics graphics) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(graphics);
            return;
        }
        super.paint(graphics);
    }

    private ComponentListener getComponentListener() {
        if (this.componentListener == null) {
            this.componentListener = new SizeManager();
        }
        return this.componentListener;
    }

    private JScrollPane getScrollPane() {
        JScrollPane jScrollPane = null;
        if (this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getParent() instanceof JScrollPane) {
            jScrollPane = (JScrollPane)((JViewport)this.getParent()).getParent();
        }
        return jScrollPane;
    }

    private void change() {
        this.revalidate();
        this.repaint();
    }

    private class SizeManager
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer = null;
        protected JScrollBar scrollBar = null;

        private SizeManager() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = Outline.this.getScrollPane();
                if (jScrollPane == null) {
                    Outline.this.change();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            Outline.this.change();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                Outline.this.change();
                this.timer = null;
                this.scrollBar = null;
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class ND
    extends AbstractLayoutCache.NodeDimensions {
        private ND() {
        }

        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            int n3 = Outline.this.getColumnModel().getColumn(0).getPreferredWidth();
            rectangle.setBounds(0, n * Outline.this.getRowHeight(), n3, Outline.this.getRowHeight());
            return rectangle;
        }
    }
}

