/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;
import org.netbeans.modules.websvc.manager.swing.outline.EventBroadcaster;
import org.netbeans.modules.websvc.manager.swing.outline.NodeRowModel;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;
import org.netbeans.modules.websvc.manager.swing.outline.ProxyTableModel;
import org.netbeans.modules.websvc.manager.swing.outline.RowModel;
import org.netbeans.modules.websvc.manager.swing.outline.TreePathSupport;

public class DefaultOutlineModel
implements OutlineModel {
    private TreeModel treeModel;
    private TableModel tableModel;
    private AbstractLayoutCache layout;
    private TreePathSupport treePathSupport;
    private EventBroadcaster broadcaster;
    private static final int NODES_CHANGED = 0;
    private static final int NODES_INSERTED = 1;
    private static final int NODES_REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;
    private String nodeColumnName;
    private static final String[] types = new String[]{"nodesChanged", "nodesInserted", "nodesRemoved", "structureChanged"};

    public static OutlineModel createOutlineModel(TreeModel treeModel, RowModel rowModel) {
        return DefaultOutlineModel.createOutlineModel(treeModel, rowModel, false);
    }

    public static OutlineModel createOutlineModel(TreeModel treeModel, RowModel rowModel, boolean bl) {
        ProxyTableModel proxyTableModel = new ProxyTableModel(rowModel);
        return new DefaultOutlineModel(treeModel, proxyTableModel, bl);
    }

    protected DefaultOutlineModel(TreeModel treeModel, TableModel tableModel, boolean bl) {
        this.treeModel = treeModel;
        this.tableModel = tableModel;
        this.layout = bl ? new FixedHeightLayoutCache() : new VariableHeightLayoutCache();
        this.broadcaster = new EventBroadcaster(this);
        this.layout.setRootVisible(true);
        this.layout.setModel(this);
        this.treePathSupport = new TreePathSupport(this, this.layout);
        this.treePathSupport.addTreeExpansionListener(this.broadcaster);
        this.treePathSupport.addTreeWillExpandListener(this.broadcaster);
        treeModel.addTreeModelListener(this.broadcaster);
        tableModel.addTableModelListener(this.broadcaster);
        if (tableModel instanceof ProxyTableModel) {
            ((ProxyTableModel)tableModel).setOutlineModel(this);
        }
    }

    public final TreePathSupport getTreePathSupport() {
        return this.treePathSupport;
    }

    public final AbstractLayoutCache getLayout() {
        return this.layout;
    }

    public boolean areMoreEventsPending() {
        return this.broadcaster.areMoreEventsPending();
    }

    TreeModel getTreeModel() {
        return this.treeModel;
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    public final Object getChild(Object object, int n) {
        return this.treeModel.getChild(object, n);
    }

    public final int getChildCount(Object object) {
        return this.treeModel.getChildCount(object);
    }

    public final Class getColumnClass(int n) {
        if (n == 0) {
            return Object.class;
        }
        return this.tableModel.getColumnClass(n - 1);
    }

    public final int getColumnCount() {
        return this.tableModel.getColumnCount() + 1;
    }

    public void setNodeColumnName(String string) {
        this.nodeColumnName = string;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return null == this.nodeColumnName ? "Nodes" : this.nodeColumnName;
        }
        return this.tableModel.getColumnName(n - 1);
    }

    public final int getIndexOfChild(Object object, Object object2) {
        return this.treeModel.getIndexOfChild(object, object2);
    }

    public final Object getRoot() {
        return this.treeModel.getRoot();
    }

    public final int getRowCount() {
        return this.layout.getRowCount();
    }

    public final Object getValueAt(int n, int n2) {
        TreePath treePath;
        Object object = n2 == 0 ? ((treePath = this.getLayout().getPathForRow(n)) != null ? treePath.getLastPathComponent() : null) : this.tableModel.getValueAt(n, n2 - 1);
        return object;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        return this.tableModel.isCellEditable(n, n2 - 1);
    }

    public final boolean isLeaf(Object object) {
        if (null == object) {
            return true;
        }
        return this.treeModel.isLeaf(object);
    }

    public final synchronized void addTableModelListener(TableModelListener tableModelListener) {
        this.broadcaster.addTableModelListener(tableModelListener);
    }

    public final synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.broadcaster.addTreeModelListener(treeModelListener);
    }

    public final synchronized void removeTableModelListener(TableModelListener tableModelListener) {
        this.broadcaster.removeTableModelListener(tableModelListener);
    }

    public final synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.broadcaster.removeTreeModelListener(treeModelListener);
    }

    public final void setValueAt(Object object, int n, int n2) {
        if (n2 != 0) {
            this.tableModel.setValueAt(object, n, n2 - 1);
        }
    }

    public final void valueForPathChanged(TreePath treePath, Object object) {
        this.treeModel.valueForPathChanged(treePath, object);
    }

    public boolean isLargeModel() {
        return this.layout instanceof FixedHeightLayoutCache;
    }

    public NodeRowModel getRowNodeModel() {
        return (ProxyTableModel)this.tableModel;
    }
}

