/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceDataEvent;
import org.netbeans.modules.websvc.manager.model.WebServiceDataListener;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;

public class WebServiceData
implements WsdlData {
    public static final String JAX_WS = "jaxws";
    public static final String JAX_RPC = "jaxrpc";
    private String websvcId;
    private String wsdlFile;
    private String originalWsdlUrl;
    private String catalog;
    private String groupId;
    private String packageName;
    WSService wsdlService;
    private String wsName;
    private boolean jaxWsEnabled;
    private boolean jaxRpcEnabled;
    @Deprecated
    private boolean compiled;
    private State wsdlState = State.WSDL_UNRETRIEVED;
    private boolean resolved;
    private WebServiceDescriptor jaxWsDescriptor;
    private WebServiceDescriptor jaxRpcDescriptor;
    private String jaxWsDescriptorPath;
    private String jaxRpcDescriptorPath;
    private List<WebServiceDataListener> listeners = new ArrayList<WebServiceDataListener>();
    private List<PropertyChangeListener> propertyListeners = new ArrayList<PropertyChangeListener>();

    public WebServiceData() {
        this.resolved = true;
    }

    public WebServiceData(String string, String string2) {
        this(null, string, string2);
        this.wsdlState = State.WSDL_UNRETRIEVED;
    }

    public WebServiceData(String string, String string2, String string3) {
        this.websvcId = WebServiceListModel.getInstance().getUniqueWebServiceId();
        this.wsdlFile = string;
        this.groupId = string3;
        this.compiled = false;
        this.originalWsdlUrl = string2;
        this.resolved = true;
        if (string != null) {
            this.wsdlState = State.WSDL_RETRIEVED;
        }
    }

    public WebServiceData(WSService wSService, String string, String string2, String string3) {
        this(string, string2, string3);
        this.wsdlService = wSService;
        this.wsName = wSService.getName();
    }

    public WebServiceData(WebServiceData webServiceData) {
        this(webServiceData.getWsdlFile(), webServiceData.getOriginalWsdlUrl(), webServiceData.getGroupId());
        this.packageName = webServiceData.packageName;
        this.jaxWsDescriptor = webServiceData.jaxWsDescriptor;
        this.jaxWsDescriptorPath = webServiceData.jaxWsDescriptorPath;
        this.jaxWsEnabled = webServiceData.jaxWsEnabled;
        this.jaxRpcDescriptor = webServiceData.jaxRpcDescriptor;
        this.jaxRpcDescriptorPath = webServiceData.jaxRpcDescriptorPath;
        this.jaxRpcEnabled = webServiceData.jaxRpcEnabled;
        this.catalog = webServiceData.catalog;
        this.wsdlService = webServiceData.wsdlService;
        this.wsName = webServiceData.wsName;
        this.wsdlState = webServiceData.wsdlState;
    }

    public void reset() {
        this.jaxWsDescriptor = null;
        this.jaxWsDescriptorPath = null;
        this.jaxWsEnabled = false;
        this.jaxRpcDescriptor = null;
        this.jaxRpcDescriptorPath = null;
        this.jaxRpcEnabled = false;
        this.catalog = null;
        this.wsdlService = null;
        this.setState(State.WSDL_UNRETRIEVED);
    }

    public boolean isReady() {
        if (this.wsdlFile == null || !new File(this.wsdlFile).isFile() || this.getCatalog() == null || !new File(this.getCatalog()).isFile()) {
            return false;
        }
        if (this.getName() == null || this.getWsdlService() == null) {
            return false;
        }
        return this.getJaxWsDescriptor() != null && !this.getJaxWsDescriptor().getJars().isEmpty();
    }

    public void setResolved(boolean bl) {
        boolean bl2 = this.resolved;
        this.resolved = bl;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "resolved", bl2, this.resolved);
        for (PropertyChangeListener propertyChangeListener : this.propertyListeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setWsdlService(WSService wSService) {
        this.wsdlService = wSService;
        if (this.jaxRpcDescriptor != null) {
            this.jaxRpcDescriptor.setModel(this.wsdlService);
        }
        if (this.jaxWsDescriptor != null) {
            this.jaxWsDescriptor.setModel(this.wsdlService);
        }
    }

    public WSService getWsdlService() {
        return this.wsdlService;
    }

    public void setId(String string) {
        this.websvcId = string;
    }

    public String getId() {
        return this.websvcId;
    }

    public void setName(String string) {
        this.wsName = string;
    }

    public String getName() {
        return this.wsName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String string) {
        this.setModelDirty();
        this.groupId = string;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String string) {
        this.setModelDirty();
        this.wsdlFile = string;
    }

    @Deprecated
    public String getURL() {
        return this.wsdlFile;
    }

    @Deprecated
    public void setURL(String string) {
        this.setModelDirty();
        this.wsdlFile = string;
    }

    public String getOriginalWsdlUrl() {
        return this.originalWsdlUrl;
    }

    public void setOriginalWsdlUrl(String string) {
        this.originalWsdlUrl = string;
    }

    @Deprecated
    public String getOriginalWsdl() {
        return this.originalWsdlUrl;
    }

    @Deprecated
    public void setOriginalWsdl(String string) {
        this.originalWsdlUrl = string;
    }

    public void setPackageName(String string) {
        this.setModelDirty();
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getEffectivePackageName() {
        int n;
        String string;
        if (this.packageName != null && this.packageName.trim().length() > 0) {
            return this.packageName;
        }
        if (this.wsdlService != null && (string = this.wsdlService.getJavaName()) != null && (n = string.lastIndexOf(46)) >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public WebServiceDescriptor getJaxWsDescriptor() {
        return this.jaxWsDescriptor;
    }

    public void setJaxWsDescriptor(WebServiceDescriptor webServiceDescriptor) {
        this.jaxWsDescriptor = webServiceDescriptor;
    }

    public WebServiceDescriptor getJaxRpcDescriptor() {
        return this.jaxRpcDescriptor;
    }

    public void setJaxRpcDescriptor(WebServiceDescriptor webServiceDescriptor) {
        this.jaxRpcDescriptor = webServiceDescriptor;
    }

    public String getJaxWsDescriptorPath() {
        return this.jaxWsDescriptorPath;
    }

    public void setJaxWsDescriptorPath(String string) {
        this.jaxWsDescriptorPath = string;
    }

    public String getJaxRpcDescriptorPath() {
        return this.jaxRpcDescriptorPath;
    }

    public void setJaxRpcDescriptorPath(String string) {
        this.jaxRpcDescriptorPath = string;
    }

    private void setModelDirty() {
        WebServiceListModel.getInstance().setDirty(true);
    }

    public boolean isJaxRpcEnabled() {
        return this.jaxRpcEnabled;
    }

    public boolean isJaxWsEnabled() {
        return this.jaxWsEnabled;
    }

    public void setJaxRpcEnabled(boolean bl) {
        this.jaxRpcEnabled = bl;
    }

    public void setJaxWsEnabled(boolean bl) {
        this.jaxWsEnabled = bl;
    }

    public State getState() {
        return this.wsdlState;
    }

    public void setState(State state) {
        boolean bl = !this.wsdlState.equals((Object)State.WSDL_SERVICE_COMPILED) && state.equals((Object)State.WSDL_SERVICE_COMPILED);
        State state2 = this.wsdlState;
        WsdlData.Status status = this.getStatus();
        this.wsdlState = state;
        WsdlData.Status status2 = this.getStatus();
        if (bl) {
            for (WebServiceDataListener object : this.listeners) {
                object.webServiceCompiled(new WebServiceDataEvent(this));
            }
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "state", status, status2);
        for (PropertyChangeListener propertyChangeListener : this.propertyListeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public String getStateName() {
        return this.wsdlState.name();
    }

    public void setStateName(String string) {
        this.wsdlState = State.valueOf(string);
    }

    @Deprecated
    public boolean isCompiled() {
        return this.compiled;
    }

    @Deprecated
    public void setCompiled(boolean bl) {
        boolean bl2 = false;
        if (!this.compiled && bl) {
            bl2 = true;
        }
        this.compiled = bl;
        if (bl2) {
            for (WebServiceDataListener webServiceDataListener : this.listeners) {
                webServiceDataListener.webServiceCompiled(new WebServiceDataEvent(this));
            }
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void addWebServiceDataListener(WebServiceDataListener webServiceDataListener) {
        this.listeners.add(webServiceDataListener);
    }

    public void removeWebServiceDataListener(WebServiceDataListener webServiceDataListener) {
        this.listeners.remove(webServiceDataListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.remove(propertyChangeListener);
    }

    public WsdlData.Status getStatus() {
        if (this.getState() == State.WSDL_UNRETRIEVED) {
            return WsdlData.Status.WSDL_UNRETRIEVED;
        }
        if (this.getState() == State.WSDL_RETRIEVED) {
            return WsdlData.Status.WSDL_RETRIEVED;
        }
        if (this.getState() == State.WSDL_RETRIEVING) {
            return WsdlData.Status.WSDL_RETRIEVING;
        }
        if (this.getState() == State.WSDL_SERVICE_COMPILED) {
            return WsdlData.Status.WSDL_SERVICE_COMPILED;
        }
        if (this.getState() == State.WSDL_SERVICE_COMPILE_FAILED) {
            return WsdlData.Status.WSDL_SERVICE_COMPILE_FAILED;
        }
        if (this.getState() == State.WSDL_SERVICE_COMPILING) {
            return WsdlData.Status.WSDL_SERVICE_COMPILING;
        }
        return WsdlData.Status.WSDL_SERVICE_COMPILING;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        WSDL_UNRETRIEVED,
        WSDL_RETRIEVING,
        WSDL_RETRIEVED,
        WSDL_SERVICE_COMPILING,
        WSDL_SERVICE_COMPILED,
        WSDL_SERVICE_COMPILE_FAILED;

    }
}

