/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.regexp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.i18n.regexp.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Generator {
    private StringBuilder buf = new StringBuilder(20);
    private Map<String, String> tokenReplacements;
    private boolean generatingSetOfChars = false;

    Generator() {
    }

    public static String generateRegexp(TreeNode treeNode) {
        return Generator.generateRegexp(treeNode, null);
    }

    public static String generateRegexp(TreeNode treeNode, Map<String, String> map) {
        if (treeNode == null) {
            return null;
        }
        Generator generator = new Generator();
        generator.setTokenReplacements(map);
        generator.generate(treeNode);
        return generator.buf.toString();
    }

    private static String quoteString(String string) {
        StringBuilder stringBuilder;
        if (string.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            stringBuilder = new StringBuilder(string.length() + 4);
            stringBuilder.append("\\Q").append(string).append("\\E");
        } else {
            stringBuilder = new StringBuilder(string.length() + 16);
            do {
                if (n2 != n) {
                    stringBuilder.append("\\Q");
                    stringBuilder.append(string.substring(n, n2));
                    stringBuilder.append("\\E");
                }
                stringBuilder.append('\\').append('\\');
            } while ((n2 = string.indexOf(92, n = n2 + 1)) != -1);
            if (n != string.length()) {
                stringBuilder.append("\\Q");
                stringBuilder.append(string.substring(n));
                stringBuilder.append("\\E");
            }
        }
        return stringBuilder.toString();
    }

    private void setTokenReplacements(Map<String, String> map) {
        if (map != null && map.isEmpty()) {
            map = null;
        }
        this.tokenReplacements = map;
        if (map != null) {
            this.quoteTokenReplacements();
        }
    }

    private void quoteTokenReplacements() {
        if (this.tokenReplacements == null || this.tokenReplacements.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : this.tokenReplacements.entrySet()) {
            entry.setValue(Generator.quoteString(entry.getValue()));
        }
    }

    private void generate(TreeNode treeNode) {
        List<TreeNode> list = treeNode.getChildren();
        int n = treeNode.getTokenType();
        Object object = treeNode.getAttribs();
        block0 : switch (n) {
            case 8: {
                char c = ((Character)object).charValue();
                switch (c) {
                    case '\t': {
                        this.buf.append('\\').append('t');
                        break block0;
                    }
                    case '\n': {
                        this.buf.append('\\').append('n');
                        break block0;
                    }
                    case '\r': {
                        this.buf.append('\\').append('r');
                        break block0;
                    }
                    case '\f': {
                        this.buf.append('\\').append('f');
                        break block0;
                    }
                    case '\\': {
                        this.buf.append('\\').append('\\');
                        break block0;
                    }
                }
                if (!this.generatingSetOfChars && "^$|*+?.()[]{}".indexOf(c) != -1) {
                    this.buf.append('\\');
                }
                this.buf.append(c);
                break;
            }
            case 6: {
                char c = ((Character)object).charValue();
                if (c == '.') {
                    this.buf.append('.');
                    break;
                }
                this.buf.append('\\').append(c);
                break;
            }
            case 4: {
                if (object instanceof Character) {
                    char c = ((Character)object).charValue();
                    this.buf.append(c);
                    break;
                }
                String string = (String)object;
                this.buf.append('{');
                this.generate(list.get(0));
                if (string.length() > 3) {
                    this.buf.append(',');
                    if (string.length() == 5) {
                        this.generate(list.get(1));
                    }
                }
                this.buf.append('}');
                break;
            }
            case 3: {
                this.generate(list.get(0));
                if (list.size() != 2) break;
                this.generate(list.get(1));
                break;
            }
            case 12: {
                this.generate(list.get(0));
                this.buf.append('-');
                this.generate(list.get(1));
                break;
            }
            case 11: {
                this.buf.append('[');
                if (object != null) {
                    this.buf.append((String)object);
                }
                if (list != null) {
                    this.generatingSetOfChars = true;
                    if (list.size() == 1) {
                        this.generate(list.get(0));
                    } else {
                        for (TreeNode treeNode2 : list) {
                            this.generate(treeNode2);
                        }
                    }
                    this.generatingSetOfChars = false;
                }
                this.buf.append(']');
                break;
            }
            case 2: {
                if (list == null) break;
                if (list.size() == 1) {
                    this.generate(list.get(0));
                    break;
                }
                for (TreeNode treeNode3 : list) {
                    this.generate(treeNode3);
                }
                break;
            }
            case 9: {
                this.buf.append('(').append('?').append(':');
                this.generate(list.get(0));
                this.buf.append(')');
                break;
            }
            case 1: {
                this.generate(list.get(0));
                if (list.size() <= 1) break;
                Iterator<TreeNode> iterator = list.iterator();
                iterator.next();
                do {
                    this.buf.append('|');
                    this.generate(iterator.next());
                } while (iterator.hasNext());
                break;
            }
            case 5: {
                this.buf.append(object.toString());
                break;
            }
            case 7: {
                int n2 = (Integer)object;
                this.buf.append((char)n2);
                break;
            }
            case 10: {
                this.buf.append('\\').append('p');
                this.buf.append('{');
                String string = (String)object;
                if (string.equals("ascii")) {
                    this.buf.append("ASCII");
                } else if (string.equals("xdigit")) {
                    this.buf.append("XDigit");
                } else {
                    this.buf.append(Character.toUpperCase(string.charAt(0)));
                    this.buf.append(string.substring(1));
                }
                this.buf.append('}');
                break;
            }
            case 0: {
                String string = (String)object;
                if (string != null && string.charAt(0) == '^') {
                    this.buf.append('^');
                }
                if (list != null) {
                    this.generate(list.get(0));
                }
                if (string == null || string.length() != 2 && string.charAt(0) != '$') break;
                this.buf.append('$');
                break;
            }
            case 13: {
                String string;
                String string2 = (String)object;
                String string3 = string = this.tokenReplacements != null ? this.tokenReplacements.get(string2) : null;
                if (string != null) {
                    this.buf.append('(').append('?').append(':');
                    this.buf.append(string);
                    this.buf.append(')');
                    break;
                }
                this.buf.append('{').append(string2).append('}');
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

