/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;

public class IntToStringCache {
    protected final List<String> cache;
    protected final int version;
    protected final long timestamp;
    private final Object oneItemCacheLock = new Lock();
    private String oneItemCacheString;
    private int oneItemCacheInt;

    public IntToStringCache() {
        this(System.currentTimeMillis());
    }

    public IntToStringCache(long l) {
        this.cache = new ArrayList<String>();
        this.version = RepositoryTranslatorImpl.getVersion();
        this.timestamp = l;
    }

    public IntToStringCache(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        this.cache = new ArrayList<String>();
        this.version = dataInput.readInt();
        this.timestamp = dataInput.readLong();
        int n = dataInput.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInput.readUTF();
            string = string.equals("") ? null : this.getFileKey(string);
            this.cache.add(string);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        assert (this.cache != null);
        assert (dataOutput != null);
        dataOutput.writeInt(this.version);
        dataOutput.writeLong(this.timestamp);
        int n = this.cache.size();
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            String string = this.cache.get(i);
            if (string == null) {
                dataOutput.writeUTF("");
                continue;
            }
            dataOutput.writeUTF(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(String string) {
        Object object;
        String string2 = null;
        int n = 0;
        Object object2 = this.oneItemCacheLock;
        synchronized (object2) {
            string2 = this.oneItemCacheString;
            n = this.oneItemCacheInt;
        }
        if (string.equals(string2)) {
            return n;
        }
        int n2 = this.cache.indexOf(string);
        if (n2 == -1) {
            object = this.cache;
            synchronized (object) {
                n2 = this.cache.indexOf(string);
                if (n2 == -1) {
                    n2 = this.makeId(string);
                }
            }
        }
        object = this.oneItemCacheLock;
        synchronized (object) {
            this.oneItemCacheString = string;
            this.oneItemCacheInt = n2;
        }
        return n2;
    }

    protected int makeId(String string) {
        string = this.getFileKey(string);
        this.cache.add(string);
        return this.cache.indexOf(string);
    }

    public String getValueById(int n) {
        return this.cache.get(n);
    }

    public boolean containsId(int n) {
        return 0 <= n && n < this.cache.size();
    }

    public boolean containsValue(String string) {
        return this.cache.contains(string);
    }

    public int size() {
        return this.cache.size();
    }

    public int getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    protected String getFileKey(String string) {
        return string;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

