/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.netbeans.modules.cnd.repository.queue.BaseQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueQueue<K, V>
extends BaseQueue {
    protected final Map<K, Entry<K, V>> map = new HashMap<K, Entry<K, V>>();
    private final EventsDispatcher<K, V> dispatcher = new EventsDispatcher(this);
    protected boolean active = true;

    public KeyValueQueue() {
        super(new BaseQueue.Queue());
        this.dispatcher.start();
    }

    public void addLast(K k, V v) {
        if (this.needsTrace()) {
            System.err.printf("%s: addLast %s\n", this.getTraceName(), k.toString());
        }
        this.dispatcher.newEvent(this.createEntry(k, v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLastImpl(K k, V v) {
        Object object = this.lock;
        synchronized (object) {
            Entry<K, V> entry = this.map.get(k);
            if (entry == null) {
                this.doAddLast(k, v);
                if (this.needsTrace()) {
                    System.err.printf("%s: added last %s\n", this.getTraceName(), k.toString());
                }
            } else {
                this.doReplaceAddLast(k, v, entry);
                if (this.needsTrace()) {
                    System.err.printf("%s: replaced last %s\n", this.getTraceName(), k.toString());
                }
            }
            this.lock.notifyAll();
        }
    }

    private Entry<K, V> doAddLast(K k, V v) {
        Entry<K, V> entry = this.createEntry(k, v);
        this.map.put(k, entry);
        this.queue.addLast(entry);
        return entry;
    }

    protected Entry<K, V> createEntry(K k, V v) {
        return new Entry<K, V>(k, v);
    }

    protected void doReplaceAddLast(K k, V v, Entry<K, V> entry) {
        ((Entry)entry).value = v;
    }

    protected void doReplaceAddFirst(K k, V v, Entry<K, V> entry) {
        ((Entry)entry).value = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> poll() throws InterruptedException {
        if (this.needsTrace()) {
            System.err.printf("%s: Polling...\n", this.getTraceName());
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            try {
                Entry entry2 = (Entry)this.queue.poll();
                if (entry2 != null) {
                    this.doPostPoll(entry2);
                    if (this.needsTrace()) {
                        System.err.printf("    %s: polling -> %s\n", this.getTraceName(), entry2.getKey());
                    }
                }
                entry = entry2;
                this.lock.notifyAll();
            }
            catch (Throwable throwable) {
                this.lock.notifyAll();
                throw throwable;
            }
            return entry;
        }
    }

    protected void doPostPoll(Entry<K, V> entry) {
        this.map.remove(entry.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K k) {
        if (this.needsTrace()) {
            System.err.printf("%s: Removing %s\n", this.getTraceName(), k);
        }
        Object object = this.lock;
        synchronized (object) {
            Entry<K, V> entry = this.map.remove(k);
            if (entry != null) {
                this.queue.remove(entry);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.active && !this.isReady()) {
                if (this.needsTrace()) {
                    System.err.printf("%s: waitReady() ...\n", this.getTraceName());
                }
                this.lock.wait();
                if (!this.needsTrace()) continue;
                System.err.printf("%s: waiting finished\n", this.getTraceName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disposable() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.active = false;
        this.dispatcher.interrupt();
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EventsDispatcher<KK, VV>
    extends Thread {
        private final KeyValueQueue<KK, VV> delegate;
        private final BlockingQueue<Entry<KK, VV>> queue = new LinkedBlockingQueue<Entry<KK, VV>>();

        public EventsDispatcher(KeyValueQueue<KK, VV> keyValueQueue) {
            super("CND Repository Queue Dispatcher");
            this.delegate = keyValueQueue;
        }

        void newEvent(Entry<KK, VV> entry) {
            this.queue.add(entry);
        }

        void handleEvent(KK KK, VV VV) {
            ((KeyValueQueue)this.delegate).addLastImpl(KK, VV);
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Entry<KK, VV> entry;
                    try {
                        entry = this.queue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    this.handleEvent(((Entry)entry).key, ((Entry)entry).value);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<KK, VV>
    extends BaseQueue.AbstractEntry {
        private KK key;
        private VV value;

        protected Entry(KK KK, VV VV) {
            assert (KK != null);
            assert (VV != null);
            this.key = KK;
            this.value = VV;
        }

        public KK getKey() {
            return this.key;
        }

        public VV getValue() {
            return this.value;
        }
    }
}

