/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import org.netbeans.modules.cnd.repository.queue.StopWatch;

public class BaseQueue {
    protected final Object lock = new Lock();
    protected StopWatch stopWatch = this.needsTiming() ? new StopWatch(false) : null;
    protected final Queue queue;

    public BaseQueue(Queue queue) {
        this.queue = queue;
    }

    protected boolean needsTiming() {
        return false;
    }

    protected boolean needsTrace() {
        return false;
    }

    protected String getTraceName() {
        return this.getClass().getName() + '@' + this.hashCode();
    }

    private static final class Lock {
        private Lock() {
        }
    }

    protected static class Queue {
        private AbstractEntry head;
        private AbstractEntry tail;

        protected Queue() {
        }

        private void link(AbstractEntry abstractEntry, AbstractEntry abstractEntry2) {
            if (abstractEntry != null) {
                abstractEntry.next = abstractEntry2;
            }
            if (abstractEntry2 != null) {
                abstractEntry2.prev = abstractEntry;
            }
        }

        public void addFirst(AbstractEntry abstractEntry) {
            this.link(abstractEntry, this.head);
            this.head = abstractEntry;
            if (this.tail == null) {
                this.tail = this.head;
            }
            abstractEntry.prev = null;
        }

        public void addLast(AbstractEntry abstractEntry) {
            if (this.tail == null) {
                assert (this.head == null);
                this.addFirst(abstractEntry);
            } else {
                this.link(this.tail, abstractEntry);
                this.tail = abstractEntry;
            }
            abstractEntry.next = null;
        }

        public void remove(AbstractEntry abstractEntry) {
            this.link(abstractEntry.prev, abstractEntry.next);
            if (this.head == abstractEntry) {
                this.head = abstractEntry.next;
            }
            if (this.tail == abstractEntry) {
                this.tail = abstractEntry.prev;
            }
        }

        public void clear() {
            this.tail = null;
            this.head = null;
        }

        public AbstractEntry peek() {
            return this.head;
        }

        public boolean isEmpty() {
            return this.head == null;
        }

        public AbstractEntry poll() {
            AbstractEntry abstractEntry = this.head;
            if (this.head != null) {
                this.remove(this.head);
            }
            return abstractEntry;
        }
    }

    protected static abstract class AbstractEntry {
        private AbstractEntry prev;
        private AbstractEntry next;

        protected AbstractEntry() {
        }
    }
}

