/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.selector.nodes.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.selector.nodes.web.servlet.ServletNode;
import org.netbeans.modules.profiler.j2ee.ui.Utils;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.GreedySelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ServletsNode
extends ContainerNode {
    private static final String SERVLETS_STRING = NbBundle.getMessage(ServletsNode.class, (String)"ServletsNode_ServletsString");

    public ServletsNode(ContainerNode containerNode) {
        super(SERVLETS_STRING, (Icon)Utils.PACKAGE_ICON, containerNode);
    }

    protected SelectorChildren getChildren() {
        return new Children();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Children
    extends GreedySelectorChildren<ServletsNode> {
        private final Set<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();

        public Children() {
            this.scope.add(ClassIndex.SearchScope.SOURCE);
            this.scope.add(ClassIndex.SearchScope.DEPENDENCIES);
        }

        protected List<SelectorNode> prepareChildren(ServletsNode servletsNode) {
            HashSet<SelectorNode> hashSet = new HashSet<SelectorNode>();
            try {
                Project project = (Project)servletsNode.getLookup().lookup(Project.class);
                ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)project);
                Collection<FileObject> collection = WebProjectUtils.getDeploymentDescriptorFileObjects(project, true);
                for (FileObject fileObject : collection) {
                    this.enumerateServlets(classpathInfo, servletsNode, fileObject, hashSet);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return new ArrayList<SelectorNode>(hashSet);
        }

        private void enumerateServlets(final ClasspathInfo classpathInfo, final ServletsNode servletsNode, FileObject fileObject, final Collection<SelectorNode> collection) throws IllegalArgumentException, IOException {
            final WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
            final HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Servlet servlet : webApp.getServlet()) {
                hashMap.put(servlet.getServletName(), servlet.getServletClass());
            }
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    for (ServletMapping servletMapping : webApp.getServletMapping()) {
                        TypeElement typeElement;
                        String string = (String)hashMap.get(servletMapping.getServletName());
                        TypeElement typeElement2 = typeElement = string != null ? compilationController.getElements().getTypeElement(string) : null;
                        if (typeElement == null) continue;
                        collection.add(new ServletNode(classpathInfo, typeElement, servletMapping.getServletName(), servletMapping.getUrlPattern(), servletsNode));
                    }
                }
            }, true);
        }
    }
}

