/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.CheckPHPVersionVisitor;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.PHPRuleWithPreferences;
import org.netbeans.modules.php.editor.verification.PHPVerificationVisitor;
import org.netbeans.modules.php.editor.verification.UnusedVariableRule;
import org.netbeans.modules.php.editor.verification.VarStackReadingRule;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPHintsProvider
implements HintsProvider {
    public static final String FIRST_PASS_HINTS = "1st pass";
    public static final String SECOND_PASS_HINTS = "2nd pass";
    public static final String DEFAULT_LINE_HINTS = "default.line.hints";
    private static final Logger LOGGER = Logger.getLogger(PHPHintsProvider.class.getName());

    public void computeHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list) {
        Model model;
        long l = LOGGER.isLoggable(Level.FINE) ? System.currentTimeMillis() : 0L;
        ParserResult parserResult = ruleContext.parserResult;
        Map map = hintsManager.getHints(false, ruleContext);
        List list2 = (List)map.get(DEFAULT_LINE_HINTS);
        if (list2 != null) {
            FileScope fileScope;
            PHPRuleContext pHPRuleContext = (PHPRuleContext)ruleContext;
            PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
            model = pHPParseResult.getModel();
            pHPRuleContext.fileScope = fileScope = model.getFileScope();
            for (Rule.AstRule astRule : list2) {
                if (!hintsManager.isEnabled((Rule.UserConfigurableRule)astRule) || !(astRule instanceof AbstractRule)) continue;
                AbstractRule abstractRule = (AbstractRule)astRule;
                try {
                    abstractRule.computeHintsImpl(pHPRuleContext, list, Kind.HINT);
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
            }
        }
        this.computeExperimentalHints(ruleContext, map, hintsManager, list);
        if (LOGGER.isLoggable(Level.FINE)) {
            long l2 = Calendar.getInstance().getTimeInMillis() - l;
            model = parserResult.getSnapshot().getSource().getFileObject();
            LOGGER.fine(String.format("Computing PHP hints for %s.%s took %d ms", model.getName(), model.getExt(), l2));
        }
    }

    public void computeSuggestions(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n) {
        Map map = hintsManager.getHints(true, ruleContext);
        List list2 = (List)map.get(DEFAULT_LINE_HINTS);
        if (list2 != null) {
            FileScope fileScope;
            PHPRuleContext pHPRuleContext = (PHPRuleContext)ruleContext;
            ParserResult parserResult = ruleContext.parserResult;
            if (!(parserResult instanceof PHPParseResult)) {
                return;
            }
            PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
            Model model = pHPParseResult.getModel();
            pHPRuleContext.fileScope = fileScope = model.getFileScope();
            for (Rule.AstRule astRule : list2) {
                if (!hintsManager.isEnabled((Rule.UserConfigurableRule)astRule) || !(astRule instanceof AbstractRule)) continue;
                AbstractRule abstractRule = (AbstractRule)astRule;
                try {
                    abstractRule.computeHintsImpl(pHPRuleContext, list, Kind.SUGGESTION);
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
            }
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n, int n2) {
    }

    public void computeErrors(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, List<Error> list2) {
        PHPParseResult pHPParseResult;
        List list3;
        ParserResult parserResult = ruleContext.parserResult;
        if (parserResult != null) {
            list3 = parserResult.getDiagnostics();
            list2.addAll(list3);
        }
        if ((list3 = NbEditorUtilities.getFileObject((Document)ruleContext.doc)) != null && CheckPHPVersionVisitor.appliesTo((FileObject)list3) && (pHPParseResult = (PHPParseResult)ruleContext.parserResult).getProgram() != null) {
            CheckPHPVersionVisitor checkPHPVersionVisitor = new CheckPHPVersionVisitor((FileObject)list3);
            pHPParseResult.getProgram().accept(checkPHPVersionVisitor);
            list2.addAll(checkPHPVersionVisitor.getErrors());
        }
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return Collections.emptyList();
    }

    public RuleContext createRuleContext() {
        return new PHPRuleContext();
    }

    private void computeExperimentalHints(RuleContext ruleContext, Map<?, List<? extends Rule.AstRule>> map, HintsProvider.HintsManager hintsManager, List<Hint> list) {
        List<Rule.AstRule> list2;
        ArrayList<PHPRule> arrayList = new ArrayList<PHPRule>();
        for (Rule.AstRule object22 : map.get(FIRST_PASS_HINTS)) {
            PHPRule pHPRule;
            if (!(object22 instanceof PHPRule) || !hintsManager.isEnabled((Rule.UserConfigurableRule)(pHPRule = (PHPRule)object22))) continue;
            arrayList.add(pHPRule);
            if (!(pHPRule instanceof PHPRuleWithPreferences)) continue;
            list2 = (PHPRuleWithPreferences)((Object)pHPRule);
            list2.setPreferences(hintsManager.getPreferences((Rule.UserConfigurableRule)pHPRule));
        }
        boolean bl = false;
        block1: for (List<Rule.AstRule> list3 : map.values()) {
            for (Rule.AstRule astRule : list3) {
                VarStackReadingRule varStackReadingRule;
                if (!(astRule instanceof VarStackReadingRule) || !hintsManager.isEnabled((Rule.UserConfigurableRule)(varStackReadingRule = (VarStackReadingRule)astRule))) continue;
                bl = true;
                LOGGER.fine(varStackReadingRule.getClass().getName() + " is enabled, turning on the VarStack");
                continue block1;
            }
        }
        PHPVerificationVisitor pHPVerificationVisitor = new PHPVerificationVisitor((PHPRuleContext)ruleContext, arrayList, bl);
        PHPParseResult pHPParseResult = (PHPParseResult)ruleContext.parserResult;
        if (pHPParseResult.getProgram() != null) {
            pHPParseResult.getProgram().accept(pHPVerificationVisitor);
        }
        list.addAll(pHPVerificationVisitor.getResult());
        list2 = map.get(SECOND_PASS_HINTS);
        if (list2 != null && list2.size() > 0) {
            Rule.AstRule astRule;
            assert (list2.size() == 1);
            astRule = (UnusedVariableRule)list2.get(0);
            if (hintsManager.isEnabled((Rule.UserConfigurableRule)astRule)) {
                astRule.check((PHPRuleContext)ruleContext, list);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Kind {
        HINT,
        SUGGESTION,
        SELECTION,
        ERROR;

    }
}

