/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.php.editor.parser.ASTPHP5Parser;
import org.netbeans.modules.php.editor.parser.ASTPHP5Scanner;
import org.netbeans.modules.php.editor.parser.PHP5ErrorHandler;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class GSFPHPParser
extends Parser
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(GSFPHPParser.class.getName());
    private boolean shortTags = true;
    private boolean aspTags = false;
    private ParserResult result = null;
    private boolean projectPropertiesListenerAdded = false;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        FileObject fileObject = snapshot.getSource().getFileObject();
        LOGGER.fine("parseFiles " + fileObject);
        PhpLanguageOptions.Properties properties = PhpLanguageOptions.getDefault().getProperties(fileObject);
        if (!this.projectPropertiesListenerAdded) {
            PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)properties);
            PhpLanguageOptions.getDefault().addPropertyChangeListener(propertyChangeListener);
            this.projectPropertiesListenerAdded = true;
        }
        this.shortTags = properties.areShortTagsEnabled();
        this.aspTags = properties.areAspTagsEnabled();
        int n = 0;
        try {
            String string = ((Object)snapshot.getText()).toString();
            n = string.length();
            int n2 = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)sourceModificationEvent);
            LOGGER.fine("caretOffset: " + n2);
            Context context = new Context(snapshot, string, n2);
            this.result = this.parseBuffer(context, Sanitize.NONE, null);
        }
        catch (Exception exception) {
            LOGGER.fine("Exception during parsing: " + exception);
            ASTError aSTError = new ASTError(0, n);
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            arrayList.add(aSTError);
            Program program = new Program(0, n, arrayList, Collections.<Comment>emptyList());
            this.result = new PHPParseResult(snapshot, program);
        }
    }

    protected PHPParseResult parseBuffer(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) throws Exception {
        PHPParseResult pHPParseResult;
        boolean bl = false;
        String string = context.source;
        if (pHP5ErrorHandler == null) {
            pHP5ErrorHandler = new PHP5ErrorHandler(context, this);
        }
        if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
            boolean bl2 = this.sanitizeSource(context, sanitize, pHP5ErrorHandler);
            if (bl2) {
                assert (context.sanitizedSource != null);
                bl = true;
                string = context.sanitizedSource;
            } else {
                return this.sanitize(context, sanitize, pHP5ErrorHandler);
            }
        }
        ASTPHP5Scanner aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
        ASTPHP5Parser aSTPHP5Parser = new ASTPHP5Parser(aSTPHP5Scanner);
        aSTPHP5Parser.setErrorHandler(pHP5ErrorHandler);
        Symbol symbol = aSTPHP5Parser.parse();
        if (aSTPHP5Scanner.getCurlyBalance() != 0 && !bl) {
            this.sanitizeSource(context, Sanitize.MISSING_CURLY, null);
            if (context.sanitizedSource != null) {
                context.source = context.getSanitizedSource();
                string = context.source;
                aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
                aSTPHP5Parser = new ASTPHP5Parser(aSTPHP5Scanner);
                symbol = aSTPHP5Parser.parse();
            }
        }
        if (symbol != null) {
            Program program = null;
            if (symbol.value instanceof Program) {
                program = (Program)symbol.value;
                List<Statement> list = program.getStatements();
                boolean bl3 = true;
                for (Statement statement : list) {
                    if (!(statement instanceof ASTError)) continue;
                    String string2 = "<?" + string.substring(statement.getStartOffset(), statement.getEndOffset()) + "?>";
                    ASTPHP5Scanner aSTPHP5Scanner2 = new ASTPHP5Scanner(new StringReader(string2), this.shortTags, this.aspTags);
                    Symbol symbol2 = aSTPHP5Scanner2.next_token();
                    while (symbol2.sym != 0) {
                        if (symbol2.sym == 47 || symbol2.sym == 34) {
                            bl3 = false;
                            break;
                        }
                        symbol2 = aSTPHP5Scanner2.next_token();
                    }
                    if (bl3) continue;
                    break;
                }
                pHPParseResult = bl3 ? new PHPParseResult(context.getSnapshot(), program) : this.sanitize(context, sanitize, pHP5ErrorHandler);
            } else {
                LOGGER.fine("The parser value is not a Program: " + symbol.value);
                pHPParseResult = this.sanitize(context, sanitize, pHP5ErrorHandler);
            }
            pHPParseResult.setErrors(pHP5ErrorHandler.displaySyntaxErrors(program));
        } else {
            pHPParseResult = this.sanitize(context, sanitize, pHP5ErrorHandler);
            pHPParseResult.setErrors(pHP5ErrorHandler.displayFatalError());
        }
        return pHPParseResult;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) {
        List<PHP5ErrorHandler.SyntaxError> list;
        if (sanitize == Sanitize.SYNTAX_ERROR_CURRENT && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            int n;
            int n2;
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.sanitized == Sanitize.NONE ? context.source : context.sanitizedSource;
            String string2 = string.substring(n2 = syntaxError.getCurrentToken().left, n = syntaxError.getCurrentToken().right);
            if ("}".equals(string2)) {
                return false;
            }
            context.sanitizedSource = string.substring(0, n2) + Utils.getSpaces(n - n2) + string.substring(n);
            context.sanitizedRange = new OffsetRange(n2, n);
            return true;
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_PREVIOUS && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            int n;
            int n3;
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.source;
            if (string.substring(n3 = syntaxError.getPreviousToken().left, n = syntaxError.getPreviousToken().right).equals("}")) {
                return false;
            }
            context.sanitizedSource = string.substring(0, n3) + Utils.getSpaces(n - n3) + string.substring(n);
            context.sanitizedRange = new OffsetRange(n3, n);
            return true;
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_PREVIOUS_LINE && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.source;
            int n = Utils.getRowEnd(string, syntaxError.getPreviousToken().right);
            int n4 = Utils.getRowStart(string, syntaxError.getPreviousToken().left);
            StringBuffer stringBuffer = new StringBuffer(n - n4);
            for (int i = n4; i < n; ++i) {
                if (string.charAt(i) == ' ' || string.charAt(i) == '}' || string.charAt(i) == '\n' || string.charAt(i) == '\r') {
                    stringBuffer.append(string.charAt(i));
                    continue;
                }
                stringBuffer.append(' ');
            }
            context.sanitizedSource = string.substring(0, n4) + stringBuffer.toString() + string.substring(n);
            context.sanitizedRange = new OffsetRange(n4, n);
            return true;
        }
        if (sanitize == Sanitize.EDITED_LINE && context.caretOffset > -1) {
            list = context.getSource();
            int n = context.caretOffset - 1;
            int n5 = context.caretOffset;
            char c = ((String)((Object)list)).charAt(n);
            while (n > 0 && c != '\n' && c != '\r' && c != '{' && c != '}') {
                c = ((String)((Object)list)).charAt(--n);
            }
            ++n;
            if (n5 < ((String)((Object)list)).length()) {
                c = ((String)((Object)list)).charAt(n5);
                while (n5 < ((String)((Object)list)).length() && c != '\n' && c != '\r' && c != '{' && c != '}') {
                    c = ((String)((Object)list)).charAt(n5++);
                }
            }
            context.sanitizedSource = ((String)((Object)list)).substring(0, n) + Utils.getSpaces(n5 - n) + ((String)((Object)list)).substring(n5);
            context.sanitizedRange = new OffsetRange(n, n5);
            return true;
        }
        if (sanitize == Sanitize.MISSING_CURLY) {
            return this.sanitizeCurly(context);
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_BLOCK && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            return this.sanitizeRemoveBlock(context, syntaxError.getCurrentToken().left);
        }
        return false;
    }

    protected boolean sanitizeCurly(Context context) {
        int n;
        String string = context.getSource();
        ASTPHP5Scanner aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
        Symbol symbol = null;
        Symbol symbol2 = null;
        int n2 = 0;
        int n3 = 0;
        try {
            symbol2 = aSTPHP5Scanner.next_token();
            n = 0;
            int n4 = -1;
            while (symbol2.sym != 0) {
                switch (symbol2.sym) {
                    case 47: {
                        char c;
                        if (n == 0) {
                            n = 1;
                            break;
                        }
                        int n5 = symbol2.left;
                        int n6 = n3;
                        for (int i = 0; i < n6; ++i) {
                            c = string.charAt(--n5);
                            while (n5 > n4 && c != '}' && c != '\n' && c != '\r' && c != '\t' && c != ' ') {
                                c = string.charAt(--n5);
                            }
                            if (c == '}' || c == '{') continue;
                            string = string.substring(0, n5) + '}' + string.substring(n5 + 1);
                            --n3;
                        }
                        if (n3 > 0) {
                            c = string.charAt(--n5);
                            while (n5 > 0 && c != '}' && c != '\n' && c != '\r') {
                                c = string.charAt(--n5);
                            }
                            if (c == '}') {
                                c = string.charAt(--n5);
                            }
                            while (n5 < string.length() && n3 > 0 && (c == '\n' || c == '\r' || c == '\t' || c == ' ')) {
                                string = string.substring(0, n5) + '}' + string.substring(n5 + 1);
                                --n3;
                                c = string.charAt(--n5);
                            }
                        }
                        context.sanitizedSource = string;
                        break;
                    }
                    case 63: 
                    case 64: {
                        if (n != 0) {
                            ++n3;
                            n4 = symbol2.left;
                            break;
                        }
                        ++n2;
                        break;
                    }
                    case 65: {
                        if (n != 0) {
                            if (--n3 != 0) break;
                            n = 0;
                            break;
                        }
                        --n2;
                    }
                }
                if (symbol2.sym != 10) {
                    symbol = symbol2;
                }
                symbol2 = aSTPHP5Scanner.next_token();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Exception during calculating missing }", iOException);
        }
        n = n2 + n3;
        if (n > 0 && symbol != null) {
            String string2 = string.substring(symbol.left, symbol.right).trim();
            if ("?>".equals(string2)) {
                context.sanitizedSource = string.substring(0, symbol.left) + Utils.getRepeatingChars('}', n) + string.substring(symbol.left);
                context.sanitizedRange = new OffsetRange(symbol.left, symbol.left + n);
                return true;
            }
            if (symbol2.sym == 0) {
                context.sanitizedSource = string.substring(0, symbol2.left) + Utils.getRepeatingChars('}', n) + string.substring(symbol2.left);
                context.sanitizedRange = new OffsetRange(symbol2.left, symbol2.left + n);
                return true;
            }
        }
        return false;
    }

    private boolean sanitizeRemoveBlock(Context context, int n) {
        String string = context.getSource();
        ASTPHP5Scanner aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
        Symbol symbol = null;
        int n2 = -1;
        int n3 = -1;
        try {
            symbol = aSTPHP5Scanner.next_token();
            while (symbol.sym != 0 && n3 == -1) {
                if (symbol.sym == 64 && symbol.left <= n) {
                    n2 = symbol.right;
                }
                if (symbol.sym == 65 && symbol.left >= n) {
                    n3 = symbol.right - 1;
                }
                symbol = aSTPHP5Scanner.next_token();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Exception during removing block", iOException);
        }
        if (n2 > -1 && n2 < n3) {
            context.sanitizedSource = string.substring(0, n2) + Utils.getSpaces(n3 - n2) + string.substring(n3);
            context.sanitizedRange = new OffsetRange(n2, n3);
            return true;
        }
        return false;
    }

    private PHPParseResult sanitize(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) throws Exception {
        switch (sanitize) {
            case NONE: 
            case MISSING_CURLY: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_CURRENT, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_CURRENT: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS_LINE, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS_LINE: {
                return this.parseBuffer(context, Sanitize.EDITED_LINE, pHP5ErrorHandler);
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_BLOCK, pHP5ErrorHandler);
            }
        }
        int n = context.getSource().length();
        ASTError aSTError = new ASTError(0, n);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        arrayList.add(aSTError);
        Program program = new Program(0, n, arrayList, Collections.<Comment>emptyList());
        return new PHPParseResult(context.getSnapshot(), program);
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (PhpLanguageOptions.PROP_PHP_VERSION.equals(propertyChangeEvent.getPropertyName())) {
            this.forceReparsing();
        }
    }

    private void forceReparsing() {
        this.changeSupport.fireChange();
    }

    public static class Context {
        private final Snapshot snapshot;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;

        public Context(Snapshot snapshot, String string, int n) {
            this.snapshot = snapshot;
            this.source = string;
            this.caretOffset = n;
        }

        public String toString() {
            return "PHPParser.Context(" + this.snapshot.getSource().getFileObject() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public String getSource() {
            return this.source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        SYNTAX_ERROR_CURRENT,
        SYNTAX_ERROR_PREVIOUS,
        SYNTAX_ERROR_PREVIOUS_LINE,
        SYNTAX_ERROR_BLOCK,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_CURLY;

    }
}

