/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedClassMember;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Dispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemiAttribute
extends DefaultVisitor {
    private static final List<String> SUPERGLOBALS = Arrays.asList("GLOBALS", "_SERVER", "_GET", "_POST", "_FILES", "_COOKIE", "_SESSION", "_REQUEST", "_ENV");
    public DefinitionScope global;
    private Stack<DefinitionScope> scopes = new Stack();
    private Map<ASTNode, AttributedElement> node2Element = new HashMap<ASTNode, AttributedElement>();
    private int offset;
    private ParserResult info;
    private Stack<ASTNode> nodes = new Stack();
    private Collection<IndexedElement> name2ElementCache;
    private static Map<ParserResult, SemiAttribute> info2Attr = new WeakHashMap<ParserResult, SemiAttribute>();

    public SemiAttribute(ParserResult parserResult) {
        this(parserResult, -1);
    }

    public SemiAttribute(ParserResult parserResult, int n) {
        this.offset = n;
        this.info = parserResult;
        this.global = new DefinitionScope();
        this.scopes.push(this.global);
    }

    @Override
    public void scan(ASTNode aSTNode) {
        if (aSTNode == null) {
            return;
        }
        if (this.offset != -1 && this.offset <= aSTNode.getStartOffset()) {
            throw new Stop();
        }
        this.nodes.push(aSTNode);
        super.scan(aSTNode);
        this.nodes.pop();
        if (this.offset != -1 && this.offset <= aSTNode.getEndOffset()) {
            throw new Stop();
        }
    }

    @Override
    public void visit(Program program) {
        this.performEnterPass(this.global, program.getStatements());
        super.visit(program);
    }

    @Override
    public void visit(Assignment assignment) {
        VariableBase variableBase = assignment.getLeftHandSide();
        if (variableBase instanceof Variable) {
            Variable variable;
            String string;
            Object object;
            ClassType classType = null;
            Expression expression = assignment.getRightHandSide();
            if (expression instanceof Reference) {
                expression = ((Reference)expression).getExpression();
            }
            if (expression instanceof ClassInstanceCreation) {
                Identifier identifier;
                ClassElement classElement;
                object = (ClassInstanceCreation)expression;
                Expression expression2 = ((ClassInstanceCreation)object).getClassName().getName();
                if (expression2 instanceof Identifier && (classElement = (ClassElement)this.lookup((identifier = (Identifier)expression2).getName(), AttributedElement.Kind.CLASS)) != null) {
                    classType = new ClassType(classElement);
                }
            } else if (expression instanceof FieldAccess && (string = SemiAttribute.extractVariableName(variable = ((FieldAccess)(object = (FieldAccess)expression)).getField())) != null) {
                this.node2Element.put(variableBase, this.scopes.peek().enterWrite(string, AttributedElement.Kind.VARIABLE, (ASTNode)object, classType));
            }
            object = SemiAttribute.extractVariableName((Variable)variableBase);
            if (object != null) {
                this.node2Element.put(variableBase, this.scopes.peek().enterWrite((String)object, AttributedElement.Kind.VARIABLE, variableBase, classType));
            }
        }
        super.visit(assignment);
    }

    @Override
    public void visit(FunctionDeclaration functionDeclaration) {
        String string = functionDeclaration.getFunctionName().getName();
        FunctionElement functionElement = (FunctionElement)this.global.enterWrite(string, AttributedElement.Kind.FUNC, functionDeclaration);
        DefinitionScope definitionScope = this.scopes.peek();
        if (!this.node2Element.containsKey(functionDeclaration)) {
            assert (!definitionScope.classScope);
            this.node2Element.put(functionDeclaration, functionElement);
        }
        this.scopes.push(functionElement.enclosedElements);
        if (definitionScope.classScope) {
            assert (definitionScope.thisVar != null);
            this.scopes.peek().enter(definitionScope.thisVar.name, definitionScope.thisVar.getKind(), definitionScope.thisVar);
        }
        super.visit(functionDeclaration);
        this.scopes.pop();
    }

    @Override
    public void visit(InstanceOfExpression instanceOfExpression) {
        Collection<AttributedElement> collection;
        Object object;
        Expression expression;
        ClassName className = instanceOfExpression.getClassName();
        if (className != null) {
            expression = className.getName();
            Object object2 = object = expression instanceof Identifier ? ((Identifier)expression).getName() : null;
            if (object != null) {
                collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, new String[]{object});
                if (!collection.isEmpty()) {
                    this.node2Element.put(expression, this.lookup((String)object, AttributedElement.Kind.CLASS));
                } else {
                    this.node2Element.put(expression, this.lookup((String)object, AttributedElement.Kind.IFACE));
                }
            }
        }
        if ((expression = instanceOfExpression.getExpression()) instanceof Variable) {
            object = (Variable)expression;
            collection = SemiAttribute.extractVariableName((Variable)object);
            if (object != null && collection != null) {
                this.node2Element.put((ASTNode)object, this.scopes.peek().enterWrite((String)((Object)collection), AttributedElement.Kind.VARIABLE, (ASTNode)object));
            }
        }
        super.visit(instanceOfExpression);
    }

    @Override
    public void visit(CatchClause catchClause) {
        Collection<AttributedElement> collection;
        Object object;
        Identifier identifier = catchClause.getClassName() != null ? CodeUtils.extractUnqualifiedIdentifier(catchClause.getClassName()) : null;
        AttributedElement attributedElement = null;
        if (identifier != null) {
            object = identifier.getName();
            collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, new String[]{object});
            if (!collection.isEmpty()) {
                attributedElement = this.lookup((String)object, AttributedElement.Kind.CLASS);
                this.node2Element.put(identifier, attributedElement);
            } else {
                attributedElement = this.lookup((String)object, AttributedElement.Kind.IFACE);
                this.node2Element.put(identifier, attributedElement);
            }
        }
        object = catchClause.getVariable();
        collection = SemiAttribute.extractVariableName((Variable)object);
        if (object != null && collection != null) {
            this.node2Element.put((ASTNode)object, this.scopes.peek().enterWrite((String)((Object)collection), AttributedElement.Kind.VARIABLE, (ASTNode)object));
        }
        super.visit(catchClause);
    }

    @Override
    public void visit(FormalParameter formalParameter) {
        Object object;
        Object object2;
        Variable variable = null;
        if (formalParameter.getParameterName() instanceof Reference) {
            object2 = (Reference)formalParameter.getParameterName();
            object = ((Reference)object2).getExpression();
            if (object instanceof Variable) {
                variable = (Variable)object;
            }
        } else if (formalParameter.getParameterName() instanceof Variable) {
            variable = (Variable)formalParameter.getParameterName();
        }
        if (variable != null && (object2 = SemiAttribute.extractVariableName(variable)) != null) {
            this.scopes.peek().enterWrite((String)object2, AttributedElement.Kind.VARIABLE, variable);
        }
        Object object3 = object2 = formalParameter.getParameterType() != null ? CodeUtils.extractUnqualifiedIdentifier(formalParameter.getParameterType()) : null;
        if (object2 != null && (object = ((Identifier)object2).getName()) != null) {
            Collection<AttributedElement> collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, new String[]{object});
            if (!collection.isEmpty()) {
                this.node2Element.put((ASTNode)object2, this.lookup((String)object, AttributedElement.Kind.CLASS));
            } else {
                this.node2Element.put((ASTNode)object2, this.lookup((String)object, AttributedElement.Kind.IFACE));
            }
        }
        super.visit(formalParameter);
    }

    @Override
    public void visit(Variable variable) {
        String string;
        if (!this.node2Element.containsKey(variable) && (string = SemiAttribute.extractVariableName(variable)) != null) {
            this.node2Element.put(variable, this.lookup(string, AttributedElement.Kind.VARIABLE));
        }
        super.visit(variable);
    }

    @Override
    public void visit(FunctionInvocation functionInvocation) {
        Object object;
        Expression expression = functionInvocation.getFunctionName().getName();
        String string = null;
        if (expression instanceof Identifier) {
            string = ((Identifier)expression).getName();
        }
        if (expression instanceof Variable && (object = ((Variable)expression).getName()) instanceof Identifier) {
            string = ((Identifier)object).getName();
        }
        if (string != null) {
            String string2;
            Object object2;
            object = null;
            ASTNode aSTNode = this.nodes.pop();
            ASTNode aSTNode2 = this.nodes.peek();
            this.nodes.push(aSTNode);
            if (aSTNode2 instanceof MethodInvocation) {
                object2 = this.resolveTypeSimple((Dispatch)aSTNode2);
                if (object2 != null) {
                    object = ((ClassElement)object2).lookup(string, AttributedElement.Kind.FUNC);
                }
            } else if (aSTNode2 instanceof StaticMethodInvocation) {
                object2 = (StaticMethodInvocation)aSTNode2;
                string2 = CodeUtils.extractUnqualifiedClassName((StaticDispatch)object2);
                Collection<AttributedElement> collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, string2);
                if (!collection.isEmpty()) {
                    String string3 = string2;
                    if ("parent".equals(string2)) {
                        string3 = this.getContextSuperClassName();
                    } else if ("self".equals(string2)) {
                        string3 = this.getContextClassName();
                    }
                    for (AttributedElement attributedElement : collection) {
                        ClassElement classElement = (ClassElement)attributedElement;
                        if (classElement == null || string3 != null && !string3.equals(classElement.getName()) || (object = classElement.lookup(string, AttributedElement.Kind.FUNC)) == null) continue;
                        this.node2Element.put(((StaticDispatch)object2).getClassName(), classElement);
                        this.node2Element.put((ASTNode)object2, (AttributedElement)object);
                        this.node2Element.put(((StaticMethodInvocation)object2).getMethod(), (AttributedElement)object);
                        break;
                    }
                }
            } else {
                object = this.lookup(string, AttributedElement.Kind.FUNC);
            }
            this.node2Element.put(functionInvocation, (AttributedElement)object);
            if ("define".equals(string) && functionInvocation.getParameters().size() == 2 && (object2 = functionInvocation.getParameters().get(0)) instanceof Scalar && ((Scalar)object2).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(string2 = ((Scalar)object2).getStringValue())) {
                this.node2Element.put((ASTNode)object2, this.global.enterWrite(NavUtils.dequote(string2), AttributedElement.Kind.CONST, (ASTNode)object2));
            }
        }
        if (this.node2Element.containsKey(functionInvocation)) {
            this.scan(functionInvocation.getParameters());
        } else {
            super.visit(functionInvocation);
        }
    }

    @Override
    public void visit(InterfaceDeclaration interfaceDeclaration) {
        String string = interfaceDeclaration.getName().getName();
        ClassElement classElement = (ClassElement)this.global.enterWrite(string, AttributedElement.Kind.IFACE, interfaceDeclaration);
        this.node2Element.put(interfaceDeclaration, classElement);
        List<Expression> list = interfaceDeclaration.getInterfaes();
        for (Expression expression : list) {
            ClassElement classElement2 = (ClassElement)this.lookup(CodeUtils.extractUnqualifiedName(expression), AttributedElement.Kind.IFACE);
            classElement.ifaces.add(classElement2);
            this.node2Element.put(expression, classElement2);
        }
        this.scopes.push(classElement.enclosedElements);
        if (interfaceDeclaration.getBody() != null) {
            this.performEnterPass(classElement.enclosedElements, interfaceDeclaration.getBody().getStatements());
        }
        super.visit(interfaceDeclaration);
        this.scopes.pop();
    }

    @Override
    public void visit(ClassDeclaration classDeclaration) {
        Identifier identifier;
        String string = classDeclaration.getName().getName();
        ClassElement classElement = (ClassElement)this.global.enterWrite(string, AttributedElement.Kind.CLASS, classDeclaration);
        this.node2Element.put(classDeclaration, classElement);
        Identifier identifier2 = identifier = classDeclaration.getSuperClass() != null ? CodeUtils.extractUnqualifiedIdentifier(classDeclaration.getSuperClass()) : null;
        if (identifier != null) {
            classElement.superClass = (ClassElement)this.lookup(identifier.getName(), AttributedElement.Kind.CLASS);
        }
        List<Expression> list = classDeclaration.getInterfaes();
        for (Expression expression : list) {
            ClassElement classElement2 = (ClassElement)this.lookup(CodeUtils.extractUnqualifiedName(expression), AttributedElement.Kind.IFACE);
            classElement.ifaces.add(classElement2);
            this.node2Element.put(expression, classElement2);
        }
        this.scopes.push(classElement.enclosedElements);
        if (classDeclaration.getBody() != null) {
            this.performEnterPass(classElement.enclosedElements, classDeclaration.getBody().getStatements());
        }
        super.visit(classDeclaration);
        this.scopes.pop();
    }

    @Override
    public void visit(ClassInstanceCreation classInstanceCreation) {
        Expression expression = classInstanceCreation.getClassName().getName();
        if (expression instanceof Identifier) {
            this.node2Element.put(classInstanceCreation, this.lookup(((Identifier)expression).getName(), AttributedElement.Kind.CLASS));
        }
        super.visit(classInstanceCreation);
    }

    @Override
    public void visit(GlobalStatement globalStatement) {
        for (Variable variable : globalStatement.getVariables()) {
            String string = SemiAttribute.extractVariableName(variable);
            if (string == null) continue;
            this.enterGlobalVariable(string);
        }
        super.visit(globalStatement);
    }

    @Override
    public void visit(Scalar scalar) {
        if (scalar.getScalarType() == Scalar.Type.STRING && !NavUtils.isQuoted(scalar.getStringValue())) {
            AttributedElement attributedElement = this.global.lookup(scalar.getStringValue(), AttributedElement.Kind.CONST);
            this.node2Element.put(scalar, attributedElement);
        }
        super.visit(scalar);
    }

    @Override
    public void visit(FieldAccess fieldAccess) {
        this.scan(fieldAccess.getDispatcher());
        ClassElement classElement = this.resolveTypeSimple(fieldAccess);
        String string = SemiAttribute.extractVariableName(fieldAccess.getField());
        if (classElement != null && string != null) {
            AttributedElement attributedElement = classElement.lookup(string, AttributedElement.Kind.VARIABLE);
            this.node2Element.put(fieldAccess, attributedElement);
            Variable variable = fieldAccess.getField();
            this.node2Element.put(variable, attributedElement);
            if (variable instanceof ArrayAccess) {
                Expression expression = variable.getName();
                if (expression instanceof Variable) {
                    this.node2Element.put(expression, attributedElement);
                }
                super.visit(fieldAccess);
            }
        } else {
            this.scan(fieldAccess.getField());
        }
    }

    private ClassElement getCurrentClassElement() {
        ClassElement classElement = null;
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            DefinitionScope definitionScope = (DefinitionScope)this.scopes.get(i);
            if (definitionScope == null || definitionScope.enclosingClass == null) continue;
            classElement = definitionScope.enclosingClass;
            break;
        }
        return classElement;
    }

    @Override
    public void visit(StaticConstantAccess staticConstantAccess) {
        Object object;
        String string = CodeUtils.extractUnqualifiedClassName(staticConstantAccess);
        if (string.equals("self")) {
            object = this.getCurrentClassElement();
            if (object != null) {
                string = ((AttributedElement)object).getName();
            }
        } else if (string.equals("parent") && (object = this.getCurrentClassElement()) != null && (object = ((ClassElement)object).getSuperClass()) != null) {
            string = ((AttributedElement)object).getName();
        }
        object = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, string);
        if (!object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AttributedElement attributedElement = (AttributedElement)iterator.next();
                ClassElement classElement = (ClassElement)attributedElement;
                if (classElement == null || !classElement.getName().equals(string)) continue;
                String string2 = CodeUtils.extractUnqualifiedClassName(staticConstantAccess);
                AttributedElement attributedElement2 = classElement.lookup(string2, AttributedElement.Kind.CONST);
                this.node2Element.put(staticConstantAccess.getClassName(), classElement);
                this.node2Element.put(staticConstantAccess, attributedElement2);
                this.node2Element.put(staticConstantAccess.getConstant(), attributedElement2);
                break;
            }
        }
        super.visit(staticConstantAccess);
    }

    @Override
    public void visit(StaticFieldAccess staticFieldAccess) {
        Collection<AttributedElement> collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, CodeUtils.extractUnqualifiedClassName(staticFieldAccess));
        if (!collection.isEmpty()) {
            String string = CodeUtils.extractUnqualifiedClassName(staticFieldAccess);
            if ("parent".equals(string)) {
                string = this.getContextSuperClassName();
            } else if ("self".equals(string)) {
                string = this.getContextClassName();
            }
            for (AttributedElement attributedElement : collection) {
                Expression expression;
                AttributedElement attributedElement2;
                String string2;
                ClassElement classElement = (ClassElement)attributedElement;
                if (classElement == null || string != null && !string.equals(classElement.getName()) || (string2 = SemiAttribute.extractVariableName(staticFieldAccess.getField())) == null || (attributedElement2 = classElement.lookup(string2, AttributedElement.Kind.VARIABLE)) == null) continue;
                Variable variable = staticFieldAccess.getField();
                this.node2Element.put(staticFieldAccess.getClassName(), classElement);
                this.node2Element.put(staticFieldAccess, attributedElement2);
                this.node2Element.put(variable, attributedElement2);
                if (!(variable instanceof ArrayAccess) || !((expression = variable.getName()) instanceof Variable)) break;
                this.node2Element.put(expression, attributedElement2);
                break;
            }
        }
        super.visit(staticFieldAccess);
    }

    private AttributedElement enterGlobalVariable(String string) {
        AttributedElement attributedElement = this.global.lookup(string, AttributedElement.Kind.VARIABLE);
        if (attributedElement == null) {
            attributedElement = this.global.enterWrite(string, AttributedElement.Kind.VARIABLE, (ASTNode)null);
        }
        this.scopes.peek().enter(string, AttributedElement.Kind.VARIABLE, attributedElement);
        return attributedElement;
    }

    @Override
    public void visit(ArrayAccess arrayAccess) {
        String string;
        Scalar scalar;
        String string2;
        if (arrayAccess.getName() instanceof Variable && arrayAccess.getIndex() instanceof Scalar && (string2 = SemiAttribute.extractVariableName((Variable)arrayAccess.getName())) != null && "GLOBALS".equals(string2) && (scalar = (Scalar)arrayAccess.getIndex()).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(string = scalar.getStringValue())) {
            this.node2Element.put(scalar, this.enterGlobalVariable(NavUtils.dequote(string)));
        }
        super.visit(arrayAccess);
    }

    private String getContextClassName() {
        String string = null;
        Enumeration enumeration = this.scopes.elements();
        while (enumeration.hasMoreElements()) {
            DefinitionScope definitionScope = (DefinitionScope)enumeration.nextElement();
            if (definitionScope.enclosingClass == null) continue;
            string = definitionScope.enclosingClass.getName();
        }
        return string;
    }

    private String getContextSuperClassName() {
        String string = null;
        Enumeration enumeration = this.scopes.elements();
        while (enumeration.hasMoreElements()) {
            DefinitionScope definitionScope = (DefinitionScope)enumeration.nextElement();
            if (definitionScope.enclosingClass == null || definitionScope.enclosingClass.superClass == null) continue;
            string = definitionScope.enclosingClass.superClass.getName();
        }
        return string;
    }

    private ParserResult getInfo() {
        return this.info;
    }

    private AttributedElement lookup(String string, AttributedElement.Kind kind) {
        AttributedElement attributedElement;
        DefinitionScope definitionScope = this.scopes.peek();
        switch (kind) {
            case FUNC: 
            case IFACE: 
            case CLASS: {
                attributedElement = this.global.lookup(string, kind);
                break;
            }
            default: {
                attributedElement = definitionScope.lookup(string, kind);
            }
        }
        if (attributedElement != null) {
            return attributedElement;
        }
        switch (kind) {
            case FUNC: 
            case IFACE: 
            case CLASS: {
                return this.global.enterWrite(string, kind, (ASTNode)null);
            }
        }
        return definitionScope.enterWrite(string, kind, (ASTNode)null);
    }

    public Collection<AttributedElement> getGlobalElements(AttributedElement.Kind kind) {
        return this.global.getElements(kind);
    }

    public Collection<AttributedElement> getNamedGlobalElements(AttributedElement.Kind kind, String ... stringArray) {
        Map map = (Map)this.global.name2Writes.get((Object)kind);
        ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
        for (String string : stringArray) {
            Object object;
            Object object2;
            Object object3;
            if (string.equals("self") && (object3 = this.getContextClassName()) != null) {
                string = object3;
            }
            if (AttributedElement.Kind.CLASS.equals((Object)kind) && string.equals("parent")) {
                object3 = map.values();
                if (map == null) continue;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    ClassElement classElement;
                    AttributedElement attributedElement = (AttributedElement)object2.next();
                    if (!(attributedElement instanceof ClassElement) || (object = (classElement = (ClassElement)attributedElement).getSuperClass()) == null) continue;
                    arrayList.add((AttributedElement)object);
                }
                continue;
            }
            Object object4 = object3 = map != null ? (AttributedElement)map.get(string) : null;
            if (object3 != null) {
                arrayList.add((AttributedElement)object3);
                continue;
            }
            object2 = PHPIndex.get(this.info);
            for (IndexedClass indexedClass : ((PHPIndex)object2).getClasses(null, string, QuerySupport.Kind.PREFIX)) {
                object = indexedClass.getName();
                object3 = this.global.enterWrite((String)object, AttributedElement.Kind.CLASS, indexedClass);
                if (object3 == null) continue;
                arrayList.add((AttributedElement)object3);
            }
        }
        return arrayList;
    }

    public AttributedElement getElement(ASTNode aSTNode) {
        return this.node2Element.get(aSTNode);
    }

    public void enterAllIndexedClasses() {
        if (this.name2ElementCache == null) {
            PHPIndex pHPIndex = PHPIndex.get(this.info);
            this.name2ElementCache = new LinkedList<IndexedElement>();
            this.name2ElementCache.addAll(pHPIndex.getClasses(null, "", QuerySupport.Kind.PREFIX));
        }
        for (IndexedElement indexedElement : this.name2ElementCache) {
            if (!(indexedElement instanceof IndexedClass)) continue;
            this.global.enterWrite(indexedElement.getName(), AttributedElement.Kind.CLASS, indexedElement);
        }
    }

    private void performEnterPass(DefinitionScope definitionScope, Collection<? extends ASTNode> collection) {
        for (ASTNode aSTNode : collection) {
            Object object2;
            List<Identifier> list;
            if (aSTNode instanceof MethodDeclaration) {
                list = ((MethodDeclaration)aSTNode).getFunction();
                String string = ((FunctionDeclaration)((Object)list)).getFunctionName().getName();
                this.node2Element.put(aSTNode, definitionScope.enterWrite(string, AttributedElement.Kind.FUNC, aSTNode));
                this.node2Element.put((ASTNode)((Object)list), definitionScope.enterWrite(string, AttributedElement.Kind.FUNC, aSTNode));
                continue;
            }
            if (aSTNode instanceof FunctionDeclaration) {
                list = ((FunctionDeclaration)aSTNode).getFunctionName().getName();
                this.node2Element.put(aSTNode, definitionScope.enterWrite((String)((Object)list), AttributedElement.Kind.FUNC, aSTNode));
            }
            if (aSTNode instanceof FieldsDeclaration) {
                for (SingleFieldDeclaration singleFieldDeclaration : ((FieldsDeclaration)aSTNode).getFields()) {
                    object2 = SemiAttribute.extractVariableName(singleFieldDeclaration.getName());
                    if (object2 == null) continue;
                    this.node2Element.put(aSTNode, definitionScope.enterWrite((String)object2, AttributedElement.Kind.VARIABLE, aSTNode));
                }
            }
            if (aSTNode instanceof ClassDeclaration) {
                Identifier identifier;
                list = (ClassDeclaration)aSTNode;
                String string = ((TypeDeclaration)((Object)list)).getName().getName();
                object2 = (ClassElement)this.global.enterWrite(string, AttributedElement.Kind.CLASS, (ASTNode)((Object)list));
                this.node2Element.put((ASTNode)((Object)list), (AttributedElement)object2);
                Identifier identifier2 = identifier = ((ClassDeclaration)((Object)list)).getSuperClass() != null ? CodeUtils.extractUnqualifiedIdentifier(((ClassDeclaration)((Object)list)).getSuperClass()) : null;
                if (identifier != null) {
                    ((ClassElement)object2).superClass = (ClassElement)this.lookup(identifier.getName(), AttributedElement.Kind.CLASS);
                    this.node2Element.put(((ClassDeclaration)((Object)list)).getSuperClass(), ((ClassElement)object2).superClass);
                }
                List<Expression> list2 = ((TypeDeclaration)((Object)list)).getInterfaes();
                for (Expression expression : list2) {
                }
                if (((TypeDeclaration)((Object)list)).getBody() != null) {
                    this.performEnterPass(((ClassElement)object2).enclosedElements, ((TypeDeclaration)((Object)list)).getBody().getStatements());
                }
            }
            if (!(aSTNode instanceof ConstantDeclaration)) continue;
            list = ((ConstantDeclaration)aSTNode).getNames();
            for (Object object2 : list) {
                this.node2Element.put(aSTNode, definitionScope.enterWrite(((Identifier)object2).getName(), AttributedElement.Kind.CONST, aSTNode));
            }
        }
    }

    public static SemiAttribute semiAttribute(ParserResult parserResult) {
        SemiAttribute semiAttribute = info2Attr.get(parserResult);
        if (semiAttribute == null) {
            long l = System.currentTimeMillis();
            semiAttribute = new SemiAttribute(parserResult);
            semiAttribute.scan(Utils.getRoot(parserResult));
            semiAttribute.info = null;
            info2Attr.put(parserResult, semiAttribute);
            long l2 = System.currentTimeMillis();
            FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
            Logger.getLogger("TIMER").log(Level.FINE, "SemiAttribute global instance", new Object[]{fileObject, semiAttribute});
            Logger.getLogger("TIMER").log(Level.FINE, "SemiAttribute global time", new Object[]{fileObject, l2 - l});
        }
        return semiAttribute;
    }

    public static SemiAttribute semiAttribute(ParserResult parserResult, int n) {
        SemiAttribute semiAttribute = new SemiAttribute(parserResult, n);
        try {
            semiAttribute.scan(Utils.getRoot(parserResult));
        }
        catch (Stop stop) {
            // empty catch block
        }
        return semiAttribute;
    }

    private static String name(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            return ((Identifier)aSTNode).getName();
        }
        return null;
    }

    @CheckForNull
    public static String extractVariableName(Variable variable) {
        String string = CodeUtils.extractVariableName(variable);
        if (string != null && string.startsWith("$")) {
            return string.substring(1);
        }
        return string;
    }

    private ClassElement resolveTypeSimple(Dispatch dispatch) {
        AttributedType attributedType;
        ClassElement classElement = null;
        AttributedElement attributedElement = this.node2Element.get(dispatch.getDispatcher());
        if (attributedElement != null && (attributedType = (AttributedType)attributedElement.writesTypes.get(attributedElement.getWrites().size() - 1)) instanceof ClassType) {
            classElement = ((ClassType)attributedType).getElement();
        }
        return classElement;
    }

    public Collection<AttributedElement> getFunctions() {
        Collection<AttributedElement> collection = null;
        collection = this.global != null ? this.global.getFunctions() : Collections.emptyList();
        return collection;
    }

    public Collection<AttributedElement> getConstants() {
        Collection<AttributedElement> collection = null;
        collection = this.global != null ? this.global.getConstants() : Collections.emptyList();
        return collection;
    }

    public Collection<AttributedElement> getGlobalVariables() {
        Collection<AttributedElement> collection = null;
        collection = this.global != null ? this.global.getVariables() : Collections.emptyList();
        return collection;
    }

    public Collection<ClassElement> getClasses() {
        Collection<ClassElement> collection = null;
        collection = this.global != null ? this.global.getClasses() : Collections.emptyList();
        return collection;
    }

    public boolean hasGlobalVisibility(AttributedElement attributedElement) {
        if (attributedElement.isClassMember()) {
            ClassMemberElement classMemberElement = (ClassMemberElement)attributedElement;
            boolean bl = (classMemberElement.getModifier() == -1 || !classMemberElement.isPrivate()) && this.hasGlobalVisibility(classMemberElement.getClassElement());
            return bl;
        }
        return this.global != null ? this.global.getElements(attributedElement.getKind()).contains(attributedElement) : false;
    }

    public static class FunctionType
    extends AttributedType {
        private FunctionElement element;

        public FunctionType(FunctionElement functionElement) {
            this.element = functionElement;
        }

        public FunctionElement getElement() {
            return this.element;
        }

        public String getTypeName() {
            return this.getElement().getName();
        }
    }

    public static class ClassType
    extends AttributedType {
        private ClassElement element;

        public ClassType(ClassElement classElement) {
            this.element = classElement;
        }

        public ClassElement getElement() {
            return this.element;
        }

        public String getTypeName() {
            return this.getElement().getName();
        }
    }

    public static abstract class AttributedType {
        public abstract String getTypeName();
    }

    private static final class Stop
    extends Error {
        private Stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefinitionScope {
        private final Map<AttributedElement.Kind, Map<String, AttributedElement>> name2Writes = new HashMap<AttributedElement.Kind, Map<String, AttributedElement>>();
        private boolean classScope;
        private boolean functionScope;
        private AttributedElement thisVar;
        private ClassElement enclosingClass;
        private FunctionElement enclosingFunction;

        public DefinitionScope() {
        }

        public DefinitionScope(ClassElement classElement) {
            this.enclosingClass = classElement;
            boolean bl = this.classScope = classElement != null;
            if (this.classScope) {
                this.thisVar = this.enterWrite("this", AttributedElement.Kind.VARIABLE, (ASTNode)null, (AttributedType)new ClassType(classElement));
            }
        }

        public DefinitionScope(FunctionElement functionElement) {
            this.enclosingFunction = functionElement;
            this.functionScope = functionElement != null;
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, ASTNode aSTNode) {
            return this.enterWrite(string, kind, aSTNode, null);
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, ASTNode aSTNode, AttributedType attributedType) {
            return this.enterWrite(string, kind, (Union2<ASTNode, IndexedElement>)Union2.createFirst((Object)aSTNode), attributedType);
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, IndexedElement indexedElement) {
            return this.enterWrite(string, kind, (Union2<ASTNode, IndexedElement>)Union2.createSecond((Object)indexedElement), null);
        }

        private AttributedElement enterWrite(String string, AttributedElement.Kind kind, Union2<ASTNode, IndexedElement> union2, AttributedType attributedType) {
            AttributedElement attributedElement;
            block15: {
                block11: {
                    Map<String, AttributedElement> map;
                    block13: {
                        block14: {
                            block12: {
                                if (kind == AttributedElement.Kind.VARIABLE && this != SemiAttribute.this.global && SUPERGLOBALS.contains(string)) {
                                    return SemiAttribute.this.enterGlobalVariable(string);
                                }
                                map = this.name2Writes.get((Object)kind);
                                if (map == null) {
                                    map = new HashMap<String, AttributedElement>();
                                    this.name2Writes.put(kind, map);
                                }
                                if ((attributedElement = map.get(string)) != null) break block11;
                                if (kind != AttributedElement.Kind.CLASS && kind != AttributedElement.Kind.IFACE) break block12;
                                attributedElement = new ClassElement(union2, string, kind);
                                break block13;
                            }
                            if (!this.classScope || Arrays.asList("this").contains(string)) break block14;
                            switch (kind) {
                                case FUNC: 
                                case CONST: 
                                case VARIABLE: {
                                    attributedElement = new ClassMemberElement(union2, this.enclosingClass, string, kind);
                                    break block13;
                                }
                                default: {
                                    assert (false);
                                    break block13;
                                }
                            }
                        }
                        if (kind == AttributedElement.Kind.FUNC) {
                            attributedElement = new FunctionElement(union2, string, kind);
                        } else if (kind == AttributedElement.Kind.VARIABLE) {
                            if (attributedType == null && this.functionScope && this.enclosingFunction != null) {
                                attributedType = new FunctionType(this.enclosingFunction);
                            }
                            attributedElement = new AttributedElement(union2, string, kind, attributedType);
                        } else {
                            attributedElement = new AttributedElement(union2, string, kind, attributedType);
                        }
                    }
                    map.put(string, attributedElement);
                    break block15;
                }
                attributedElement.addWrite(union2, attributedType);
            }
            return attributedElement;
        }

        public AttributedElement enter(String string, AttributedElement.Kind kind, AttributedElement attributedElement) {
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map == null) {
                map = new HashMap<String, AttributedElement>();
                this.name2Writes.put(kind, map);
            }
            map.put(string, attributedElement);
            return attributedElement;
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            AttributedElement attributedElement = null;
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map != null) {
                attributedElement = map.get(string);
            }
            if (attributedElement == null) {
                PHPIndex pHPIndex = PHPIndex.get(SemiAttribute.this.info);
                switch (kind) {
                    case CONST: {
                        for (IndexedConstant indexedConstant : pHPIndex.getConstants(null, string, QuerySupport.Kind.PREFIX)) {
                            String string2 = indexedConstant.getName();
                            attributedElement = this.enterWrite(string2, AttributedElement.Kind.CONST, indexedConstant);
                        }
                        break;
                    }
                }
            }
            return attributedElement;
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map != null) {
                return Collections.unmodifiableCollection(map.values());
            }
            return Collections.emptyList();
        }

        public Collection<AttributedElement> getFunctions() {
            return this.getElements(AttributedElement.Kind.FUNC);
        }

        public Collection<AttributedElement> getVariables() {
            return this.getElements(AttributedElement.Kind.VARIABLE);
        }

        private Collection<AttributedElement> getConstants() {
            return this.getElements(AttributedElement.Kind.CONST);
        }

        public Collection<ClassElement> getClasses() {
            LinkedHashSet<ClassElement> linkedHashSet = new LinkedHashSet<ClassElement>();
            Collection<AttributedElement> collection = this.getElements(AttributedElement.Kind.CLASS);
            for (AttributedElement attributedElement : collection) {
                assert (attributedElement instanceof ClassElement);
                linkedHashSet.add((ClassElement)attributedElement);
            }
            return linkedHashSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FunctionElement
    extends AttributedElement {
        private final DefinitionScope enclosedElements;
        private boolean initialized;

        public FunctionElement(Union2<ASTNode, IndexedElement> union2, String string, AttributedElement.Kind kind) {
            super(union2, string, kind);
            this.enclosedElements = new DefinitionScope(this);
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            return this.enclosedElements.lookup(string, kind);
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            this.getElements0(arrayList, kind);
            return Collections.unmodifiableList(arrayList);
        }

        public Collection<AttributedElement> getNamedElements(AttributedElement.Kind kind, String ... stringArray) {
            Collection<AttributedElement> collection = this.getElements(kind);
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            for (String string : stringArray) {
                for (AttributedElement attributedElement : collection) {
                    if (!attributedElement.getName().equals(string)) continue;
                    arrayList.add(attributedElement);
                }
            }
            return arrayList;
        }

        public Collection<AttributedElement> getVariables() {
            return this.getElements(AttributedElement.Kind.VARIABLE);
        }

        private void getElements0(List<AttributedElement> list, AttributedElement.Kind kind) {
            list.addAll(this.enclosedElements.getElements(kind));
        }

        boolean isInitialized() {
            return this.initialized;
        }

        void initialized() {
            this.initialized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassElement
    extends AttributedElement {
        private final DefinitionScope enclosedElements;
        private ClassElement superClass;
        private Set<ClassElement> ifaces;
        private boolean initialized;

        public ClassElement(Union2<ASTNode, IndexedElement> union2, String string, AttributedElement.Kind kind) {
            super(union2, string, kind);
            this.ifaces = new HashSet<ClassElement>();
            this.enclosedElements = new DefinitionScope(this);
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            AttributedElement attributedElement = this.enclosedElements.lookup(string, kind);
            if (attributedElement != null) {
                return attributedElement;
            }
            PHPIndex pHPIndex = PHPIndex.get(SemiAttribute.this.info);
            int n = -1;
            switch (kind) {
                case CONST: {
                    for (IndexedClassMember<IndexedConstant> indexedClassMember : pHPIndex.getAllTypeConstants(null, this.getName(), string, QuerySupport.Kind.PREFIX)) {
                        IndexedConstant indexedConstant = indexedClassMember.getMember();
                        String string2 = indexedConstant.getName();
                        string2 = string2.startsWith("$") ? string2.substring(1) : string2;
                        this.enclosedElements.enterWrite(string2, AttributedElement.Kind.CONST, indexedConstant);
                    }
                    break;
                }
                case FUNC: {
                    for (IndexedClassMember<IndexedFunction> indexedClassMember : pHPIndex.getAllMethods(null, this.getName(), string, QuerySupport.Kind.PREFIX, n)) {
                        IndexedFunction indexedFunction = indexedClassMember.getMember();
                        this.enclosedElements.enterWrite(indexedFunction.getName(), AttributedElement.Kind.FUNC, indexedFunction);
                    }
                    break;
                }
                case VARIABLE: {
                    for (IndexedClassMember<IndexedConstant> indexedClassMember : pHPIndex.getAllFields(null, this.getName(), string, QuerySupport.Kind.PREFIX, n)) {
                        IndexedConstant indexedConstant = indexedClassMember.getMember();
                        String string3 = indexedConstant.getName();
                        string3 = string3.startsWith("$") ? string3.substring(1) : string3;
                        this.enclosedElements.enterWrite(string3, AttributedElement.Kind.VARIABLE, indexedConstant);
                    }
                    break;
                }
            }
            return this.enclosedElements.lookup(string, kind);
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            this.getElements0(arrayList, kind);
            return Collections.unmodifiableList(arrayList);
        }

        public Collection<AttributedElement> getNamedElements(AttributedElement.Kind kind, String ... stringArray) {
            Collection<AttributedElement> collection = this.getElements(kind);
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            for (String string : stringArray) {
                for (AttributedElement attributedElement : collection) {
                    if (!attributedElement.getName().equals(string)) continue;
                    arrayList.add(attributedElement);
                }
            }
            return arrayList;
        }

        public Collection<AttributedElement> getMethods() {
            return this.getElements(AttributedElement.Kind.FUNC);
        }

        public Collection<AttributedElement> getFields() {
            Collection<AttributedElement> collection = this.getElements(AttributedElement.Kind.VARIABLE);
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            for (AttributedElement attributedElement : collection) {
                if (attributedElement.getName().equals("this")) continue;
                arrayList.add(attributedElement);
            }
            return arrayList;
        }

        public ClassElement getSuperClass() {
            return this.superClass;
        }

        private void getElements0(List<AttributedElement> list, AttributedElement.Kind kind) {
            list.addAll(this.enclosedElements.getElements(kind));
            if (this.superClass != null) {
                this.superClass.getElements0(list, kind);
            }
        }

        boolean isInitialized() {
            return this.initialized;
        }

        void initialized() {
            this.initialized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassMemberElement
    extends AttributedElement {
        private ClassElement classElement;
        int modifier = -1;

        public ClassMemberElement(Union2<ASTNode, IndexedElement> union2, ClassElement classElement, String string, AttributedElement.Kind kind) {
            super(union2, string, kind);
            this.classElement = classElement;
            this.setModifiers(union2, string);
            assert (classElement != null);
        }

        public String getClassName() {
            return this.getClassElement().getName();
        }

        @Override
        public String getScopeName() {
            return this.getClassName();
        }

        public int getModifier() {
            return this.modifier;
        }

        public boolean isPublic() {
            return BodyDeclaration.Modifier.isPublic(this.getModifier());
        }

        public boolean isPrivate() {
            return BodyDeclaration.Modifier.isPrivate(this.getModifier());
        }

        public boolean isProtected() {
            return BodyDeclaration.Modifier.isProtected(this.getModifier());
        }

        public boolean isStatic() {
            return BodyDeclaration.Modifier.isStatic(this.getModifier());
        }

        public ClassElement getClassElement() {
            return this.classElement;
        }

        @Override
        public boolean isClassMember() {
            return true;
        }

        public ClassMemberKind getClassMemberKind() {
            ClassMemberKind classMemberKind = null;
            switch (this.getKind()) {
                case CONST: {
                    classMemberKind = ClassMemberKind.CONST;
                    break;
                }
                case FUNC: {
                    classMemberKind = ClassMemberKind.METHOD;
                    break;
                }
                case VARIABLE: {
                    classMemberKind = ClassMemberKind.FIELD;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (classMemberKind != null);
            return classMemberKind;
        }

        private void setModifiers(Union2<ASTNode, IndexedElement> union2, String string) {
            IndexedElement indexedElement;
            if (union2.hasFirst()) {
                ASTNode aSTNode = (ASTNode)union2.first();
                if (aSTNode instanceof BodyDeclaration) {
                    this.modifier = ((BodyDeclaration)aSTNode).getModifier();
                } else if (string.equals("this")) {
                    assert (false);
                } else if (aSTNode instanceof ConstantDeclaration) {
                    this.modifier |= 1;
                } else assert (false) : string;
            } else if (union2.hasSecond() && (indexedElement = (IndexedElement)union2.second()) != null) {
                Set<Modifier> set = indexedElement.getModifiers();
                for (Modifier modifier : set) {
                    switch (modifier) {
                        case PRIVATE: {
                            this.modifier |= 2;
                            break;
                        }
                        case PROTECTED: {
                            this.modifier |= 4;
                            break;
                        }
                        case PUBLIC: {
                            this.modifier |= 1;
                            break;
                        }
                        case STATIC: {
                            this.modifier |= 8;
                        }
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ClassMemberKind {
            FIELD,
            METHOD,
            CONST;

        }
    }

    private static class Types {
        private AttributedElement el;

        Types(AttributedElement attributedElement) {
            this.el = attributedElement;
        }

        int size() {
            return this.el.writesTypes.size();
        }

        AttributedType getType(int n) {
            return (AttributedType)this.el.writesTypes.get(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributedElement {
        private List<Union2<ASTNode, IndexedElement>> writes = new LinkedList<Union2<ASTNode, IndexedElement>>();
        private List<AttributedType> writesTypes = new LinkedList<AttributedType>();
        private String name;
        private Kind k;

        public AttributedElement(Union2<ASTNode, IndexedElement> union2, String string, Kind kind) {
            this(union2, string, kind, null);
        }

        public AttributedElement(Union2<ASTNode, IndexedElement> union2, String string, Kind kind, AttributedType attributedType) {
            this.writes.add(union2);
            this.writesTypes.add(attributedType);
            this.name = string;
            this.k = kind;
        }

        public boolean isClassMember() {
            return false;
        }

        public List<Union2<ASTNode, IndexedElement>> getWrites() {
            return this.writes;
        }

        public Kind getKind() {
            return this.k;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AttributedElement)) {
                return false;
            }
            AttributedElement attributedElement = (AttributedElement)object;
            return this.name.equals(attributedElement.name) && this.k.equals((Object)attributedElement.k);
        }

        void addWrite(Union2<ASTNode, IndexedElement> union2, AttributedType attributedType) {
            this.writes.add(union2);
            this.writesTypes.add(attributedType);
        }

        Types getTypes() {
            return new Types(this);
        }

        public String getScopeName() {
            String string = "";
            Types types = this.getTypes();
            for (int i = 0; i < types.size(); ++i) {
                AttributedType attributedType = types.getType(i);
                if (attributedType == null) continue;
                string = attributedType.getTypeName();
                break;
            }
            return string;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            VARIABLE,
            FUNC,
            CLASS,
            CONST,
            IFACE;

        }
    }
}

