/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.nav.DeclarationFinderImpl;
import org.netbeans.modules.php.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.php.editor.parser.PHPParseResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccurrencesFinderImpl
extends OccurrencesFinder {
    private Map<OffsetRange, ColoringAttributes> range2Attribs;
    private int caretPosition;

    public void setCaretPosition(int n) {
        this.range2Attribs = new HashMap<OffsetRange, ColoringAttributes>();
        this.caretPosition = n;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.range2Attribs;
    }

    public void cancel() {
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        Preferences preferences = MarkOccurencesSettings.getCurrentNode();
        if (preferences.getBoolean(MarkOccurencesSettings.ON_OFF, true)) {
            for (OffsetRange offsetRange : OccurrencesFinderImpl.compute((ParserResult)result, this.caretPosition)) {
                this.range2Attribs.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
            }
        }
    }

    static Collection<OffsetRange> compute(ParserResult parserResult, int n) {
        TreeSet<OffsetRange> treeSet;
        block4: {
            Model model;
            OccurencesSupport occurencesSupport;
            CodeMarker codeMarker;
            OffsetRange offsetRange;
            TokenSequence<PHPTokenId> tokenSequence;
            block3: {
                ModelElement modelElement;
                OffsetRange offsetRange2;
                treeSet = new TreeSet<OffsetRange>(new Comparator<OffsetRange>(){

                    @Override
                    public int compare(OffsetRange offsetRange, OffsetRange offsetRange2) {
                        return offsetRange.compareTo(offsetRange2);
                    }
                });
                TokenHierarchy tokenHierarchy = parserResult.getSnapshot().getTokenHierarchy();
                tokenSequence = tokenHierarchy != null ? LexUtilities.getPHPTokenSequence(tokenHierarchy, n) : null;
                OffsetRange offsetRange3 = offsetRange2 = tokenSequence != null ? DeclarationFinderImpl.getReferenceSpan(tokenSequence, n) : OffsetRange.NONE;
                if (offsetRange2.equals((Object)OffsetRange.NONE)) break block3;
                Model model2 = ((PHPParseResult)parserResult).getModel();
                OccurencesSupport occurencesSupport2 = model2.getOccurencesSupport(n);
                Occurence occurence = occurencesSupport2.getOccurence();
                if (occurence == null || (modelElement = occurence.getDeclaration()) == null || modelElement.getPhpKind().equals((Object)PhpKind.INCLUDE)) break block4;
                Collection<Occurence> collection = occurence.getAllOccurences();
                for (Occurence occurence2 : collection) {
                    treeSet.add(occurence2.getOccurenceRange());
                }
                break block4;
            }
            OffsetRange offsetRange4 = offsetRange = tokenSequence != null ? OccurrencesFinderImpl.getReferenceSpanForCodeMarkers(tokenSequence, n) : OffsetRange.NONE;
            if (!offsetRange.equals((Object)OffsetRange.NONE) && (codeMarker = (occurencesSupport = (model = ((PHPParseResult)parserResult).getModel()).getOccurencesSupport(n)).getCodeMarker()) != null) {
                List<? extends CodeMarker> list = codeMarker.getAllMarkers();
                for (CodeMarker codeMarker2 : list) {
                    treeSet.add(codeMarker2.getOffsetRange());
                }
            }
        }
        return treeSet;
    }

    private static OffsetRange getReferenceSpanForCodeMarkers(TokenSequence<PHPTokenId> tokenSequence, int n) {
        Token token;
        PHPTokenId pHPTokenId;
        tokenSequence.move(n);
        if (tokenSequence.moveNext() && ((pHPTokenId = (PHPTokenId)(token = tokenSequence.token()).id()).equals((Object)PHPTokenId.PHP_FUNCTION) || pHPTokenId.equals((Object)PHPTokenId.PHP_RETURN))) {
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }
}

