/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassScopeImpl
extends TypeScopeImpl
implements ClassScope,
VariableNameFactory {
    private Union2<String, List<ClassScopeImpl>> superClass;

    @Override
    void addElement(ModelElementImpl modelElementImpl) {
        assert (modelElementImpl instanceof TypeScope || modelElementImpl instanceof VariableName || modelElementImpl instanceof MethodScope || modelElementImpl instanceof FieldElement || modelElementImpl instanceof ClassConstantElement) : modelElementImpl.getPhpKind();
        if (modelElementImpl instanceof TypeScope) {
            Scope scope = this.getInScope();
            if (scope instanceof ScopeImpl) {
                ((ScopeImpl)scope).addElement(modelElementImpl);
            }
        } else {
            super.addElement(modelElementImpl);
        }
    }

    ClassScopeImpl(Scope scope, ClassDeclarationInfo classDeclarationInfo) {
        super(scope, classDeclarationInfo);
        Expression expression = classDeclarationInfo.getSuperClass();
        String string = expression != null ? CodeUtils.extractUnqualifiedName(expression) : null;
        this.superClass = Union2.createFirst((Object)string);
    }

    ClassScopeImpl(IndexScope indexScope, IndexedClass indexedClass) {
        super((Scope)indexScope, indexedClass);
        this.superClass = Union2.createFirst((Object)indexedClass.getSuperClass());
    }

    @Override
    @NonNull
    public Collection<? extends ClassScope> getSuperClasses() {
        List<Object> list = null;
        List<Object> list2 = list = this.superClass.hasSecond() ? (List)this.superClass.second() : null;
        if (list == null) {
            assert (this.superClass.hasFirst());
            String string = (String)this.superClass.first();
            if (string != null) {
                list = CachingSupport.getClasses(string, this);
                assert (list != null);
            }
        }
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public String toString() {
        Collection collection;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        Collection<? extends ClassScope> collection2 = this.getSuperClasses();
        ClassScope classScope = ModelUtils.getFirst(collection2);
        if (classScope != null) {
            stringBuilder.append(" extends ").append(classScope.getName());
        }
        if ((collection = this.getSuperInterfaces()).size() > 0) {
            stringBuilder.append(" implements ");
            for (InterfaceScope interfaceScope : collection) {
                stringBuilder.append(interfaceScope.getName()).append(" ");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Collection<? extends FieldElement> getDeclaredFields() {
        return this.findDeclaredFields(new int[0]);
    }

    @Override
    public Collection<? extends FieldElement> findDeclaredFields(final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            return indexScope.findFields((ClassScope)this, nArray);
        }
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.FIELD) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends FieldElement> findDeclaredFields(final String string, final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            return indexScope.findFields((ClassScope)this, string, nArray);
        }
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.FIELD) && ModelElementImpl.nameKindMatch(modelElement.getName(), QuerySupport.Kind.EXACT, string) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends FieldElement> findDeclaredFields(final QuerySupport.Kind kind, final String string, final int ... nArray) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            return indexScopeImpl.findFields(kind, this, string, nArray);
        }
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.FIELD) && ModelElementImpl.nameKindMatch(modelElement.getName(), kind, string) && (nArray.length == 0 || (modelElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    @Override
    public Collection<? extends MethodScope> getInheritedMethods() {
        return this.findInheritedMethods("");
    }

    @Override
    public Collection<? extends MethodScope> getMethods() {
        HashSet<MethodScope> hashSet = new HashSet<MethodScope>();
        hashSet.addAll(this.getDeclaredMethods());
        hashSet.addAll(this.getInheritedMethods());
        return hashSet;
    }

    public List<? extends FieldElement> getFields() {
        ArrayList<? extends FieldElement> arrayList = new ArrayList<FieldElement>();
        arrayList.addAll(this.getDeclaredFields());
        IndexScope indexScope = ModelUtils.getIndexScope(this);
        PHPIndex pHPIndex = indexScope.getIndex();
        ClassScope classScope = ModelUtils.getFirst(this.getSuperClasses());
        while (classScope != null) {
            Collection<IndexedConstant> collection = pHPIndex.getFields(null, classScope.getName(), "", QuerySupport.Kind.PREFIX, 5);
            for (IndexedConstant indexedConstant : collection) {
                arrayList.add(new FieldElementImpl((ClassScopeImpl)classScope, indexedConstant));
            }
            classScope = ModelUtils.getFirst(classScope.getSuperClasses());
        }
        return arrayList;
    }

    public List<? extends FieldElement> findInheritedFields(String string) {
        assert (string.startsWith("$"));
        ArrayList<? extends FieldElement> arrayList = new ArrayList<FieldElement>();
        arrayList.addAll(this.findDeclaredFields(string, new int[0]));
        if (arrayList.isEmpty()) {
            IndexScope indexScope = ModelUtils.getIndexScope(this);
            PHPIndex pHPIndex = indexScope.getIndex();
            ClassScope classScope = this;
            while (classScope != null && arrayList.isEmpty()) {
                if ((classScope = ModelUtils.getFirst(classScope.getSuperClasses())) == null) continue;
                String string2 = string.startsWith("$") ? string.substring(1) : string;
                Collection<IndexedConstant> collection = pHPIndex.getFields(null, classScope.getName(), string2, QuerySupport.Kind.PREFIX, 5);
                for (IndexedConstant indexedConstant : collection) {
                    arrayList.add(new FieldElementImpl((ClassScopeImpl)classScope, indexedConstant));
                }
            }
        }
        return arrayList;
    }

    public List<? extends ClassScope> getSuperClassesChain() {
        HashSet<ClassScope> hashSet = new HashSet<ClassScope>();
        return new ArrayList<ClassScope>(ClassScopeImpl.collectSuperClassesChain(hashSet, this));
    }

    private static Set<ClassScope> collectSuperClassesChain(Set<ClassScope> set, ClassScope classScope) {
        set.add(classScope);
        Collection<? extends ClassScope> collection = classScope.getSuperClasses();
        for (ClassScope classScope2 : collection) {
            ClassScopeImpl.collectSuperClassesChain(set, classScope2);
        }
        return set;
    }

    @Override
    public String getNormalizedName() {
        return super.getNormalizedName() + (this.getSuperClassName() != null ? this.getSuperClassName() : "");
    }

    @NonNull
    String getSuperClassName() {
        List list = null;
        if (this.superClass != null) {
            ClassScope classScope;
            List list2 = list = this.superClass.hasSecond() ? (List)this.superClass.second() : null;
            if (list == null) {
                assert (this.superClass.hasFirst());
                String string = (String)this.superClass.first();
                if (string != null) {
                    return string;
                }
            } else if (list.size() > 0 && (classScope = (ClassScope)ModelUtils.getFirst(list)) != null) {
                return classScope.getName();
            }
        }
        return null;
    }

    @Override
    public String getIndexSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName().toLowerCase()).append(";");
        stringBuilder.append(this.getName()).append(";");
        stringBuilder.append(this.getOffset()).append(";");
        String string = this.getSuperClassName();
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(";");
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        stringBuilder.append(qualifiedName.toString()).append(";");
        Collection collection = this.getSuperInterfaceNames();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string2 : collection) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder2.append(string2);
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    @Override
    public Collection<? extends MethodScope> getDeclaredConstructors() {
        return ModelUtils.filter(this.getDeclaredMethods(), new ModelUtils.ElementFilter<MethodScope>(){

            @Override
            public boolean isAccepted(MethodScope methodScope) {
                return methodScope.isConstructor();
            }
        });
    }

    @Override
    public String getDefaultConstructorIndexSignature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName().toLowerCase()).append(";");
        stringBuilder.append(this.getName()).append(";");
        stringBuilder.append(this.getOffset()).append(";");
        stringBuilder.append(";");
        stringBuilder.append(";");
        stringBuilder.append(1).append(";");
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        stringBuilder.append(qualifiedName.toString()).append(";");
        return stringBuilder.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof IndexedClass) {
            IndexedClass indexedClass = (IndexedClass)this.indexedElement;
            return QualifiedName.create(indexedClass.getNamespaceName());
        }
        return super.getNamespaceName();
    }

    @Override
    public Collection<? extends String> getSuperClassNames() {
        String string;
        String string2 = string = this.superClass.hasFirst() ? (String)this.superClass.first() : null;
        if (string != null) {
            return Collections.singletonList(string);
        }
        List list = Collections.emptyList();
        if (this.superClass.hasSecond()) {
            list = (List)this.superClass.second();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClassScopeImpl classScopeImpl : list) {
            arrayList.add(classScopeImpl.getName());
        }
        return arrayList;
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return ClassScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.VARIABLE);
            }
        });
    }

    @Override
    public VariableNameImpl createElement(Variable variable) {
        VariableNameImpl variableNameImpl = new VariableNameImpl((Scope)this, variable, false);
        this.addElement(variableNameImpl);
        return variableNameImpl;
    }
}

