/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.NamespaceDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    private ModelUtils() {
    }

    public static NamespaceScope getNamespaceScope(NamespaceDeclaration namespaceDeclaration, FileScope fileScope) {
        NamespaceDeclarationInfo namespaceDeclarationInfo = namespaceDeclaration != null ? NamespaceDeclarationInfo.create(namespaceDeclaration) : null;
        NamespaceScope namespaceScope = namespaceDeclarationInfo != null ? ModelUtils.getFirst(ModelUtils.filter(fileScope.getDeclaredNamespaces(), namespaceDeclarationInfo.getName())) : fileScope.getDefaultDeclaredNamespace();
        return namespaceScope;
    }

    public static Collection<? extends TypeScope> getDeclaredTypes(FileScope fileScope) {
        ArrayList<? extends TypeScope> arrayList = new ArrayList<TypeScope>();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : collection) {
            arrayList.addAll(namespaceScope.getDeclaredTypes());
        }
        return arrayList;
    }

    public static Collection<? extends ClassScope> getDeclaredClasses(FileScope fileScope) {
        ArrayList<? extends ClassScope> arrayList = new ArrayList<ClassScope>();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : collection) {
            arrayList.addAll(namespaceScope.getDeclaredClasses());
        }
        return arrayList;
    }

    public static Collection<? extends InterfaceScope> getDeclaredInterfaces(FileScope fileScope) {
        ArrayList<? extends InterfaceScope> arrayList = new ArrayList<InterfaceScope>();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : collection) {
            arrayList.addAll(namespaceScope.getDeclaredInterfaces());
        }
        return arrayList;
    }

    public static Collection<? extends ConstantElement> getDeclaredConstants(FileScope fileScope) {
        ArrayList<? extends ConstantElement> arrayList = new ArrayList<ConstantElement>();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : collection) {
            arrayList.addAll(namespaceScope.getDeclaredConstants());
        }
        return arrayList;
    }

    public static Collection<? extends FunctionScope> getDeclaredFunctions(FileScope fileScope) {
        ArrayList<? extends FunctionScope> arrayList = new ArrayList<FunctionScope>();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : collection) {
            arrayList.addAll(namespaceScope.getDeclaredFunctions());
        }
        return arrayList;
    }

    public static Collection<? extends VariableName> getDeclaredVariables(FileScope fileScope) {
        ArrayList<? extends VariableName> arrayList = new ArrayList<VariableName>();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope : collection) {
            arrayList.addAll(namespaceScope.getDeclaredVariables());
        }
        return arrayList;
    }

    public static List<? extends ModelElement> getElements(Scope scope, boolean bl) {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        List<? extends ModelElement> list = scope.getElements();
        arrayList.addAll(list);
        for (ModelElement modelElement : list) {
            if (!(modelElement instanceof Scope)) continue;
            arrayList.addAll(ModelUtils.getElements((Scope)modelElement, bl));
        }
        return arrayList;
    }

    public static Collection<? extends TypeScope> resolveType(Model model, StaticDispatch staticDispatch) {
        QualifiedName qualifiedName = ASTNodeInfo.toQualifiedName(staticDispatch, true);
        if (qualifiedName != null) {
            VariableScope variableScope = model.getVariableScope(staticDispatch.getStartOffset());
            NamespaceIndexFilter namespaceIndexFilter = new NamespaceIndexFilter(qualifiedName.toString());
            Collection<? extends TypeScope> collection = VariousUtils.getStaticTypeName(variableScope != null ? variableScope : model.getFileScope(), namespaceIndexFilter.getName());
            return namespaceIndexFilter.filterModelElements(collection, true);
        }
        return Collections.emptyList();
    }

    @NonNull
    public static Collection<? extends TypeScope> resolveType(Model model, VariableBase variableBase) {
        String string;
        Collection<Object> collection = Collections.emptyList();
        VariableScope variableScope = model.getVariableScope(variableBase.getStartOffset());
        if (variableScope != null && (string = VariousUtils.extractTypeFroVariableBase(variableBase)) != null) {
            collection = VariousUtils.getType(variableScope, string, variableBase.getStartOffset(), true);
        }
        return collection;
    }

    @NonNull
    public static Collection<? extends TypeScope> resolveTypeAfterReferenceToken(Model model, TokenSequence<PHPTokenId> tokenSequence, int n) {
        String string;
        tokenSequence.move(n);
        List list = Collections.emptyList();
        VariableScope variableScope = model.getVariableScope(n);
        if (variableScope != null && (string = VariousUtils.getSemiType(tokenSequence, VariousUtils.State.START, variableScope)) != null) {
            return VariousUtils.getType(variableScope, string, n, true);
        }
        return list;
    }

    @CheckForNull
    public static <T> T getFirst(Collection<? extends T> collection) {
        if (collection instanceof List) {
            return collection.size() > 0 ? (T)((List)collection).get(0) : null;
        }
        return collection.size() > 0 ? (T)collection.iterator().next() : null;
    }

    @CheckForNull
    public static <T extends Occurence> T getFirst(Collection<? extends T> collection) {
        if (collection instanceof List) {
            return (T)(collection.size() > 0 ? (Occurence)((List)collection).get(0) : null);
        }
        return (T)(collection.size() > 0 ? (Occurence)collection.iterator().next() : null);
    }

    @CheckForNull
    public static <T extends ModelElement> T getLast(List<? extends T> list) {
        return (T)(list.size() > 0 ? (ModelElement)list.get(list.size() - 1) : null);
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> collection, final QuerySupport.Kind kind, QualifiedName qualifiedName) {
        final QualifiedNameKind qualifiedNameKind = qualifiedName.getKind();
        final String string = qualifiedName.toName().toString();
        final String string2 = qualifiedName.toNamespaceName().toString();
        return ModelUtils.filter(collection, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T t) {
                if (ModelUtils.nameKindMatch(t.getName(), kind, string)) {
                    switch (qualifiedNameKind) {
                        case QUALIFIED: 
                        case UNQUALIFIED: {
                            return true;
                        }
                        case FULLYQUALIFIED: {
                            return ModelUtils.nameKindMatch(t.getNamespaceName().toString(), kind, string2);
                        }
                    }
                }
                return false;
            }
        });
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> collection, String ... stringArray) {
        return ModelUtils.filter(collection, QuerySupport.Kind.EXACT, stringArray);
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<T> collection, final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.filter(collection, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T t) {
                return stringArray.length == 0 || ModelUtils.nameKindMatch(t.getName(), kind, stringArray);
            }
        });
    }

    @NonNull
    public static <T extends ModelElement> List<? extends T> filter(Collection<? extends T> collection, FileObject fileObject) {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (ModelElement modelElement : collection) {
            if (modelElement.getFileObject() != fileObject) continue;
            arrayList.add(modelElement);
        }
        return arrayList;
    }

    @NonNull
    public static <T extends ModelElement> T getFirst(Collection<T> collection, String ... stringArray) {
        return (T)((ModelElement)ModelUtils.getFirst(ModelUtils.filter(collection, QuerySupport.Kind.EXACT, stringArray)));
    }

    @NonNull
    public static <T extends ModelElement> T getFirst(Collection<T> collection, final QuerySupport.Kind kind, final String ... stringArray) {
        return (T)((ModelElement)ModelUtils.getFirst(ModelUtils.filter(collection, new ElementFilter<T>(){

            @Override
            public boolean isAccepted(T t) {
                return stringArray.length == 0 || ModelUtils.nameKindMatch(t.getName(), kind, stringArray);
            }
        })));
    }

    @NonNull
    public static <T extends ModelElement> T getFirst(Collection<? extends T> collection, FileObject fileObject) {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (ModelElement modelElement : collection) {
            if (modelElement.getFileObject() != fileObject) continue;
            arrayList.add(modelElement);
        }
        return (T)((ModelElement)ModelUtils.getFirst(arrayList));
    }

    @NonNull
    public static <T extends ModelElement> Collection<? extends T> merge(Collection<? extends T> ... collectionArray) {
        ArrayList<? extends T> arrayList = new ArrayList<T>();
        for (Collection<? extends T> collection : collectionArray) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    @CheckForNull
    public static FileScope getFileScope(ModelElement modelElement) {
        FileScope fileScope;
        FileScope fileScope2 = fileScope = modelElement instanceof FileScope ? (FileScope)modelElement : null;
        while (fileScope == null && modelElement != null) {
            fileScope = (FileScope)((modelElement = modelElement.getInScope()) instanceof FileScope ? modelElement : null);
        }
        return fileScope;
    }

    @CheckForNull
    public static NamespaceScope getNamespaceScope(ModelElement modelElement) {
        NamespaceScope namespaceScope;
        NamespaceScope namespaceScope2 = namespaceScope = modelElement instanceof NamespaceScope ? (NamespaceScope)modelElement : null;
        while (namespaceScope == null && modelElement != null) {
            namespaceScope = (NamespaceScope)((modelElement = modelElement.getInScope()) instanceof NamespaceScope ? modelElement : null);
        }
        return namespaceScope;
    }

    @CheckForNull
    public static NamespaceScope getNamespaceScope(FileScope fileScope, int n) {
        NamespaceScope namespaceScope = fileScope.getDefaultDeclaredNamespace();
        Collection<? extends NamespaceScope> collection = fileScope.getDeclaredNamespaces();
        for (NamespaceScope namespaceScope2 : collection) {
            OffsetRange offsetRange = namespaceScope2.getBlockRange();
            if (offsetRange == null || !offsetRange.containsInclusive(n) || namespaceScope != null && namespaceScope2.isDefaultNamespace()) continue;
            namespaceScope = namespaceScope2;
        }
        return namespaceScope;
    }

    @CheckForNull
    public static TypeScope getTypeScope(ModelElement modelElement) {
        TypeScope typeScope;
        TypeScope typeScope2 = typeScope = modelElement instanceof TypeScope ? (TypeScope)modelElement : null;
        while (typeScope == null && modelElement != null) {
            typeScope = (TypeScope)((modelElement = modelElement.getInScope()) instanceof TypeScope ? modelElement : null);
        }
        return typeScope;
    }

    @CheckForNull
    public static ClassScope getClassScope(ModelElement modelElement) {
        ClassScope classScope;
        ClassScope classScope2 = classScope = modelElement instanceof ClassScope ? (ClassScope)modelElement : null;
        while (classScope == null && modelElement != null) {
            classScope = (ClassScope)((modelElement = modelElement.getInScope()) instanceof ClassScope ? modelElement : null);
        }
        return classScope;
    }

    @NonNull
    public static IndexScope getIndexScope(ModelElement modelElement) {
        IndexScope indexScope = modelElement instanceof IndexScope ? (IndexScope)modelElement : null;
        ModelElement modelElement2 = modelElement;
        while (indexScope == null && modelElement2 != null) {
            indexScope = (IndexScope)((modelElement2 = modelElement2.getInScope()) instanceof IndexScope ? modelElement2 : null);
        }
        if (indexScope == null) {
            FileScope fileScope = ModelUtils.getFileScope(modelElement);
            assert (fileScope != null);
            indexScope = fileScope.getIndexScope();
        }
        return indexScope;
    }

    public static <T extends ModelElement> List<? extends T> filter(Collection<? extends T> collection, ElementFilter<T> elementFilter) {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (ModelElement modelElement : collection) {
            boolean bl = elementFilter.isAccepted(modelElement);
            if (!bl) continue;
            arrayList.add(modelElement);
        }
        return arrayList;
    }

    public static boolean nameKindMatch(String string, QuerySupport.Kind kind, String ... stringArray) {
        return ModelUtils.nameKindMatch(true, string, kind, stringArray);
    }

    private static boolean nameKindMatch(boolean bl, String string, QuerySupport.Kind kind, String ... stringArray) {
        block8: for (String string2 : stringArray) {
            switch (kind) {
                case CAMEL_CASE: {
                    if (!ModelUtils.toCamelCase(string).startsWith(string2)) continue block8;
                    return true;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue block8;
                    return true;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    string = string.toLowerCase();
                }
                case REGEXP: {
                    Pattern pattern = Pattern.compile(string2);
                    if (!ModelUtils.nameKindMatch(pattern, string)) continue block8;
                    return true;
                }
                case EXACT: {
                    boolean bl2;
                    boolean bl3 = bl2 = bl ? string.equalsIgnoreCase(string2) : string.equals(string2);
                    if (!bl2) continue block8;
                    return true;
                }
                case PREFIX: {
                    if (!string.startsWith(string2)) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getCamelCaseName(ModelElement modelElement) {
        return ModelUtils.toCamelCase(modelElement.getName());
    }

    public static String toCamelCase(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = string.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            cArray[n] = c;
            ++n;
        }
        return String.valueOf(String.valueOf(cArray, 0, n));
    }

    private static boolean nameKindMatch(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ElementFilter<T extends ModelElement> {
        public boolean isAccepted(T var1);
    }
}

