/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Arrays;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.openide.util.Exceptions;

public class PHPNewLineIndenter {
    private Context context;
    private static final Collection<PHPTokenId> CONTROL_STATEMENT_TOKENS = Arrays.asList(PHPTokenId.PHP_DO, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE);
    private Collection<ScopeDelimiter> scopeDelimiters = null;
    private int indentSize;
    private int continuationSize;

    public PHPNewLineIndenter(Context context) {
        this.context = context;
        this.indentSize = CodeStyle.get(context.document()).getIndentSize();
        this.continuationSize = CodeStyle.get(context.document()).getContinuationIndentSize();
        int n = CodeStyle.get(context.document()).getInitialIndent();
        this.scopeDelimiters = Arrays.asList(new ScopeDelimiter(PHPTokenId.PHP_SEMICOLON, 0), new ScopeDelimiter(PHPTokenId.PHP_OPENTAG, n), new ScopeDelimiter(PHPTokenId.PHP_CURLY_CLOSE, 0), new ScopeDelimiter(PHPTokenId.PHP_CURLY_OPEN, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_CASE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_IF, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_ELSE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_ELSEIF, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_WHILE, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_DO, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_FOR, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_FOREACH, this.indentSize), new ScopeDelimiter(PHPTokenId.PHP_DEFAULT, this.indentSize));
    }

    public void process() {
        final BaseDocument baseDocument = (BaseDocument)this.context.document();
        final int n = this.context.caretOffset();
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                try {
                    int n11 = 0;
                    boolean bl = false;
                    TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)baseDocument, n);
                    int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(Utilities.getRowStart((BaseDocument)baseDocument, (int)n) - 1));
                    tokenSequence.move(n);
                    tokenSequence.moveNext();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (tokenSequence.token().id() == PHPTokenId.WHITESPACE && tokenSequence.moveNext()) {
                        bl3 = true;
                    }
                    if (tokenSequence.token().id() == PHPTokenId.PHP_COMMENT || tokenSequence.token().id() == PHPTokenId.PHP_LINE_COMMENT || tokenSequence.token().id() == PHPTokenId.PHP_COMMENT_START || tokenSequence.token().id() == PHPTokenId.PHP_COMMENT_END) {
                        if (tokenSequence.token().id() == PHPTokenId.PHP_COMMENT_START && tokenSequence.offset() >= n) {
                            bl2 = true;
                        } else {
                            if (!bl3) {
                                return;
                            }
                            if (tokenSequence.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                                tokenSequence.movePrevious();
                                CharSequence charSequence = tokenSequence.token().text();
                                if (tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                                    int n3;
                                    for (n3 = 0; n3 < charSequence.length() && charSequence.charAt(n3) != '\n'; ++n3) {
                                    }
                                    if (n3 == charSequence.length()) {
                                        return;
                                    }
                                }
                                tokenSequence.moveNext();
                                bl3 = false;
                            }
                        }
                    }
                    if (bl3) {
                        tokenSequence.movePrevious();
                    }
                    if (tokenSequence.token().id() == PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING && n > tokenSequence.offset()) {
                        int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)tokenSequence.offset());
                        n11 = n4 >= n2 ? Utilities.getRowIndent((BaseDocument)baseDocument, (int)n4) + PHPNewLineIndenter.this.indentSize : Utilities.getRowIndent((BaseDocument)baseDocument, (int)n2);
                        bl = true;
                    }
                    int n5 = 0;
                    while (!bl && tokenSequence.movePrevious()) {
                        int n6;
                        Token token = tokenSequence.token();
                        ScopeDelimiter scopeDelimiter = PHPNewLineIndenter.this.getScopeDelimiter(token);
                        int n7 = tokenSequence.offset();
                        int n8 = 0;
                        if (scopeDelimiter != null) {
                            if (scopeDelimiter.tokenId == PHPTokenId.PHP_SEMICOLON) {
                                if (PHPNewLineIndenter.this.breakProceededByCase(tokenSequence)) {
                                    n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n7) - PHPNewLineIndenter.this.indentSize;
                                    break;
                                }
                                CodeB4BreakData codeB4BreakData = PHPNewLineIndenter.this.processCodeBeforeBreak(tokenSequence, bl2);
                                n7 = codeB4BreakData.expressionStartOffset;
                                n8 = codeB4BreakData.indentDelta;
                                if (codeB4BreakData.processedByControlStmt) {
                                    n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n7) - PHPNewLineIndenter.this.indentSize;
                                    break;
                                }
                                n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n7) + scopeDelimiter.indentDelta + n8;
                                break;
                            }
                            if (scopeDelimiter.tokenId == PHPTokenId.PHP_CURLY_OPEN && tokenSequence.movePrevious()) {
                                n6 = PHPNewLineIndenter.findStartTokenOfExpression(tokenSequence);
                                n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n6) + PHPNewLineIndenter.this.indentSize;
                                break;
                            }
                            n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n7) + scopeDelimiter.indentDelta + n8;
                            break;
                        }
                        if (tokenSequence.token().id() == PHPTokenId.PHP_TOKEN) {
                            n6 = tokenSequence.token().text().charAt(0);
                            boolean bl4 = false;
                            switch (n6) {
                                case 41: {
                                    ++n5;
                                    break;
                                }
                                case 40: {
                                    if (n5 == 0) {
                                        bl4 = true;
                                    }
                                    --n5;
                                    break;
                                }
                                case 44: {
                                    bl4 = true;
                                }
                            }
                            if (!bl4) continue;
                            tokenSequence.move(n);
                            tokenSequence.moveNext();
                            int n9 = PHPNewLineIndenter.findStartTokenOfExpression(tokenSequence);
                            if (n9 == -1) break;
                            int n10 = PHPNewLineIndenter.this.offsetArrayDeclaration(n9, tokenSequence);
                            if (n10 > -1) {
                                n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n10) + PHPNewLineIndenter.this.indentSize;
                                break;
                            }
                            n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n9) + PHPNewLineIndenter.this.continuationSize;
                            break;
                        }
                        if (tokenSequence.token().id() != PHPTokenId.PHP_OBJECT_OPERATOR || (n6 = PHPNewLineIndenter.findStartTokenOfExpression(tokenSequence)) == -1) continue;
                        n11 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n6) + PHPNewLineIndenter.this.continuationSize;
                        break;
                    }
                    if (n11 < 0) {
                        n11 = 0;
                    }
                    PHPNewLineIndenter.this.context.modifyIndent(Utilities.getRowStart((BaseDocument)baseDocument, (int)n), n11);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
    }

    private CodeB4BreakData processCodeBeforeBreak(TokenSequence tokenSequence, boolean bl) {
        CodeB4BreakData codeB4BreakData = new CodeB4BreakData();
        int n = tokenSequence.offset();
        Token token = tokenSequence.token();
        if (token.id() == PHPTokenId.PHP_SEMICOLON && tokenSequence.movePrevious()) {
            codeB4BreakData.expressionStartOffset = PHPNewLineIndenter.findStartTokenOfExpression(tokenSequence);
            codeB4BreakData.indentDelta = 0;
            codeB4BreakData.processedByControlStmt = false;
            return codeB4BreakData;
        }
        while (tokenSequence.movePrevious()) {
            token = tokenSequence.token();
            ScopeDelimiter scopeDelimiter = this.getScopeDelimiter(token);
            if (scopeDelimiter != null) {
                codeB4BreakData.expressionStartOffset = tokenSequence.offset();
                codeB4BreakData.indentDelta = scopeDelimiter.indentDelta;
                if (!CONTROL_STATEMENT_TOKENS.contains(scopeDelimiter.tokenId)) break;
                codeB4BreakData.indentDelta = 0;
                break;
            }
            if (!bl || token.id() != PHPTokenId.WHITESPACE || ((Object)token.text()).toString().indexOf(10) == -1 || !tokenSequence.moveNext()) continue;
            codeB4BreakData.expressionStartOffset = tokenSequence.offset();
            codeB4BreakData.indentDelta = 0;
            break;
        }
        if (token.id() == PHPTokenId.PHP_OPENTAG && tokenSequence.moveNext()) {
            token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
            codeB4BreakData.expressionStartOffset = tokenSequence.offset();
            codeB4BreakData.indentDelta = 0;
        }
        tokenSequence.move(n);
        tokenSequence.moveNext();
        return codeB4BreakData;
    }

    private int offsetArrayDeclaration(int n, TokenSequence tokenSequence) {
        Token token;
        int n2 = -1;
        int n3 = tokenSequence.offset();
        int n4 = 0;
        do {
            if ((token = tokenSequence.token()).id() != PHPTokenId.PHP_TOKEN) continue;
            switch (token.text().charAt(0)) {
                case ')': {
                    --n4;
                    break;
                }
                case '(': {
                    ++n4;
                }
            }
        } while (tokenSequence.offset() > n && (token.id() != PHPTokenId.PHP_ARRAY || n4 != 1) && tokenSequence.movePrevious());
        if (token.id() == PHPTokenId.PHP_ARRAY && n4 == 1) {
            n2 = tokenSequence.offset();
        }
        tokenSequence.move(n3);
        tokenSequence.moveNext();
        return n2;
    }

    protected static int findStartTokenOfExpression(TokenSequence tokenSequence) {
        Token<? extends PHPTokenId> token;
        int n = -1;
        int n2 = tokenSequence.offset();
        int n3 = 0;
        int n4 = 0;
        do {
            if ((token = tokenSequence.token()).id() == PHPTokenId.PHP_TOKEN) {
                switch (token.text().charAt(0)) {
                    case ')': {
                        --n3;
                        break;
                    }
                    case '(': {
                        ++n3;
                    }
                }
                continue;
            }
            if ((token.id() == PHPTokenId.PHP_SEMICOLON || token.id() == PHPTokenId.PHP_OPENTAG) && tokenSequence.moveNext()) {
                token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                n = tokenSequence.offset();
                break;
            }
            if (token.id() == PHPTokenId.PHP_IF) {
                int n5 = tokenSequence.offset();
                token = LexUtilities.findNextToken((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_TOKEN));
                if (tokenSequence.offset() < n2 && token.text().charAt(0) == '(') {
                    int n6 = 1;
                    while (n == -1 && n6 > 0 && tokenSequence.offset() < n2 && tokenSequence.moveNext()) {
                        token = LexUtilities.findNextToken((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_TOKEN));
                        if (token.text().charAt(0) == '(') {
                            ++n6;
                            continue;
                        }
                        if (token.text().charAt(0) != ')') continue;
                        --n6;
                    }
                    if (n6 == 0 && tokenSequence.moveNext() && tokenSequence.offset() < n2) {
                        n = n5;
                        break;
                    }
                    if (n6 > 0) {
                        n6 = 0;
                        while (n6 < 1 && tokenSequence.offset() > n5 && tokenSequence.movePrevious()) {
                            token = LexUtilities.findPreviousToken((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.PHP_TOKEN));
                            if (token.text().charAt(0) == '(') {
                                ++n6;
                                continue;
                            }
                            if (token.text().charAt(0) != ')') continue;
                            --n6;
                        }
                        if (n6 != 1 || !tokenSequence.movePrevious()) break;
                        token = LexUtilities.findPrevious((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                        n = tokenSequence.offset();
                        break;
                    }
                    if (n6 != 0) continue;
                    n = n5;
                    break;
                }
                tokenSequence.move(n5);
                tokenSequence.movePrevious();
                continue;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_CLOSE) {
                if (--n4 != -1 || !tokenSequence.moveNext()) continue;
                token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (tokenSequence.offset() <= n2) {
                    n = tokenSequence.offset();
                    break;
                }
                n = n2;
                break;
            }
            if (token.id() == PHPTokenId.PHP_CURLY_OPEN) {
                if (++n4 != 1 || !tokenSequence.moveNext()) continue;
                token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT));
                if (tokenSequence.offset() <= n2) {
                    n = tokenSequence.offset();
                    break;
                }
                n = n2;
                break;
            }
            if (n3 != 1 || token.id() != PHPTokenId.PHP_STRING) continue;
            n = tokenSequence.offset();
            break;
        } while (tokenSequence.movePrevious());
        if (!tokenSequence.movePrevious()) {
            token = LexUtilities.findNext((TokenSequence<? extends PHPTokenId>)tokenSequence, Arrays.asList(PHPTokenId.WHITESPACE, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_OPENTAG));
            n = tokenSequence.offset();
        }
        tokenSequence.move(n2);
        tokenSequence.moveNext();
        return n;
    }

    private boolean breakProceededByCase(TokenSequence tokenSequence) {
        boolean bl = false;
        int n = tokenSequence.offset();
        if (tokenSequence.movePrevious() && this.semicolonProceededByBreak(tokenSequence)) {
            while (tokenSequence.movePrevious()) {
                TokenId tokenId = tokenSequence.token().id();
                if (tokenId == PHPTokenId.PHP_CASE) {
                    bl = true;
                    break;
                }
                if (!CONTROL_STATEMENT_TOKENS.contains(tokenId)) continue;
                break;
            }
        }
        tokenSequence.move(n);
        tokenSequence.moveNext();
        return bl;
    }

    private boolean semicolonProceededByBreak(TokenSequence tokenSequence) {
        boolean bl = false;
        if (tokenSequence.token().id() == PHPTokenId.PHP_BREAK) {
            bl = true;
        } else if (tokenSequence.token().id() == PHPTokenId.PHP_NUMBER) {
            int n = tokenSequence.offset();
            if (tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.WHITESPACE && tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.PHP_BREAK) {
                bl = true;
            }
            tokenSequence.move(n);
            tokenSequence.moveNext();
        }
        return bl;
    }

    private ScopeDelimiter getScopeDelimiter(Token token) {
        for (ScopeDelimiter scopeDelimiter : this.scopeDelimiters) {
            if (!scopeDelimiter.matches(token)) continue;
            return scopeDelimiter;
        }
        return null;
    }

    private static class ScopeDelimiter {
        private TokenId tokenId;
        private String tokenContent;
        private int indentDelta;

        public ScopeDelimiter(TokenId tokenId, int n) {
            this(tokenId, null, n);
        }

        public ScopeDelimiter(TokenId tokenId, String string, int n) {
            this.tokenId = tokenId;
            this.tokenContent = string;
            this.indentDelta = n;
        }

        public boolean matches(Token token) {
            if (this.tokenId != token.id()) {
                return false;
            }
            return this.tokenContent == null || !TokenUtilities.equals((CharSequence)token.text(), (Object)this.tokenContent);
        }
    }

    private static class CodeB4BreakData {
        int expressionStartOffset;
        boolean processedByControlStmt;
        int indentDelta;

        private CodeB4BreakData() {
        }
    }
}

