/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.php.editor.indent.FmtOptions;

public final class CodeStyle {
    private Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static CodeStyle get(Preferences preferences) {
        return new CodeStyle(preferences);
    }

    public static CodeStyle get(Document document) {
        return new CodeStyle(CodeStylePreferences.get((Document)document).getPreferences());
    }

    public int getIndentSize() {
        return this.preferences.getInt("indent-shift-width", FmtOptions.getDefaultAsInt("indent-shift-width"));
    }

    public String getOpeningBraceStyle() {
        return this.preferences.get("openingBraceStyle", FmtOptions.getDefaultAsString("openingBraceStyle"));
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", FmtOptions.getDefaultAsInt("continuationIndentSize"));
    }

    public int getInitialIndent() {
        return this.preferences.getInt("init.indent", FmtOptions.getDefaultAsInt("init.indent"));
    }

    public boolean reformatComments() {
        return this.preferences.getBoolean("reformatComments", FmtOptions.getDefaultAsBoolean("reformatComments"));
    }

    public boolean indentHtml() {
        return this.preferences.getBoolean("indentHtml", FmtOptions.getDefaultAsBoolean("indentHtml"));
    }

    public int getRightMargin() {
        return this.preferences.getInt("text-limit-width", FmtOptions.getDefaultAsInt("text-limit-width"));
    }
}

