/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.actions.ImportModulePanel;
import org.netbeans.modules.php.editor.actions.PopupUtil;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FastImportAction
extends BaseAction {
    private static final String ACTION_NAME = "fast-import";

    public FastImportAction() {
        super(ACTION_NAME);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        try {
            final Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
            final Font font = jTextComponent.getFont();
            final Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(point, jTextComponent);
            final int n = jTextComponent.getCaretPosition();
            final String string = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)jTextComponent), (int)n);
            if (string == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)jTextComponent.getDocument())), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                        FastImportAction.this.importItem(parserResult, point, rectangle, font, n, string);
                    }
                });
            }
            catch (ParseException parseException) {
                Exceptions.printStackTrace((Throwable)parseException);
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private void importItem(final ParserResult parserResult, final Point point, final Rectangle rectangle, final Font font, final int n, final String string) {
        PHPParseResult pHPParseResult = (PHPParseResult)parserResult;
        Model model = pHPParseResult.getModel();
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(n);
        Occurence occurence = occurencesSupport.getOccurence();
        if (occurence != null) {
            FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
            File file = FileUtil.toFile((FileObject)fileObject);
            File file2 = file.getParentFile();
            final LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            final LinkedHashSet linkedHashSet2 = new LinkedHashSet();
            ArrayList<? extends ModelElement> arrayList = new ArrayList<ModelElement>(occurence.getAllDeclarations());
            arrayList.add(occurence.getDeclaration());
            for (ModelElement modelElement : arrayList) {
                String string2;
                FileObject fileObject2 = modelElement.getFileObject();
                File file3 = FileUtil.toFile((FileObject)fileObject2);
                PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fileObject2);
                String string3 = PropertyUtils.relativizeFile((File)file2, (File)file3);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\"").append(string3).append("\";");
                LinkedHashSet<String> linkedHashSet3 = null;
                if (fileType.equals((Object)PhpSourcePath.FileType.INTERNAL)) {
                    string2 = (Object)((Object)modelElement.getPhpKind()) + " " + modelElement.getName();
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(FastImportAction.class, (String)"MSG_NO_IMPORTS_FOR_PLATFORM", (Object)string2));
                    continue;
                }
                if (fileObject == fileObject2) {
                    string2 = (Object)((Object)modelElement.getPhpKind()) + " " + modelElement.getName();
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(FastImportAction.class, (String)"MSG_NO_IMPORTS_FOR_CURRENT_FILE", (Object)string2, (Object)file.getAbsolutePath()));
                    continue;
                }
                linkedHashSet3 = linkedHashSet;
                linkedHashSet3.add("require_once " + stringBuilder.toString());
                linkedHashSet3.add("require " + stringBuilder.toString());
                linkedHashSet3.add("include " + stringBuilder.toString());
                linkedHashSet3.add("include_once " + stringBuilder.toString());
            }
            if (linkedHashSet.size() > 0 || linkedHashSet2.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ImportModulePanel importModulePanel = new ImportModulePanel(string, new ArrayList<String>(linkedHashSet), new ArrayList<String>(linkedHashSet2), font, parserResult, n);
                        PopupUtil.showPopup(importModulePanel, "", point.x, point.y, true, rectangle.height);
                    }
                });
            }
        }
    }
}

