/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.transform.Source;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.modules.xsl.settings.TransformHistory;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public final class TransformPanel
extends JPanel {
    private static final long serialVersionUID = -3449709794133206327L;
    public static final String DATA_XML_MODIFIED = "DATA_XML_MODIFIED";
    public static final String DATA_XSL_MODIFIED = "DATA_XSL_MODIFIED";
    public static final String DATA_OUTPUT_MODIFIED = "DATA_OUTPUT_MODIFIED";
    public static final String DATA_PROCESS_MODIFIED = "DATA_PROCESS_MODIFIED";
    public static final String DATA_OVERWRITE_MODIFIED = "DATA_OVERWRITE_MODIFIED";
    private URL baseURL;
    private Data data;
    private boolean initialized = false;
    private DataObject xmlDataObject;
    private String xml_stylesheet;
    private DataObject xslDataObject;
    private TransformHistory xmlHistory;
    private TransformHistory xslHistory;
    private boolean userSetOutput = false;
    private boolean userSetProcess = false;
    private String lastOutputFileExt = "html";
    private Object lastXSLObject = new Object();
    private boolean suppressXSL;
    private static final String[] SHOW_NAMES = new String[]{NbBundle.getMessage(TransformPanel.class, (String)"NAME_process_output_do_nothing"), NbBundle.getMessage(TransformPanel.class, (String)"NAME_process_output_apply_default_action"), NbBundle.getMessage(TransformPanel.class, (String)"NAME_process_output_open_in_browser")};
    private static final Object JUST_PREVIEW = new Preview();
    private JButton browseInputButton;
    private JButton browseXSLTButton;
    private JComboBox inputComboBox;
    private JLabel inputLabel;
    private JComboBox outputComboBox;
    private JLabel outputLabel;
    private JCheckBox overwriteCheckBox;
    private JComboBox showComboBox;
    private JLabel showLabel;
    private JComboBox transformComboBox;
    private JLabel transformLabel;

    public TransformPanel(DataObject dataObject, String string, DataObject dataObject2, boolean bl) throws MalformedURLException, FileStateInvalidException {
        this.initComponents();
        this.init(dataObject, string, dataObject2, bl);
        this.initAccessibility();
    }

    public TransformPanel(DataObject dataObject, String string, DataObject dataObject2) throws MalformedURLException, FileStateInvalidException {
        this(dataObject, string, dataObject2, false);
    }

    private void init(DataObject dataObject, String string, DataObject dataObject2, boolean bl) throws MalformedURLException, FileStateInvalidException {
        FileObject fileObject;
        this.data = new Data();
        this.xmlDataObject = dataObject;
        this.xml_stylesheet = string;
        this.xslDataObject = dataObject2;
        this.suppressXSL = bl;
        if (this.xmlDataObject != null) {
            this.setInput(TransformUtil.getURLName(this.xmlDataObject.getPrimaryFile()));
            fileObject = this.xmlDataObject.getPrimaryFile();
            this.xmlHistory = (TransformHistory)fileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (this.xmlHistory != null) {
                this.setXSL(this.xmlHistory.getLastXSL());
            }
            if (this.data.xsl == null && this.xml_stylesheet != null) {
                this.setXSL(this.xml_stylesheet);
            }
            try {
                this.baseURL = fileObject.getParent().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        if (this.xslDataObject != null) {
            this.setXSL(TransformUtil.getURLName(this.xslDataObject.getPrimaryFile()));
            fileObject = this.xslDataObject.getPrimaryFile();
            this.xslHistory = (TransformHistory)fileObject.getAttribute("org.netbeans.modules.xsl.settings.TransformHistory");
            if (this.data.xml == null && this.xslHistory != null) {
                this.setInput(this.xslHistory.getLastXML());
            }
            if (this.baseURL == null) {
                try {
                    this.baseURL = fileObject.getParent().getURL();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
        }
        if (this.xmlHistory != null || this.xslHistory != null) {
            if (this.xmlHistory != null) {
                this.setOutput(this.xmlHistory.getLastXSLOutput());
            }
            if ((this.data.output == null || this.data.output instanceof String && "".equals(this.data.output)) && this.xslHistory != null) {
                this.setOutput(this.xslHistory.getLastXMLOutput());
            }
            if (this.data.output == null) {
                this.setOutput(JUST_PREVIEW);
            }
        }
        if (this.xmlHistory != null) {
            this.setOverwriteOutput(this.xmlHistory.isOverwriteOutput());
            this.setProcessOutput(new Integer(this.xmlHistory.getProcessOutput()));
        } else if (this.xslHistory != null) {
            this.setOverwriteOutput(this.xslHistory.isOverwriteOutput());
            this.setProcessOutput(new Integer(this.xslHistory.getProcessOutput()));
        }
        this.ownInitComponents();
    }

    private void ownInitComponents() {
        this.updateXMLComboBoxModel(null);
        this.updateXSLComboBoxModel(null);
        this.updateComponents();
        this.setCaretPosition(this.inputComboBox);
        this.setCaretPosition(this.transformComboBox);
        this.setCaretPosition(this.outputComboBox);
    }

    private void setCaretPosition(JComboBox jComboBox) {
        ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
        final Component component = comboBoxEditor.getEditorComponent();
        if (component instanceof JTextField) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JTextField jTextField = (JTextField)component;
                    int n = jTextField.getText().length();
                    jTextField.setCaretPosition(n);
                }
            });
        }
    }

    private void updateXMLComboBoxModel(Object object) {
        String[] stringArray = null;
        if (this.xmlDataObject == null && this.xslHistory != null) {
            stringArray = this.xslHistory.getXMLs();
        }
        Vector<Object> vector = new Vector<Object>();
        if (object != null) {
            vector.add(object);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        this.inputComboBox.setModel(new DefaultComboBoxModel(vector));
    }

    private void updateXSLComboBoxModel(Object object) {
        String[] stringArray = null;
        if (this.xslDataObject == null && this.xmlHistory != null) {
            stringArray = this.xmlHistory.getXSLs();
        }
        Vector<Object> vector = new Vector<Object>();
        if (object != null) {
            vector.add(object);
        }
        if (this.xml_stylesheet != null) {
            vector.add(this.xml_stylesheet);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].equals(this.xml_stylesheet)) continue;
                vector.add(stringArray[i]);
            }
        }
        this.transformComboBox.setModel(new DefaultComboBoxModel(vector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitialized() {
        Data data = this.data;
        synchronized (data) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialized(boolean bl) {
        Data data = this.data;
        synchronized (data) {
            this.initialized = bl;
        }
    }

    private static String guessFileName(String string) {
        String string2 = null;
        int n = string.lastIndexOf(47);
        string2 = n != -1 ? string.substring(n + 1) : string;
        return string2;
    }

    private String guessOutputFileExt() {
        String string = this.lastOutputFileExt;
        String string2 = this.getXSL();
        if (string2 != this.lastXSLObject) {
            try {
                Source source = TransformUtil.createSource(this.baseURL, string2);
                string = TransformUtil.guessOutputExt(source);
                this.lastXSLObject = string2;
                this.lastOutputFileExt = string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private Object guessOutputFile() {
        Object object = this.data.output;
        if (object == null || "".equals(object) || JUST_PREVIEW.equals(object)) {
            String string = TransformPanel.guessFileName(this.data.xml);
            String string2 = "";
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            String string3 = this.guessOutputFileExt();
            String string4 = "";
            if (string3.equals(string2)) {
                string4 = NbBundle.getMessage(TransformPanel.class, (String)"NAME_plusNameIfSameName");
            }
            object = string + string4 + "." + string3;
        }
        return object;
    }

    private void initOutputComboBox(Object object) {
        this.outputComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{object, JUST_PREVIEW}));
    }

    private void updateComponents() {
        Object object;
        boolean bl;
        boolean bl2;
        this.setInitialized(false);
        boolean bl3 = bl2 = this.xmlDataObject == null;
        if (this.data.xml != null) {
            this.inputComboBox.setSelectedItem(this.data.xml);
            this.inputComboBox.setEditable(this.data.xml instanceof String);
        }
        this.inputComboBox.setEnabled(bl2);
        this.browseInputButton.setEnabled(bl2);
        if (this.suppressXSL) {
            this.transformLabel.setVisible(false);
            this.transformComboBox.setVisible(false);
            this.browseXSLTButton.setVisible(false);
        } else {
            this.transformLabel.setVisible(true);
            this.transformComboBox.setVisible(true);
            this.browseXSLTButton.setVisible(true);
            bl = this.xslDataObject == null;
            this.transformComboBox.setEnabled(bl);
            this.browseXSLTButton.setEnabled(bl);
            if (this.data.xsl != null) {
                this.transformComboBox.setSelectedItem(this.data.xsl);
                this.transformComboBox.setEditable(this.data.xsl instanceof String);
            }
        }
        bl = true;
        if (this.data.xml == null || this.data.xsl == null || this.data.xml.length() == 0 || this.data.xsl.length() == 0) {
            bl = false;
        }
        this.outputComboBox.setEnabled(bl);
        if (bl) {
            object = this.guessOutputFile();
            this.initOutputComboBox(object);
            this.outputComboBox.setSelectedItem(this.data.output != null ? object : JUST_PREVIEW);
            this.outputComboBox.setEditable(this.data.output != null);
        }
        if (this.data.overwrite != null) {
            this.overwriteCheckBox.setSelected(this.data.overwrite);
        }
        this.overwriteCheckBox.setEnabled(bl && this.data.output != null);
        if (this.data.process != null) {
            this.showComboBox.setSelectedIndex(this.data.process);
        } else {
            object = this.guessOutputFileExt().toLowerCase();
            if (((String)object).equals("html") || ((String)object).equals("htm")) {
                this.showComboBox.setSelectedIndex(2);
            } else {
                this.showComboBox.setSelectedIndex(1);
            }
        }
        this.showComboBox.setEnabled(bl && this.data.output != null);
        this.setInitialized(true);
    }

    public Data getData() {
        return new Data(this.getInput(), this.getXSL(), this.getOutput(), this.isOverwriteOutput(), this.getProcessOutput());
    }

    public void setData(Data data) {
        this.data = data;
        this.updateComponents();
    }

    private String getInput() {
        return (String)this.inputComboBox.getSelectedItem();
    }

    private String getXSL() {
        return (String)this.transformComboBox.getSelectedItem();
    }

    private String getOutput() {
        Object object = this.outputComboBox.getSelectedItem();
        if (JUST_PREVIEW.equals(object)) {
            return null;
        }
        return (String)object;
    }

    private boolean isOverwriteOutput() {
        return this.overwriteCheckBox.isSelected();
    }

    private int getProcessOutput() {
        return this.showComboBox.getSelectedIndex();
    }

    private Dimension comboSize(int n) {
        JTextField jTextField = new JTextField();
        jTextField.setColumns(n);
        return jTextField.getPreferredSize();
    }

    private void initComponents() {
        this.inputLabel = new JLabel();
        this.inputLabel.setDisplayedMnemonic(NbBundle.getMessage(TransformPanel.class, (String)"LBL_XML_input_mnemonic").charAt(0));
        this.inputComboBox = new JComboBox();
        this.browseInputButton = new JButton();
        this.transformLabel = new JLabel();
        this.transformLabel.setDisplayedMnemonic(NbBundle.getMessage(TransformPanel.class, (String)"LBL_XSL_transform_mnemonic").charAt(0));
        this.transformComboBox = new JComboBox();
        this.browseXSLTButton = new JButton();
        this.outputLabel = new JLabel();
        this.outputLabel.setDisplayedMnemonic(NbBundle.getMessage(TransformPanel.class, (String)"LBL_trans_output_mnemonic").charAt(0));
        this.outputComboBox = new JComboBox();
        this.overwriteCheckBox = new JCheckBox();
        this.overwriteCheckBox.setMnemonic(NbBundle.getMessage(TransformPanel.class, (String)"LBL_over_write_mnemonic").charAt(0));
        this.showLabel = new JLabel();
        this.showLabel.setDisplayedMnemonic(NbBundle.getMessage(TransformPanel.class, (String)"LBL_show_output_mnemonic").charAt(0));
        this.showComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.inputLabel.setLabelFor(this.inputComboBox);
        this.inputLabel.setText(NbBundle.getMessage(TransformPanel.class, (String)"LBL_XML_input"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.inputLabel, gridBagConstraints);
        this.inputComboBox.setEditable(true);
        this.inputComboBox.setPreferredSize(this.comboSize(40));
        this.inputComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.inputComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.inputComboBox, gridBagConstraints);
        this.browseInputButton.setMnemonic(NbBundle.getMessage(TransformPanel.class, (String)"LBL_browse_file_mnemonic").charAt(0));
        this.browseInputButton.setText(NbBundle.getMessage(TransformPanel.class, (String)"LBL_browse_file"));
        this.browseInputButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.browseInputButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.browseInputButton, gridBagConstraints);
        this.transformLabel.setLabelFor(this.transformComboBox);
        this.transformLabel.setText(NbBundle.getMessage(TransformPanel.class, (String)"LBL_XSL_transform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.transformLabel, gridBagConstraints);
        this.transformComboBox.setEditable(true);
        this.transformComboBox.setPreferredSize(this.comboSize(40));
        this.transformComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.transformComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.transformComboBox, gridBagConstraints);
        this.browseXSLTButton.setMnemonic(NbBundle.getMessage(TransformPanel.class, (String)"LBL_browse_xslt_mnemonic").charAt(0));
        this.browseXSLTButton.setText(NbBundle.getMessage(TransformPanel.class, (String)"LBL_browse_xslt"));
        this.browseXSLTButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.browseXSLTButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.browseXSLTButton, gridBagConstraints);
        this.outputLabel.setLabelFor(this.outputComboBox);
        this.outputLabel.setText(NbBundle.getMessage(TransformPanel.class, (String)"LBL_trans_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.outputLabel, gridBagConstraints);
        this.outputComboBox.setEditable(true);
        this.outputComboBox.setPreferredSize(this.comboSize(40));
        this.outputComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.outputComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.outputComboBox, gridBagConstraints);
        this.overwriteCheckBox.setSelected(true);
        this.overwriteCheckBox.setText(NbBundle.getMessage(TransformPanel.class, (String)"LBL_over_write"));
        this.overwriteCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.overwriteCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.overwriteCheckBox, gridBagConstraints);
        this.showLabel.setText(NbBundle.getMessage(TransformPanel.class, (String)"LBL_show_output"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.showLabel, gridBagConstraints);
        this.showComboBox.setModel(new DefaultComboBoxModel<String>(SHOW_NAMES));
        this.showComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransformPanel.this.showComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 6, 0);
        this.add((Component)this.showComboBox, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_TransformPanel"));
        this.overwriteCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_overwriteCheckBox"));
        this.outputComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_outputComboBox"));
        this.inputComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_inputComboBox"));
        this.browseXSLTButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_browseXSLTButton"));
        this.showComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_showComboBox"));
        this.browseInputButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_browseInputButton"));
        this.transformComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransformPanel.class, (String)"ACSD_transformComboBox"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseXSLTButtonActionPerformed(ActionEvent actionEvent) {
        try {
            DataObject dataObject;
            File file = this.getFileFromChooser(this.getXSL());
            if (file == null) {
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            DataObject dataObject2 = dataObject = fileObject == null ? null : DataObject.find((FileObject)fileObject);
            if (dataObject == null || !TransformUtil.isXSLTransformation(dataObject)) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(TransformPanel.class, (String)"MSG_notXslFile", (Object)file.getName()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.setXSL(TransformUtil.getURLName(fileObject));
            if (!this.userSetOutput && this.xmlHistory != null) {
                this.setOutput(this.xmlHistory.getXSLOutput(this.data.xsl));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateXSLComboBoxModel(this.data.xsl);
            this.updateComponents();
            this.setCaretPosition(this.transformComboBox);
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseInputButtonActionPerformed(ActionEvent actionEvent) {
        try {
            DataObject dataObject;
            File file = this.getFileFromChooser(this.getInput());
            if (file == null) {
                return;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            DataObject dataObject2 = dataObject = fileObject == null ? null : DataObject.find((FileObject)fileObject);
            if (dataObject == null || dataObject.getCookie(TransformableCookie.class) == null) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(TransformPanel.class, (String)"MSG_notXmlFile", (Object)file.getName()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.setInput(TransformUtil.getURLName(fileObject));
            if (!this.userSetOutput && this.xslHistory != null) {
                this.setOutput(this.xslHistory.getXMLOutput(this.data.xml));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateXMLComboBoxModel(this.data.xml);
            this.updateComponents();
            this.setCaretPosition(this.inputComboBox);
        }
        catch (IOException iOException) {}
    }

    public void setInput(String string) {
        if (this.data == null) {
            return;
        }
        String string2 = this.data.getInput();
        this.data.setInput(string);
        this.firePropertyChange(DATA_XML_MODIFIED, string2, string);
    }

    public void setXSL(String string) {
        if (this.data == null) {
            return;
        }
        String string2 = this.data.getXSL();
        this.data.setXSL(string);
        this.firePropertyChange(DATA_XSL_MODIFIED, string2, string);
    }

    public void setOutput(Object object) {
        if (this.data == null) {
            return;
        }
        Object object2 = this.data.getOutput();
        this.data.setOutput(object);
        this.firePropertyChange(DATA_OUTPUT_MODIFIED, object2, object);
    }

    public void setOverwriteOutput(Boolean bl) {
        if (this.data == null || bl == null) {
            return;
        }
        this.setOverwriteOutput((boolean)bl);
    }

    public void setOverwriteOutput(boolean bl) {
        if (this.data == null) {
            return;
        }
        boolean bl2 = this.data.isOverwriteOutput();
        this.data.setOverwriteOutput(bl);
        this.firePropertyChange(DATA_OVERWRITE_MODIFIED, bl2, bl);
    }

    public void setProcessOutput(Integer n) {
        if (this.data == null || n == null) {
            return;
        }
        this.setProcessOutput((int)n);
    }

    public void setProcessOutput(int n) {
        if (this.data == null) {
            return;
        }
        int n2 = this.data.getProcessOutput();
        this.data.setProcessOutput(n);
        this.firePropertyChange(DATA_PROCESS_MODIFIED, n2, n);
    }

    private void showComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isInitialized()) {
            this.setProcessOutput(new Integer(this.showComboBox.getSelectedIndex()));
            this.userSetProcess = true;
            this.updateComponents();
        }
    }

    private void overwriteCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isInitialized()) {
            this.setOverwriteOutput(this.overwriteCheckBox.isSelected());
            this.updateComponents();
        }
    }

    private void transformComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isInitialized()) {
            String string = (String)this.transformComboBox.getSelectedItem();
            if (string == null) {
                return;
            }
            this.setXSL(string.trim());
            if (!this.userSetOutput && this.xmlHistory != null) {
                this.setOutput(this.xmlHistory.getXSLOutput(this.data.xsl));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateComponents();
        }
    }

    private void inputComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isInitialized()) {
            String string = (String)this.inputComboBox.getSelectedItem();
            if (string == null) {
                return;
            }
            this.setInput(string.trim());
            if (!this.userSetOutput && this.xslHistory != null) {
                this.setOutput(this.xslHistory.getXMLOutput(this.data.xml));
            }
            if (!this.userSetProcess) {
                this.setProcessOutput(null);
            }
            this.updateComponents();
        }
    }

    private void outputComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isInitialized()) {
            Object object = this.outputComboBox.getSelectedItem();
            if (object instanceof String) {
                String string = ((String)object).trim();
                if (string.length() == 0) {
                    string = null;
                }
                object = string;
            }
            this.setOutput(object);
            this.userSetOutput = true;
            this.updateComponents();
        }
    }

    private File getFileFromChooser(String string) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null) {
            try {
                File file2;
                file = null;
                URI uRI = new URI(string);
                if (uRI != null) {
                    file = new File(uRI);
                }
                if (file != null && (file2 = file.getParentFile()) != null && file2.exists()) {
                    jFileChooser.setCurrentDirectory(file2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        file = null;
        if (jFileChooser.showOpenDialog(this) == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    private static class Preview {
        private Preview() {
        }

        public String toString() {
            return NbBundle.getMessage(TransformPanel.class, (String)"NAME_output_just_preview");
        }
    }

    public static final class Data {
        private String xml;
        private String xsl;
        private Object output;
        private Boolean overwrite;
        private Integer process;

        public Data() {
            this.xml = null;
            this.xsl = null;
            this.output = "";
            this.overwrite = null;
            this.process = null;
        }

        public Data(String string, String string2, Object object, boolean bl, int n) {
            this.xml = string;
            this.xsl = string2;
            this.output = object;
            this.overwrite = bl ? Boolean.TRUE : Boolean.FALSE;
            this.process = n == -1 ? null : new Integer(n);
        }

        public String getInput() {
            return this.xml;
        }

        public String getXSL() {
            return this.xsl;
        }

        public Object getOutput() {
            return this.output;
        }

        public boolean isOverwriteOutput() {
            if (this.overwrite == null) {
                return false;
            }
            return this.overwrite;
        }

        public int getProcessOutput() {
            if (this.process == null) {
                return 0;
            }
            return this.process;
        }

        public void setInput(String string) {
            this.xml = string;
        }

        public void setXSL(String string) {
            this.xsl = string;
        }

        public void setOutput(Object object) {
            this.output = JUST_PREVIEW.equals(object) ? null : object;
        }

        public void setOverwriteOutput(boolean bl) {
            this.overwrite = bl ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setProcessOutput(Integer n) {
            this.process = n;
        }

        public void setProcessOutput(int n) {
            this.setProcessOutput(new Integer(n));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("[input='").append(this.xml).append("'; ");
            stringBuffer.append("xsl='").append(this.xsl).append("'; ");
            stringBuffer.append("output='").append(this.output).append("'; ");
            stringBuffer.append("overwrite='").append(this.overwrite).append("'; ");
            stringBuffer.append("process='").append(this.process).append("]");
            return stringBuffer.toString();
        }
    }
}

