/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitSettings;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.NbBundle;

class CommitTableModel
extends AbstractTableModel {
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(5);
    private CommitOptions[] commitOptions;
    private CvsFileNode[] nodes;
    private String[] columns;

    public CommitTableModel() {
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitTableModel.class);
        this.columnLabels.put("name", new String[]{resourceBundle.getString("CTL_CommitTable_Column_File"), resourceBundle.getString("CTL_CommitTable_Column_File")});
        this.columnLabels.put("sticky", new String[]{resourceBundle.getString("CTL_CommitTable_Column_Sticky"), resourceBundle.getString("CTL_CommitTable_Column_Sticky")});
        this.columnLabels.put("status", new String[]{resourceBundle.getString("CTL_CommitTable_Column_Status"), resourceBundle.getString("CTL_CommitTable_Column_Status")});
        this.columnLabels.put("action", new String[]{resourceBundle.getString("CTL_CommitTable_Column_Action"), resourceBundle.getString("CTL_CommitTable_Column_Action")});
        this.columnLabels.put("path", new String[]{resourceBundle.getString("CTL_CommitTable_Column_Folder"), resourceBundle.getString("CTL_CommitTable_Column_Folder")});
        this.setColumns(new String[0]);
        this.setNodes(new CvsFileNode[0]);
    }

    void setNodes(CvsFileNode[] cvsFileNodeArray) {
        this.nodes = cvsFileNodeArray;
        this.createCommitOptions();
        this.fireTableDataChanged();
    }

    void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.columns)) {
            return;
        }
        this.columns = stringArray;
        this.fireTableStructureChanged();
    }

    public CommitSettings.CommitFile[] getCommitFiles() {
        CommitSettings.CommitFile[] commitFileArray = new CommitSettings.CommitFile[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            commitFileArray[i] = new CommitSettings.CommitFile(this.nodes[i], this.commitOptions[i]);
        }
        return commitFileArray;
    }

    public String getColumnName(int n) {
        return this.columnLabels.get(this.columns[n])[0];
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int n) {
        String string = this.columns[n];
        if (string.equals("action")) {
            return CommitOptions.class;
        }
        return String.class;
    }

    public boolean isCellEditable(int n, int n2) {
        String string = this.columns[n2];
        return string.equals("action");
    }

    public Object getValueAt(int n, int n2) {
        String string = this.columns[n2];
        if (string.equals("name")) {
            return this.nodes[n].getName();
        }
        if (string.equals("sticky")) {
            String string2 = Utils.getSticky(this.nodes[n].getFile());
            return string2 == null ? "" : string2;
        }
        if (string.equals("status")) {
            return this.nodes[n].getInformation().getStatusText();
        }
        if (string.equals("action")) {
            return this.commitOptions[n];
        }
        if (string.equals("path")) {
            return Utils.getRelativePath(this.nodes[n].getFile());
        }
        throw new IllegalArgumentException("Column index out of range: " + n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = this.columns[n2];
        if (!string.equals("action")) {
            throw new IllegalArgumentException("Column index out of range: " + n2);
        }
        this.commitOptions[n] = (CommitOptions)object;
        this.fireTableCellUpdated(n, n2);
    }

    private void createCommitOptions() {
        boolean bl = CvsModuleConfig.getDefault().getPreferences().getBoolean("excludeNewFiles", false);
        this.commitOptions = new CommitOptions[this.nodes.length];
        block4: for (int i = 0; i < this.nodes.length; ++i) {
            CvsFileNode cvsFileNode = this.nodes[i];
            if (CvsModuleConfig.getDefault().isExcludedFromCommit(cvsFileNode.getFile())) {
                this.commitOptions[i] = CommitOptions.EXCLUDE;
                continue;
            }
            switch (cvsFileNode.getInformation().getStatus()) {
                case 4: {
                    this.commitOptions[i] = bl ? CommitOptions.EXCLUDE : this.getDefaultCommitOptions(cvsFileNode.getFile());
                    continue block4;
                }
                case 256: 
                case 2048: {
                    this.commitOptions[i] = CommitOptions.COMMIT_REMOVE;
                    continue block4;
                }
                default: {
                    this.commitOptions[i] = CommitOptions.COMMIT;
                }
            }
        }
    }

    CommitSettings.CommitFile getCommitFile(int n) {
        return new CommitSettings.CommitFile(this.nodes[n], this.commitOptions[n]);
    }

    private CommitOptions getDefaultCommitOptions(File file) {
        KeywordSubstitutionOptions keywordSubstitutionOptions = CvsVersioningSystem.getInstance().getDefaultKeywordSubstitution(file);
        return keywordSubstitutionOptions == KeywordSubstitutionOptions.BINARY ? CommitOptions.ADD_BINARY : CommitOptions.ADD_TEXT;
    }
}

