/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.completion.HtmlCompletionProvider;
import org.netbeans.modules.html.editor.javadoc.HelpManager;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.xml.XMLUtil;

public class HtmlCompletionItem
implements CompletionItem {
    protected static final int DEFAULT_SORT_PRIORITY = 20;
    protected int substitutionOffset;
    protected String text;
    protected String helpId;
    protected boolean shift;

    public static HtmlCompletionItem createTag(String string, int n, String string2, boolean bl) {
        return new Tag(string, n, string2, bl);
    }

    public static HtmlCompletionItem createEndTag(String string, int n, String string2, int n2, EndTag.Type type) {
        return new EndTag(string, n, string2, n2, type);
    }

    public static HtmlCompletionItem createAutocompleteEndTag(String string, int n) {
        return new AutocompleteEndTag(string, n);
    }

    public static HtmlCompletionItem createBooleanAttribute(String string, int n, boolean bl, String string2) {
        return new BooleanAttribute(string, n, bl, string2);
    }

    public static HtmlCompletionItem createAttribute(String string, int n, boolean bl, String string2) {
        return new Attribute(string, n, bl, string2);
    }

    public static HtmlCompletionItem createAttributeValue(String string, int n, boolean bl) {
        return new AttributeValue(string, n, bl);
    }

    public static HtmlCompletionItem createAttributeValue(String string, int n) {
        return HtmlCompletionItem.createAttributeValue(string, n, false);
    }

    public static HtmlCompletionItem createCharacterReference(String string, char c, int n, String string2) {
        return new CharRefItem(string, c, n, string2);
    }

    public static HtmlCompletionItem createFileCompletionItem(String string, int n, Color color, ImageIcon imageIcon) {
        return new FileAttributeValue(string, n, color, imageIcon);
    }

    public static HtmlCompletionItem createGoUpFileCompletionItem(int n, Color color, ImageIcon imageIcon) {
        return new GoUpFileAttributeValue(n, color, imageIcon);
    }

    protected HtmlCompletionItem(String string, int n) {
        this.substitutionOffset = n;
        this.text = string;
    }

    protected HtmlCompletionItem(String string, int n, String string2) {
        this(string, n);
        this.helpId = string2;
    }

    public String getItemText() {
        return this.text;
    }

    public int getSortPriority() {
        return 20;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.shift = keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401 && keyEvent.isShiftDown();
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (!this.shift) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, n - this.substitutionOffset);
        }
    }

    protected int getMoveBackLength() {
        return 0;
    }

    protected String getSubstituteText() {
        return this.getItemText();
    }

    protected boolean substituteText(JTextComponent jTextComponent, int n) {
        return this.substituteText(jTextComponent, n, this.getMoveBackLength());
    }

    protected boolean substituteText(JTextComponent jTextComponent, int n, int n2) {
        return this.substituteText(jTextComponent, this.getSubstituteText(), n, n2);
    }

    protected boolean substituteText(final JTextComponent jTextComponent, final String string, final int n, int n2) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        final boolean[] blArray = new boolean[]{true};
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                try {
                    String string2 = baseDocument.getText(HtmlCompletionItem.this.substitutionOffset, baseDocument.getLength() - HtmlCompletionItem.this.substitutionOffset < string.length() ? baseDocument.getLength() - HtmlCompletionItem.this.substitutionOffset : string.length());
                    if (!string.equals(string2)) {
                        baseDocument.remove(HtmlCompletionItem.this.substitutionOffset, n);
                        baseDocument.insertString(HtmlCompletionItem.this.substitutionOffset, string, null);
                    } else {
                        jTextComponent.setCaretPosition(jTextComponent.getCaret().getDot() + string.length() - n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    blArray[0] = false;
                }
            }
        });
        this.reindent(jTextComponent);
        if (n2 != 0) {
            Caret caret = jTextComponent.getCaret();
            int n3 = caret.getDot();
            caret.setDot(n3 - n2);
        }
        return blArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(JTextComponent jTextComponent) {
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        final int n = jTextComponent.getCaretPosition();
        final Indent indent = Indent.get((Document)baseDocument);
        indent.lock();
        try {
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                        indent.reindent(n3, n2);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            try {
                int n = jTextComponent.getSelectionEnd();
                if (n > this.substitutionOffset) {
                    String string = jTextComponent.getDocument().getText(this.substitutionOffset, n - this.substitutionOffset);
                    if (!this.getSubstituteText().toString().startsWith(string)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(jTextComponent);
        return true;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return this.getItemText();
    }

    protected String getRightHtmlText() {
        return null;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public URL getHelpURL() {
        if (this.helpId == null || this.helpId.equals("")) {
            return null;
        }
        try {
            return new URL(this.helpId);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getHelp() {
        return HelpManager.getDefault().getHelp(this.helpId);
    }

    public boolean hasHelp() {
        return this.helpId != null && this.helpId.length() > 0;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new HtmlCompletionProvider.DocQuery(this));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public static final String hexColorCode(Color color) {
        return Integer.toHexString(color.getRGB()).substring(2);
    }

    private static String escape(String string) {
        if (string != null) {
            try {
                return XMLUtil.toAttributeValue((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static class GoUpFileAttributeValue
    extends FileAttributeValue {
        GoUpFileAttributeValue(int n, Color color, ImageIcon imageIcon) {
            super("../", n, color, imageIcon);
        }

        public int getSortPriority() {
            return super.getSortPriority() - 1;
        }
    }

    public static class FileAttributeValue
    extends HtmlCompletionItem {
        private ImageIcon icon;
        private Color color;

        FileAttributeValue(String string, int n, Color color, ImageIcon imageIcon) {
            super(string, n);
            this.color = color;
            this.icon = imageIcon;
        }

        protected ImageIcon getIcon() {
            return this.icon;
        }

        protected String getLeftHtmlText() {
            return "<font color='" + FileAttributeValue.hexColorCode(this.color) + "'>" + this.getItemText() + "</font>";
        }
    }

    public static class BooleanAttribute
    extends HtmlCompletionItem {
        private boolean required;
        protected static final String ATTR_NAME_COLOR = BooleanAttribute.hexColorCode(Color.green.darker());

        public BooleanAttribute(String string, int n, boolean bl, String string2) {
            super(string, n, string2);
            this.required = bl;
        }

        protected String getLeftHtmlText() {
            return (this.required ? "<b>" : "") + "<font color=#" + ATTR_NAME_COLOR + ">" + this.getItemText() + "</font>" + (this.required ? "</b>" : "");
        }
    }

    public static class Attribute
    extends HtmlCompletionItem {
        private boolean required;
        protected static final String ATTR_NAME_COLOR = Attribute.hexColorCode(Color.green.darker());

        public Attribute(String string, int n, boolean bl, String string2) {
            super(string, n, string2);
            this.required = bl;
        }

        protected String getSubstituteText() {
            return this.getItemText() + "=\"\"";
        }

        protected int getMoveBackLength() {
            return 1;
        }

        public int getSortPriority() {
            return super.getSortPriority() - (this.required ? 1 : 0);
        }

        protected String getLeftHtmlText() {
            return (this.required ? "<b>" : "") + "<font color=#" + ATTR_NAME_COLOR + ">" + this.getItemText() + "</font>" + (this.required ? "</b>" : "");
        }
    }

    public static class AttributeValue
    extends HtmlCompletionItem {
        private boolean addQuotation;

        public AttributeValue(String string, int n, boolean bl) {
            super(string, n);
            this.addQuotation = bl;
        }

        protected String getSubstituteText() {
            return this.addQuotation ? "\"" + super.getSubstituteText() + "\"" : super.getSubstituteText();
        }
    }

    public static class CharRefItem
    extends HtmlCompletionItem {
        private char value;

        CharRefItem(String string, char c, int n, String string2) {
            super(string, n, string2);
            this.value = c;
        }

        protected String getSubstituteText() {
            return "&" + this.getItemText() + ";";
        }

        protected String getLeftHtmlText() {
            return "<b>&amp;" + HtmlCompletionItem.escape(this.getItemText()) + ";</b>";
        }

        protected String getRightHtmlText() {
            String string = this.value == '>' ? "&gt;" : (this.value == '<' ? "&lt;" : Character.toString(this.value));
            return "<b><font color=#990000>" + string + "</font></b>";
        }
    }

    public static class AutocompleteEndTag
    extends EndTag {
        public AutocompleteEndTag(String string, int n) {
            super(string, n, null, -1, EndTag.Type.DEFAULT);
        }

        protected int getMoveBackLength() {
            return this.getSubstituteText().length();
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }
    }

    public static class EndTag
    extends HtmlCompletionItem {
        private int orderIndex;
        private Type type;

        EndTag(String string, int n, String string2, int n2, Type type) {
            super(string, n, string2);
            this.orderIndex = n2;
            this.type = type;
        }

        public CharSequence getSortText() {
            if (this.orderIndex == -1) {
                return super.getSortText();
            }
            int n = this.orderIndex > 100 ? 0 : (this.orderIndex > 10 ? 1 : 2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append("" + this.orderIndex);
            return stringBuffer;
        }

        protected String getSubstituteText() {
            return "</" + this.getItemText() + ">";
        }

        public int getSortPriority() {
            return this.type.sortPriority;
        }

        protected String getLeftHtmlText() {
            return (this.type.bold ? "<b>" : "") + "<font color=#" + this.type.colorCode + ">&lt;/" + this.getItemText() + "&gt;</font>" + (this.type.bold ? "</b>" : "");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            DEFAULT(HtmlCompletionItem.hexColorCode(Color.BLUE), false, 20),
            OPTIONAL_EXISTING(HtmlCompletionItem.hexColorCode(Color.GRAY), false, 20),
            OPTIONAL_MISSING(HtmlCompletionItem.hexColorCode(Color.BLUE), false, 10),
            REQUIRED_EXISTING(HtmlCompletionItem.hexColorCode(Color.GRAY), false, 20),
            REQUIRED_MISSING(HtmlCompletionItem.hexColorCode(Color.BLUE), false, 10);

            private String colorCode;
            private boolean bold;
            private int sortPriority;

            private Type(String string2, boolean bl, int n2) {
                this.colorCode = string2;
                this.bold = bl;
                this.sortPriority = n2;
            }
        }
    }

    public static class Tag
    extends HtmlCompletionItem {
        private String GRAY_COLOR_CODE = Tag.hexColorCode(Color.GRAY);
        private boolean possible;

        protected Tag(String string, int n, String string2, boolean bl) {
            super(string, n, string2);
            this.possible = bl;
        }

        public void defaultAction(JTextComponent jTextComponent) {
            super.defaultAction(jTextComponent);
        }

        protected String getSubstituteText() {
            return "<" + this.getItemText();
        }

        public int getSortPriority() {
            return super.getSortPriority() + (this.possible ? -10 : 0);
        }

        protected String getLeftHtmlText() {
            return this.possible ? "<font color=#0000ff>&lt;" + this.getItemText() + "&gt;</font>" : "<font color=#" + this.GRAY_COLOR_CODE + ">&lt;" + this.getItemText() + "&gt;</font>";
        }
    }
}

