/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.ext.html.dtd.spi.ReaderProvider;
import org.netbeans.modules.html.editor.HtmlVersion;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class NbReaderProvider
implements ReaderProvider {
    private static final String CATALOG_FILE_NAME = "catalog";
    private Map<String, String> mapping = new HashMap<String, String>();
    private FileObject dtdSetFolder;

    @Deprecated
    public static synchronized void setupReaders() {
        Logger.global.log(Level.INFO, "Please remove the call to NbReaderProvider.setupReaders(), it is not necessary anymore.", new Exception());
    }

    public NbReaderProvider(FileObject fileObject) {
        this.dtdSetFolder = fileObject;
        this.initialize();
    }

    public Collection getIdentifiers() {
        return this.mapping.keySet();
    }

    public Reader getReaderForIdentifier(String string, String string2) {
        String string3 = this.mapping.get(string);
        if (string3 == null) {
            return null;
        }
        if (this.dtdSetFolder == null) {
            return null;
        }
        FileObject fileObject = this.dtdSetFolder.getFileObject(string3);
        if (string3 == null) {
            return null;
        }
        try {
            return new InputStreamReader(fileObject.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public boolean isXMLContent(String string) {
        return HtmlVersion.findHtmlVersion(string).isXhtml();
    }

    private void initialize() {
        FileObject fileObject = this.dtdSetFolder.getFileObject(CATALOG_FILE_NAME);
        if (fileObject != null) {
            try {
                this.mapping.putAll(this.parseCatalog(new InputStreamReader(fileObject.getInputStream())));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
            }
        }
    }

    private Map parseCatalog(Reader reader) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        while (true) {
            String string;
            try {
                string = lineNumberReader.readLine();
            }
            catch (IOException iOException) {
                return null;
            }
            if (string == null) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens() || !"PUBLIC".equals(stringTokenizer.nextToken()) || !stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken("\"");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken("\"");
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken(" \t\n\r\f");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }
}

