/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.StatusProvider;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListBridge
extends FileTaskScanner {
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";

    public TaskListBridge() {
        super(NbBundle.getMessage(TaskListBridge.class, (String)"LBL_TaskList_DisplayName"), NbBundle.getMessage(TaskListBridge.class, (String)"LBL_TaskList_Desc"), null);
    }

    public List<? extends Task> scan(FileObject fileObject) {
        Project project;
        if ("text/x-maven-pom+xml".equals(fileObject.getMIMEType()) && "pom.xml".equals(fileObject.getNameExt()) && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && project.getLookup().lookup(NbMavenProject.class) != null) {
            ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject);
            POMModel pOMModel = POMModelFactory.getDefault().getModel(modelSource);
            pOMModel.setAutoSyncActive(false);
            List<ErrorDescription> list = StatusProvider.StatusProviderImpl.findHints(pOMModel, project);
            ArrayList<Task> arrayList = new ArrayList<Task>();
            for (ErrorDescription errorDescription : list) {
                try {
                    Task task = Task.create((FileObject)fileObject, (String)TaskListBridge.severityToTaskListString(errorDescription.getSeverity()), (String)errorDescription.getDescription(), (int)(errorDescription.getRange().getBegin().getLine() + 1));
                    arrayList.add(task);
                }
                catch (IOException iOException) {
                    Logger.getLogger(TaskListBridge.class.getName()).log(Level.INFO, "Error while converting errors to tasklist", iOException);
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void attach(FileTaskScanner.Callback callback) {
    }

    private static String severityToTaskListString(Severity severity) {
        if (severity == Severity.ERROR) {
            return TASKLIST_ERROR;
        }
        return TASKLIST_WARNING;
    }
}

