/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.maven.hints.pom.Pair;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixBase;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesManager {
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.maven.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "org-netbeans-modules-maven-hints";

    private RulesManager() {
    }

    public static TreeModel getHintsTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileObject fileObject = FileUtil.getConfigFile((String)RULES_FOLDER);
        List<Pair<POMErrorFixBase, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeTreeRules(list, fileObject, defaultMutableTreeNode);
        return defaultTreeModel;
    }

    private static List<Pair<POMErrorFixBase, FileObject>> readRules(FileObject fileObject) {
        LinkedList<Pair<POMErrorFixBase, FileObject>> linkedList = new LinkedList<Pair<POMErrorFixBase, FileObject>>();
        if (fileObject == null) {
            return linkedList;
        }
        LinkedList<FileObject> linkedList2 = new LinkedList<FileObject>();
        linkedList2.offer(fileObject);
        while (!linkedList2.isEmpty()) {
            FileObject fileObject2 = (FileObject)linkedList2.poll();
            if (fileObject2.isFolder()) {
                linkedList2.addAll(Arrays.asList(fileObject2.getChildren()));
                continue;
            }
            if (!fileObject2.isData()) continue;
            String string = fileObject2.getNameExt().toLowerCase();
            if (!fileObject2.canRead()) continue;
            POMErrorFixBase pOMErrorFixBase = null;
            if (string.endsWith(INSTANCE_EXT)) {
                pOMErrorFixBase = RulesManager.instantiateRule(fileObject2);
            }
            if (pOMErrorFixBase == null) continue;
            linkedList.add(new Pair<POMErrorFixBase, FileObject>(pOMErrorFixBase, fileObject2));
        }
        return linkedList;
    }

    private static void categorizeTreeRules(List<Pair<POMErrorFixBase, FileObject>> list, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<POMErrorFixBase, FileObject> pair : list) {
            FileObject fileObject2;
            DefaultMutableTreeNode defaultMutableTreeNode2;
            POMErrorFixBase pOMErrorFixBase = pair.getA();
            FileObject fileObject3 = pair.getB();
            Object object = fileObject3.getAttribute(NON_GUI);
            boolean bl = true;
            if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                bl = false;
            }
            if ((defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject2 = fileObject3.getParent())) == null) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                hashMap.put(fileObject2, defaultMutableTreeNode2);
            }
            if (!bl) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(pOMErrorFixBase, false));
        }
    }

    private static POMErrorFixBase instantiateRule(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            Object object = instanceCookie.instanceCreate();
            if (object instanceof POMErrorFixBase) {
                return (POMErrorFixBase)object;
            }
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, null, classNotFoundException);
        }
        return null;
    }
}

