/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing.support;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexFactory;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuerySupport {
    private static final Logger LOG = Logger.getLogger(QuerySupport.class.getName());
    private final String indexerIdentification;
    private final IndexFactoryImpl spiFactory;
    private final Map<URL, IndexImpl> indexes;

    public static Collection<FileObject> findRoots(FileObject fileObject, Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        if (collection == null) {
            collection = PathRecognizerRegistry.getDefault().getSourceIds();
        }
        if (collection2 == null) {
            collection2 = PathRecognizerRegistry.getDefault().getLibraryIds();
        }
        if (collection3 == null) {
            collection3 = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
        }
        QuerySupport.collectClasspathRoots(fileObject, collection, false, hashSet);
        QuerySupport.collectClasspathRoots(fileObject, collection2, false, hashSet);
        QuerySupport.collectClasspathRoots(fileObject, collection3, true, hashSet);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Roots for file " + fileObject + ", sourcePathIds=" + collection + ", libraryPathIds=" + collection2 + ", binaryPathIds=" + collection3 + ": ");
            for (FileObject fileObject2 : hashSet) {
                try {
                    LOG.fine("  " + fileObject2.getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {}
            }
            LOG.fine("----");
        }
        return hashSet != null ? hashSet : Collections.emptySet();
    }

    public static Collection<FileObject> findRoots(Project project, Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        HashSet<Object> hashSet = new HashSet<FileObject>();
        if (collection == null) {
            collection = PathRecognizerRegistry.getDefault().getSourceIds();
        }
        if (collection2 == null) {
            collection2 = PathRecognizerRegistry.getDefault().getLibraryIds();
        }
        if (collection3 == null) {
            collection3 = PathRecognizerRegistry.getDefault().getBinaryLibraryIds();
        }
        QuerySupport.collectClasspathRoots(null, collection, false, hashSet);
        QuerySupport.collectClasspathRoots(null, collection2, false, hashSet);
        QuerySupport.collectClasspathRoots(null, collection3, true, hashSet);
        if (project != null) {
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
            for (FileObject fileObject : hashSet) {
                if (FileOwnerQuery.getOwner((FileObject)fileObject) != project) continue;
                hashSet2.add(fileObject);
            }
            hashSet = hashSet2;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Roots for project " + project + ", sourcePathIds=" + collection + ", libraryPathIds=" + collection2 + ", binaryPathIds=" + collection3 + ": ");
            for (FileObject fileObject : hashSet) {
                try {
                    LOG.fine("  " + fileObject.getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {}
            }
            LOG.fine("----");
        }
        return hashSet;
    }

    public static QuerySupport forRoots(String string, int n, URL ... uRLArray) throws IOException {
        Parameters.notNull((CharSequence)"indexerName", (Object)string);
        Parameters.notNull((CharSequence)"roots", (Object)uRLArray);
        return new QuerySupport(string, n, uRLArray);
    }

    public static QuerySupport forRoots(String string, int n, FileObject ... fileObjectArray) throws IOException {
        Parameters.notNull((CharSequence)"indexerName", (Object)string);
        Parameters.notNull((CharSequence)"roots", (Object)fileObjectArray);
        ArrayList<URL> arrayList = new ArrayList<URL>(fileObjectArray.length);
        for (FileObject fileObject : fileObjectArray) {
            arrayList.add(fileObject.getURL());
        }
        return new QuerySupport(string, n, arrayList.toArray(new URL[arrayList.size()]));
    }

    public Collection<? extends IndexResult> query(String string, String string2, Kind kind, String ... stringArray) throws IOException {
        Collection<Object> collection;
        URL uRL;
        Object object;
        Parameters.notNull((CharSequence)"fieldName", (Object)string);
        Parameters.notNull((CharSequence)"fieldValue", (Object)string2);
        Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
        for (Map.Entry<URL, IndexImpl> object2 : this.indexes.entrySet()) {
            IndexImpl indexImpl = object2.getValue();
            object = indexImpl.getStaleFiles();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Index: " + indexImpl + ", staleFiles: " + object);
            }
            if (object == null || object.size() <= 0) continue;
            uRL = object2.getKey();
            collection = new LinkedList();
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object3 = (String)iterator.next();
                try {
                    ((LinkedList)collection).add(Util.resolveUrl(uRL, (String)object3));
                }
                catch (MalformedURLException malformedURLException) {
                    LOG.log(Level.WARNING, null, malformedURLException);
                }
            }
            IndexingManager.getDefault().refreshIndexAndWait(uRL, collection);
        }
        LinkedList linkedList = new LinkedList();
        for (Map.Entry<URL, IndexImpl> entry : this.indexes.entrySet()) {
            object = entry.getValue();
            uRL = entry.getKey();
            collection = object.query(string, string2, kind, stringArray);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("query(\"" + string + "\", \"" + string2 + "\", " + (Object)((Object)kind) + ", " + QuerySupport.printFiledToLoad(stringArray) + ") for " + this.indexerIdentification + ":");
                for (Object object3 : collection) {
                    LOG.fine(" " + object3);
                }
                LOG.fine("----");
            }
            for (Object object3 : collection) {
                linkedList.add(new IndexResult((IndexDocumentImpl)object3, uRL));
            }
        }
        return linkedList;
    }

    private QuerySupport(String string, int n, URL ... uRLArray) throws IOException {
        this.indexerIdentification = string + "/" + n;
        this.spiFactory = new LuceneIndexFactory();
        this.indexes = new LinkedHashMap<URL, IndexImpl>();
        String string2 = QuerySupport.findIndexerFolder(string, n);
        if (string2 != null) {
            for (URL uRL : uRLArray) {
                IndexImpl indexImpl;
                FileObject fileObject = CacheFolder.getDataFolder(uRL);
                assert (fileObject != null);
                FileObject fileObject2 = fileObject.getFileObject(string2);
                if (fileObject2 == null || (indexImpl = this.spiFactory.getIndex(fileObject2)) == null) continue;
                this.indexes.put(uRL, indexImpl);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("QuerySupport for " + this.indexerIdentification + ":");
            for (URL uRL : this.indexes.keySet()) {
                LOG.fine(" " + uRL + " -> index: " + this.indexes.get(uRL));
            }
            LOG.fine("----");
        }
    }

    private QuerySupport(FileObject fileObject, String string, int n) throws IOException {
        this.indexerIdentification = string + "/" + n;
        this.spiFactory = new LuceneIndexFactory();
        this.indexes = new HashMap<URL, IndexImpl>();
        FileObject fileObject2 = CacheFolder.getDataFolder(fileObject.getURL());
        FileObject fileObject3 = fileObject2.getFileObject(SPIAccessor.getInstance().getIndexerPath(string, n));
        fileObject3.getClass();
        this.indexes.put(fileObject.getURL(), this.spiFactory.getIndex(fileObject3));
    }

    private static void collectClasspathRoots(FileObject fileObject, Collection<String> collection, boolean bl, Collection<FileObject> collection2) {
        for (String string : collection) {
            Collection<FileObject> collection3 = QuerySupport.getClasspathRoots(fileObject, string);
            if (bl) {
                for (FileObject fileObject2 : collection3) {
                    URL uRL;
                    try {
                        uRL = fileObject2.getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        continue;
                    }
                    URL[] uRLArray = PathRegistry.getDefault().sourceForBinaryQuery(uRL, null, false);
                    if (uRLArray != null) {
                        LOG.log(Level.FINE, "Translating {0} -> {1}", new Object[]{uRL, uRLArray});
                        for (URL uRL2 : uRLArray) {
                            FileObject fileObject3 = URLMapper.findFileObject((URL)uRL2);
                            if (fileObject3 == null) continue;
                            collection2.add(fileObject3);
                        }
                        continue;
                    }
                    LOG.log(Level.FINE, "No sources for {0}, adding bin root", uRL);
                    collection2.add(fileObject2);
                }
                continue;
            }
            collection2.addAll(collection3);
        }
    }

    private static Collection<FileObject> getClasspathRoots(FileObject fileObject, String string) {
        Collection<FileObject> collection = Collections.emptySet();
        if (fileObject != null) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)string);
            if (classPath != null) {
                collection = Arrays.asList(classPath.getRoots());
            }
        } else {
            collection = new HashSet();
            Set<URL> set = PathRegistry.getDefault().getRootsMarkedAs(string);
            for (URL uRL : set) {
                FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
                if (fileObject2 == null) continue;
                collection.add(fileObject2);
            }
        }
        return collection;
    }

    private static String findIndexerFolder(String string, int n) {
        return SPIAccessor.getInstance().getIndexerPath(string, n);
    }

    private static String printFiledToLoad(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "<all-fields>";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("\"").append(stringArray[i]).append("\"");
            if (i + 1 >= stringArray.length) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        EXACT,
        PREFIX,
        CASE_INSENSITIVE_PREFIX,
        CAMEL_CASE,
        REGEXP,
        CASE_INSENSITIVE_REGEXP,
        CASE_INSENSITIVE_CAMEL_CASE;

    }
}

