/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing;

import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;

public final class Indexable {
    private IndexableImpl delegate;

    Indexable(IndexableImpl indexableImpl) {
        assert (indexableImpl != null);
        this.delegate = indexableImpl;
    }

    public String getRelativePath() {
        return this.delegate.getRelativePath();
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public String getMimeType() {
        return this.delegate.getMimeType();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Indexable indexable = (Indexable)object;
        return this.delegate.equals(indexable.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    static {
        SPIAccessor.setInstance(new MyAccessor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyAccessor
    extends SPIAccessor {
        private MyAccessor() {
        }

        @Override
        public Indexable create(IndexableImpl indexableImpl) {
            return new Indexable(indexableImpl);
        }

        @Override
        public void index(BinaryIndexer binaryIndexer, Context context) {
            assert (binaryIndexer != null);
            assert (context != null);
            binaryIndexer.index(context);
        }

        @Override
        public void index(CustomIndexer customIndexer, Iterable<? extends Indexable> iterable, Context context) {
            assert (customIndexer != null);
            assert (iterable != null);
            assert (context != null);
            customIndexer.index(iterable, context);
        }

        @Override
        public Context createContext(FileObject fileObject, URL uRL, String string, int n, IndexFactoryImpl indexFactoryImpl, boolean bl, boolean bl2, boolean bl3, CancelRequest cancelRequest) throws IOException {
            return new Context(fileObject, uRL, string, n, indexFactoryImpl, bl, bl2, bl3, cancelRequest);
        }

        @Override
        public String getIndexerName(Context context) {
            assert (context != null);
            return context.getIndexerName();
        }

        @Override
        public int getIndexerVersion(Context context) {
            assert (context != null);
            return context.getIndexerVersion();
        }

        @Override
        public void index(EmbeddingIndexer embeddingIndexer, Indexable indexable, Parser.Result result, Context context) {
            assert (embeddingIndexer != null);
            assert (indexable != null);
            assert (result != null);
            assert (context != null);
            embeddingIndexer.index(indexable, result, context);
        }

        @Override
        public String getIndexerPath(String string, int n) {
            assert (string != null);
            return Context.getIndexerPath(string, n);
        }

        @Override
        public IndexFactoryImpl getIndexFactory(Context context) {
            assert (context != null);
            return context.getIndexFactory();
        }

        @Override
        public void context_attachIndexingSupport(Context context, IndexingSupport indexingSupport) {
            context.attachIndexingSupport(indexingSupport);
        }

        @Override
        public IndexingSupport context_getAttachedIndexingSupport(Context context) {
            return context.getAttachedIndexingSupport();
        }

        @Override
        public void context_clearAttachedIndexingSupport(Context context) {
            context.clearAttachedIndexingSupport();
        }

        @Override
        public void setAllFilesJob(Context context, boolean bl) {
            context.setAllFilesJob(bl);
        }
    }
}

