/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalCache;
import org.jruby.util.ByteList;

public class UnmarshalStream
extends InputStream {
    protected final Ruby runtime;
    private final UnmarshalCache cache;
    private final IRubyObject proc;
    private final InputStream inputStream;
    boolean ivarsWaiting = false;

    public UnmarshalStream(Ruby runtime2, InputStream in, IRubyObject proc2) throws IOException {
        this.runtime = runtime2;
        this.cache = new UnmarshalCache(runtime2);
        this.proc = proc2;
        this.inputStream = in;
        int major = in.read();
        int minor = in.read();
        if (major == -1 || minor == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        if (major != 4 || minor > 8) {
            throw runtime2.newTypeError(String.format("incompatible marshal file format (can't be read)\n\tformat version %d.%d required; %d.%d given", 4, 8, major, minor));
        }
    }

    public IRubyObject unmarshalObject() throws IOException {
        int type2 = this.readUnsignedByte();
        IRubyObject result = this.cache.isLinkType(type2) ? this.cache.readLink(this, type2) : this.unmarshalObjectDirectly(type2);
        return result;
    }

    public void registerLinkTarget(IRubyObject newObject) {
        if (MarshalStream.shouldBeRegistered(newObject)) {
            this.cache.register(newObject);
        }
    }

    public static RubyModule getModuleFromPath(Ruby runtime2, String path2) {
        RubyModule value2 = runtime2.getClassFromPath(path2);
        if (!value2.isModule()) {
            throw runtime2.newArgumentError(path2 + " does not refer module");
        }
        return value2;
    }

    public static RubyClass getClassFromPath(Ruby runtime2, String path2) {
        RubyModule value2 = runtime2.getClassFromPath(path2);
        if (!value2.isClass()) {
            throw runtime2.newArgumentError(path2 + " does not refer class");
        }
        return (RubyClass)value2;
    }

    private IRubyObject unmarshalObjectDirectly(int type2) throws IOException {
        IRubyObject rubyObj = null;
        switch (type2) {
            case 73: {
                this.ivarsWaiting = true;
                rubyObj = this.unmarshalObject();
                if (!this.ivarsWaiting) break;
                this.defaultVariablesUnmarshal(rubyObj);
                this.ivarsWaiting = false;
                break;
            }
            case 48: {
                rubyObj = this.runtime.getNil();
                break;
            }
            case 84: {
                rubyObj = this.runtime.getTrue();
                break;
            }
            case 70: {
                rubyObj = this.runtime.getFalse();
                break;
            }
            case 34: {
                rubyObj = RubyString.unmarshalFrom(this);
                break;
            }
            case 105: {
                rubyObj = RubyFixnum.unmarshalFrom(this);
                break;
            }
            case 102: {
                rubyObj = RubyFloat.unmarshalFrom(this);
                break;
            }
            case 47: {
                rubyObj = RubyRegexp.unmarshalFrom(this);
                break;
            }
            case 58: {
                rubyObj = RubySymbol.unmarshalFrom(this);
                break;
            }
            case 91: {
                rubyObj = RubyArray.unmarshalFrom(this);
                break;
            }
            case 123: {
                rubyObj = RubyHash.unmarshalFrom(this, false);
                break;
            }
            case 125: {
                rubyObj = RubyHash.unmarshalFrom(this, true);
                break;
            }
            case 99: {
                rubyObj = RubyClass.unmarshalFrom(this);
                break;
            }
            case 109: {
                rubyObj = RubyModule.unmarshalFrom(this);
                break;
            }
            case 101: {
                RubySymbol moduleName = (RubySymbol)this.unmarshalObject();
                RubyModule tp = null;
                try {
                    tp = this.runtime.getClassFromPath(moduleName.asJavaString());
                }
                catch (RaiseException e) {
                    if (this.runtime.fastGetModule("NameError").isInstance(e.getException())) {
                        throw this.runtime.newArgumentError("undefined class/module " + moduleName.asJavaString());
                    }
                    throw e;
                }
                rubyObj = this.unmarshalObject();
                tp.extend_object(rubyObj);
                tp.callMethod(this.runtime.getCurrentContext(), "extended", rubyObj);
                break;
            }
            case 108: {
                rubyObj = RubyBignum.unmarshalFrom(this);
                break;
            }
            case 83: {
                rubyObj = RubyStruct.unmarshalFrom(this);
                break;
            }
            case 111: {
                rubyObj = this.defaultObjectUnmarshal();
                break;
            }
            case 117: {
                rubyObj = this.userUnmarshal();
                break;
            }
            case 85: {
                rubyObj = this.userNewUnmarshal();
                break;
            }
            case 67: {
                rubyObj = this.uclassUnmarshall();
                break;
            }
            default: {
                throw this.getRuntime().newArgumentError("dump format error(" + (char)type2 + ")");
            }
        }
        if (this.proc != null && type2 != 58) {
            RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this.proc, "call", rubyObj);
        }
        return rubyObj;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public int readUnsignedByte() throws IOException {
        int result = this.read();
        if (result == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        return result;
    }

    public byte readSignedByte() throws IOException {
        int b = this.readUnsignedByte();
        if (b > 127) {
            return (byte)(b - 256);
        }
        return (byte)b;
    }

    public ByteList unmarshalString() throws IOException {
        int read2;
        int length2 = this.unmarshalInt();
        byte[] buffer = new byte[length2];
        for (int readLength = 0; readLength < length2; readLength += read2) {
            read2 = this.inputStream.read(buffer, readLength, length2 - readLength);
            if (read2 != -1) continue;
            throw this.getRuntime().newArgumentError("marshal data too short");
        }
        return new ByteList(buffer, false);
    }

    public int unmarshalInt() throws IOException {
        long result;
        int c = this.readSignedByte();
        if (c == 0) {
            return 0;
        }
        if (5 < c && c < 128) {
            return c - 5;
        }
        if (-129 < c && c < -5) {
            return c + 5;
        }
        if (c > 0) {
            result = 0L;
            for (int i = 0; i < c; ++i) {
                result |= (long)this.readUnsignedByte() << 8 * i;
            }
        } else {
            c = -c;
            result = -1L;
            for (int i = 0; i < c; ++i) {
                result &= 255L << 8 * i ^ 0xFFFFFFFFFFFFFFFFL;
                result |= (long)this.readUnsignedByte() << 8 * i;
            }
        }
        return (int)result;
    }

    private IRubyObject defaultObjectUnmarshal() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject();
        RubyClass type2 = null;
        try {
            type2 = UnmarshalStream.getClassFromPath(this.runtime, className.toString());
        }
        catch (RaiseException e) {
            if (this.runtime.fastGetModule("NameError").isInstance(e.getException())) {
                throw this.runtime.newArgumentError("undefined class/module " + className.asJavaString());
            }
            throw e;
        }
        assert (type2 != null) : "type shouldn't be null.";
        IRubyObject result = (IRubyObject)type2.unmarshal(this);
        return result;
    }

    public void defaultVariablesUnmarshal(IRubyObject object) throws IOException {
        int count2 = this.unmarshalInt();
        ArrayList<Variable<Object>> attrs = new ArrayList<Variable<Object>>(count2);
        int i = count2;
        while (--i >= 0) {
            String name2 = this.unmarshalObject().asJavaString();
            IRubyObject value2 = this.unmarshalObject();
            attrs.add(new VariableEntry<IRubyObject>(name2, value2));
        }
        object.syncVariables(attrs);
    }

    private IRubyObject uclassUnmarshall() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject();
        RubyClass type2 = (RubyClass)this.runtime.getClassFromPath(className.asJavaString());
        RubyObject result = (RubyObject)this.unmarshalObject();
        result.setMetaClass(type2);
        return result;
    }

    private IRubyObject userUnmarshal() throws IOException {
        String className = this.unmarshalObject().asJavaString();
        ByteList marshaled = this.unmarshalString();
        RubyClass classInstance = this.findClass(className);
        if (!classInstance.respondsTo("_load")) {
            throw this.runtime.newTypeError("class " + classInstance.getName() + " needs to have method `_load'");
        }
        RubyString data = RubyString.newString(this.getRuntime(), marshaled);
        if (this.ivarsWaiting) {
            this.defaultVariablesUnmarshal(data);
            this.ivarsWaiting = false;
        }
        IRubyObject result = classInstance.callMethod(this.getRuntime().getCurrentContext(), "_load", (IRubyObject)data);
        this.registerLinkTarget(result);
        return result;
    }

    private IRubyObject userNewUnmarshal() throws IOException {
        String className = this.unmarshalObject().asJavaString();
        RubyClass classInstance = this.findClass(className);
        IRubyObject result = classInstance.allocate();
        this.registerLinkTarget(result);
        IRubyObject marshaled = this.unmarshalObject();
        result.callMethod(this.getRuntime().getCurrentContext(), "marshal_load", marshaled);
        return result;
    }

    private RubyClass findClass(String className) {
        RubyModule classInstance;
        try {
            classInstance = this.runtime.getClassFromPath(className);
        }
        catch (RaiseException e) {
            if (this.runtime.getModule("NameError").isInstance(e.getException())) {
                throw this.runtime.newArgumentError("undefined class/module " + className);
            }
            throw e;
        }
        if (!(classInstance instanceof RubyClass)) {
            throw this.runtime.newArgumentError(className + " does not refer class");
        }
        return (RubyClass)classInstance;
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }
}

