/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.UTimBuf64;
import org.jruby.ext.posix.WindowsFileStat;
import org.jruby.ext.posix.WindowsLibC;

public class WindowsPOSIX
extends BaseNativePOSIX {
    JavaLibCHelper helper;

    public WindowsPOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
        this.helper = new JavaLibCHelper(handler);
    }

    public FileStat allocateStat() {
        return new WindowsFileStat(this);
    }

    public int kill(int pid2, int signal2) {
        this.handler.unimplementedError("kill");
        return -1;
    }

    public int chown(String filename2, int user, int group2) {
        return 0;
    }

    public int getegid() {
        this.handler.unimplementedError("egid");
        return -1;
    }

    public int setegid(int egid2) {
        this.handler.unimplementedError("setegid");
        return -1;
    }

    public int geteuid() {
        return 0;
    }

    public int seteuid(int euid2) {
        this.handler.unimplementedError("seteuid");
        return -1;
    }

    public int getuid() {
        return 0;
    }

    public int setuid(int uid2) {
        this.handler.unimplementedError("setuid");
        return -1;
    }

    public int getgid() {
        this.handler.unimplementedError("getgid");
        return -1;
    }

    public int setgid(int gid2) {
        this.handler.unimplementedError("setgid");
        return -1;
    }

    public int getpgid(int pid2) {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int getpgid() {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int setpgid(int pid2, int pgid) {
        this.handler.unimplementedError("setpgid");
        return -1;
    }

    public int getpriority(int which, int who) {
        this.handler.unimplementedError("getpriority");
        return -1;
    }

    public int setpriority(int which, int who, int prio) {
        this.handler.unimplementedError("setpriority");
        return -1;
    }

    public int getppid() {
        return 0;
    }

    public int lchmod(String filename2, int mode2) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public int lchown(String filename2, int user, int group2) {
        this.handler.unimplementedError("lchown");
        return -1;
    }

    public FileStat lstat(String path2) {
        return this.stat(path2);
    }

    public String readlink(String oldpath) {
        this.handler.unimplementedError("readlink");
        return null;
    }

    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        UTimBuf64 times2 = null;
        if (atimeval != null && mtimeval != null) {
            times2 = new UTimBuf64(atimeval[0], mtimeval[0]);
        }
        return ((WindowsLibC)this.libc)._utime64(path2, times2);
    }

    public int wait(int[] status2) {
        this.handler.unimplementedError("wait");
        return -1;
    }

    public int waitpid(int pid2, int[] status2, int flags) {
        this.handler.unimplementedError("waitpid");
        return -1;
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int endgrent() {
        return 0;
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public Group getgrent() {
        return null;
    }

    public Passwd getpwent() {
        return null;
    }

    public Group getgrgid(int which) {
        return null;
    }

    public Passwd getpwnam(String which) {
        return null;
    }

    public Group getgrnam(String which) {
        return null;
    }

    public int setgrent() {
        return 0;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public Passwd getpwuid(int which) {
        return null;
    }

    public boolean isatty(FileDescriptor fd) {
        int handle = (int)this.helper.gethandle(fd);
        int crtfd = ((WindowsLibC)this.libc)._open_osfhandle(handle, 0);
        return this.libc.isatty(crtfd) != 0;
    }
}

