/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EvalFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedEvalUnitImpl
implements EmbedEvalUnit {
    private ScriptingContainer container;
    private Node node;
    private ManyVarsDynamicScope scope;
    private Script script;

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope) {
        this(container, node, scope, null);
    }

    public EmbedEvalUnitImpl(ScriptingContainer container, Node node, ManyVarsDynamicScope scope, Script script) {
        this.container = container;
        this.node = node;
        this.scope = scope;
        this.script = script;
    }

    public Node getNode() {
        return this.node;
    }

    public ManyVarsDynamicScope getScope() {
        return this.scope;
    }

    public IRubyObject run() {
        if (this.node == null && this.script == null) {
            return null;
        }
        BiVariableMap vars = this.container.getVarMap();
        try {
            vars.inject(this.scope, 0, null);
            this.container.getRuntime().getCurrentContext().pushScope(this.scope);
            RubyInstanceConfig.CompileMode mode2 = this.container.getRuntime().getInstanceConfig().getCompileMode();
            IRubyObject ret = mode2 == RubyInstanceConfig.CompileMode.FORCE || mode2 == RubyInstanceConfig.CompileMode.JIT ? this.container.getRuntime().runScript(this.script) : this.container.getRuntime().runInterpreter(this.node);
            vars.retrieve(ret);
            IRubyObject iRubyObject = ret;
            return iRubyObject;
        }
        catch (RaiseException e) {
            this.container.getRuntime().printError(e.getException());
            throw new EvalFailedException(e.getMessage(), e);
        }
        catch (StackOverflowError soe) {
            throw this.container.getRuntime().newSystemStackError("stack level too deep", soe);
        }
        catch (Throwable e) {
            Writer w = this.container.getErrorWriter();
            if (w instanceof PrintWriter) {
                e.printStackTrace((PrintWriter)w);
            } else {
                try {
                    w.write(e.getMessage());
                }
                catch (IOException ex) {
                    throw new EvalFailedException(ex);
                }
            }
            throw new EvalFailedException(e);
        }
        finally {
            this.container.getRuntime().getCurrentContext().popScope();
            JavaEmbedUtils.terminate(this.container.getRuntime());
            vars.terminate();
        }
    }
}

