/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.operands.Attribute;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IR_Instr {
    public final Operation _op;
    public final Variable _result;
    private Attribute[] _attributes;
    private boolean _isDead;

    public IR_Instr(Operation op) {
        this._op = op;
        this._result = null;
    }

    public IR_Instr(Operation op, Variable res) {
        this._op = op;
        this._result = res;
        this._attributes = null;
        this._isDead = false;
    }

    public String toString() {
        return "\t" + (this.isDead() ? "[DEAD]" : "") + (this._result == null ? "" : this._result + " = ") + (Object)((Object)this._op);
    }

    public Variable getResult() {
        return this._result;
    }

    public boolean hasSideEffects() {
        return this._op.hasSideEffects();
    }

    public void markDead() {
        this._isDead = true;
    }

    public boolean isDead() {
        return this._isDead;
    }

    public abstract Operand[] getOperands();

    public List<Variable> getUsedVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Operand o : this.getOperands()) {
            o.addUsedVariables(vars);
        }
        return vars;
    }

    public abstract void simplifyOperands(Map<Operand, Operand> var1);

    public Operand simplifyAndGetResult(Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap);
        return null;
    }
}

