/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dynalang.mop.BaseMetaobjectProtocol;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.ClassBasedMetaobjectProtocol;
import org.dynalang.mop.MetaobjectProtocol;
import org.dynalang.mop.impl.CompositeUniqueEntryIterator;
import org.dynalang.mop.impl.CompositeUniqueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeClassBasedMetaobjectProtocol
implements ClassBasedMetaobjectProtocol,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ClassBasedMetaobjectProtocol[] NO_AUTHORITY = new ClassBasedMetaobjectProtocol[0];
    private final ClassBasedMetaobjectProtocol[] members;
    private final Map<Class, ClassBasedMetaobjectProtocol[]> fastDelegationOrders = new ConcurrentHashMap<Class, ClassBasedMetaobjectProtocol[]>();
    private final Map<ClassBasedMetaobjectProtocol, ClassBasedMetaobjectProtocol[]> delegationOrders = new IdentityHashMap<ClassBasedMetaobjectProtocol, ClassBasedMetaobjectProtocol[]>();

    public static MetaobjectProtocol[] optimize(MetaobjectProtocol[] mops) {
        LinkedList<MetaobjectProtocol> lmops = new LinkedList<MetaobjectProtocol>();
        LinkedList<ClassBasedMetaobjectProtocol> cbmops = new LinkedList<ClassBasedMetaobjectProtocol>();
        for (MetaobjectProtocol protocol : mops) {
            if (protocol instanceof ClassBasedMetaobjectProtocol) {
                cbmops.add((ClassBasedMetaobjectProtocol)protocol);
                continue;
            }
            CompositeClassBasedMetaobjectProtocol.addClassBased(lmops, cbmops);
            lmops.add(protocol);
        }
        CompositeClassBasedMetaobjectProtocol.addClassBased(lmops, cbmops);
        return lmops.toArray(new MetaobjectProtocol[lmops.size()]);
    }

    private static void addClassBased(List<MetaobjectProtocol> lmops, List<ClassBasedMetaobjectProtocol> cbmops) {
        switch (cbmops.size()) {
            case 0: {
                break;
            }
            case 1: {
                lmops.addAll(cbmops);
                lmops.clear();
                break;
            }
            default: {
                lmops.add(new CompositeClassBasedMetaobjectProtocol(cbmops.toArray(new ClassBasedMetaobjectProtocol[cbmops.size()])));
                cbmops.clear();
            }
        }
    }

    public CompositeClassBasedMetaobjectProtocol(ClassBasedMetaobjectProtocol[] members2) {
        this.members = (ClassBasedMetaobjectProtocol[])members2.clone();
        int l = members2.length;
        for (int i = 0; i < l; ++i) {
            ClassBasedMetaobjectProtocol cbmop;
            ClassBasedMetaobjectProtocol[] delegationOrder = new ClassBasedMetaobjectProtocol[l];
            delegationOrder[0] = cbmop = members2[i];
            if (i > 0) {
                System.arraycopy(members2, 0, delegationOrder, 1, i);
            }
            if (i < l - 1) {
                System.arraycopy(members2, i + 1, delegationOrder, i + 1, l - 1 - i);
            }
            this.delegationOrders.put(cbmop, delegationOrder);
        }
    }

    private ClassBasedMetaobjectProtocol[] getDelegationOrder(Object obj) {
        return obj == null ? this.members : this.getDelegationOrder(obj.getClass());
    }

    private ClassBasedMetaobjectProtocol[] getDelegationOrder(Class clazz) {
        ClassBasedMetaobjectProtocol[] order = this.fastDelegationOrders.get(clazz);
        if (order == null) {
            for (ClassBasedMetaobjectProtocol protocol : this.members) {
                if (!protocol.isAuthoritativeForClass(clazz)) continue;
                order = this.delegationOrders.get(protocol);
                break;
            }
            if (order == null) {
                order = NO_AUTHORITY;
            }
            this.fastDelegationOrders.put(clazz, order);
        }
        return order;
    }

    @Override
    public boolean isAuthoritativeForClass(Class clazz) {
        return this.getDelegationOrder(clazz).length != 0;
    }

    @Override
    public Object call(Object callable, CallProtocol callProtocol, Map args2) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(callable)) {
            Object res = mop.call(callable, callProtocol, args2);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public Object call(Object target, Object callableId, CallProtocol callProtocol, Map args2) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Object res = mop.call(target, callableId, callProtocol, args2);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public Object call(Object target, Object callableId, CallProtocol callProtocol, Object ... args2) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Object res = mop.call(target, callableId, callProtocol, args2);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public Object call(Object callable, CallProtocol callProtocol, Object ... args2) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(callable)) {
            Object res = mop.call(callable, callProtocol, args2);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public BaseMetaobjectProtocol.Results delete(Object target, long propertyId) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            BaseMetaobjectProtocol.Results res = mop.delete(target, propertyId);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public BaseMetaobjectProtocol.Results delete(Object target, Object propertyId) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            BaseMetaobjectProtocol.Results res = mop.delete(target, propertyId);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public Object get(Object target, long propertyId) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Object res = mop.get(target, propertyId);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public Object get(Object target, Object propertyId) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Object res = mop.get(target, propertyId);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public Boolean has(Object target, long propertyId) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Boolean has = mop.has(target, propertyId);
            if (has == null) continue;
            return has;
        }
        return null;
    }

    @Override
    public Boolean has(Object target, Object propertyId) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Boolean has = mop.has(target, propertyId);
            if (has == null) continue;
            return has;
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry> properties(Object target) {
        CompositeUniqueEntryIterator compositeIt = null;
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Iterator<Map.Entry> it = mop.properties(target);
            if (compositeIt == null) {
                compositeIt = it;
                continue;
            }
            if (compositeIt instanceof CompositeUniqueEntryIterator) {
                ((CompositeUniqueEntryIterator)compositeIt).add(it);
                continue;
            }
            compositeIt = new CompositeUniqueEntryIterator(compositeIt, (Iterator<? extends Map.Entry>)it);
        }
        return compositeIt == null ? Collections.EMPTY_MAP.entrySet().iterator() : compositeIt;
    }

    @Override
    public Iterator<? extends Object> propertyIds(Object target) {
        Iterator<Object> compositeIt = null;
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            Iterator<? extends Object> it = mop.propertyIds(target);
            assert (it != null) : mop.getClass().getName() + " returned null propertyIds iterator";
            if (compositeIt == null) {
                compositeIt = it;
                continue;
            }
            if (compositeIt instanceof CompositeUniqueIterator) {
                ((CompositeUniqueIterator)compositeIt).add(it);
                continue;
            }
            compositeIt = new CompositeUniqueIterator<Object>(compositeIt, it);
        }
        return compositeIt == null ? Collections.EMPTY_SET.iterator() : compositeIt;
    }

    @Override
    public BaseMetaobjectProtocol.Results put(Object target, long propertyId, Object value2, CallProtocol callProtocol) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            BaseMetaobjectProtocol.Results res = mop.put(target, propertyId, value2, callProtocol);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public BaseMetaobjectProtocol.Results put(Object target, Object propertyId, Object value2, CallProtocol callProtocol) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(target)) {
            BaseMetaobjectProtocol.Results res = mop.put(target, propertyId, value2, callProtocol);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }

    @Override
    public Object representAs(Object object, Class targetClass) {
        for (ClassBasedMetaobjectProtocol mop : this.getDelegationOrder(object)) {
            Object res = mop.representAs(object, targetClass);
            if (res == BaseMetaobjectProtocol.Results.noAuthority) continue;
            return res;
        }
        return BaseMetaobjectProtocol.Results.noAuthority;
    }
}

