/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.language;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.language.ClassnameCompletionItem;
import org.netbeans.modules.profiler.oql.language.FunctionCompletionItem;
import org.netbeans.modules.profiler.oql.language.KeywordCompletionItem;
import org.netbeans.modules.profiler.oql.language.OQLTokenId;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQLCompletionProvider
implements CompletionProvider {
    private final Set<String> keywords = new HashSet<String>();
    private final Set<String> functions = new HashSet<String>();
    private final Set<String> heapMethods = new HashSet<String>();

    public OQLCompletionProvider() {
        this.keywords.add("select");
        this.keywords.add("from");
        this.keywords.add("instanceof");
        this.keywords.add("where");
        this.functions.add("map");
        this.functions.add("filter");
        this.functions.add("sort");
        this.functions.add("top");
        this.functions.add("classof");
        this.functions.add("forEachReferrer");
        this.functions.add("identical");
        this.functions.add("objectid");
        this.functions.add("reachables");
        this.functions.add("referrers");
        this.functions.add("referees");
        this.functions.add("refers");
        this.functions.add("root");
        this.functions.add("sizeof");
        this.functions.add("rsizeof");
        this.functions.add("toHtml");
        this.functions.add("concat");
        this.functions.add("contains");
        this.functions.add("count");
        this.functions.add("filter");
        this.functions.add("length");
        this.functions.add("map");
        this.functions.add("max");
        this.functions.add("min");
        this.functions.add("sort");
        this.functions.add("top");
        this.functions.add("sum");
        this.functions.add("toArray");
        this.functions.add("unique");
        this.heapMethods.add("objects");
        this.heapMethods.add("classes");
        this.heapMethods.add("forEachClass");
        this.heapMethods.add("forEachObject");
        this.heapMethods.add("findClass");
        this.heapMethods.add("findObject");
        this.heapMethods.add("finalizables");
        this.heapMethods.add("livepaths");
        this.heapMethods.add("roots");
    }

    public CompletionTask createTask(int n, final JTextComponent jTextComponent) {
        if (n != 1) {
            return null;
        }
        final Document document = jTextComponent.getDocument();
        final TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        AsyncCompletionQuery asyncCompletionQuery = new AsyncCompletionQuery(){

            protected void query(CompletionResultSet completionResultSet, Document document2, int n) {
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                Token token = OQLCompletionProvider.this.findCurrentToken(jTextComponent, (TokenSequence<OQLTokenId>)tokenSequence);
                if (token == null) {
                    completionResultSet.finish();
                    return;
                }
                switch ((OQLTokenId)token.id()) {
                    case UNKNOWN: {
                        String string = token.toString();
                        if (!"instanceof".startsWith(string.trim())) break;
                        completionResultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "instanceof", tokenSequence.offset() + string.length(), string.length()));
                        break;
                    }
                    case WHITESPACE: {
                        completionResultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "instanceof", tokenSequence.offset() + 1));
                        break;
                    }
                    case KEYWORD: {
                        String string = token.toString();
                        for (String string2 : OQLCompletionProvider.this.keywords) {
                            if (string.trim().length() != 0 && !string2.startsWith(string.trim())) continue;
                            completionResultSet.addItem((CompletionItem)new KeywordCompletionItem("00", string2, tokenSequence.offset() + string.length(), string.length()));
                        }
                        break;
                    }
                    case JSBLOCK: {
                        int n2;
                        boolean bl = false;
                        int n3 = 0;
                        if (tokenSequence.movePrevious()) {
                            ++n3;
                        }
                        if (tokenSequence.movePrevious()) {
                            ++n3;
                        }
                        bl = tokenSequence.token().toString().trim().toLowerCase().equals("heap");
                        for (int i = n3; i > 0; --i) {
                            tokenSequence.moveNext();
                        }
                        String string = token.toString();
                        for (String string3 : OQLCompletionProvider.this.functions) {
                            if (string.trim().length() != 0 && !string3.startsWith(string.trim())) continue;
                            completionResultSet.addItem((CompletionItem)new FunctionCompletionItem("00", string3, tokenSequence.offset() + string.length(), string.trim().length()));
                        }
                        if ("heap".startsWith(string.trim())) {
                            completionResultSet.addItem((CompletionItem)new KeywordCompletionItem("00", "heap", tokenSequence.offset() + string.length(), string.trim().length()));
                        }
                        if (bl) {
                            string = token.toString().trim();
                            for (String string3 : OQLCompletionProvider.this.heapMethods) {
                                if (string.length() != 0 && !string3.startsWith(string)) continue;
                                completionResultSet.addItem((CompletionItem)new FunctionCompletionItem("00", string3, tokenSequence.offset() + string.length(), string.trim().length()));
                            }
                        }
                        if ((n2 = string.lastIndexOf(" ")) > -1) {
                            string = string.substring(n2);
                        }
                        if (string.trim().length() != 0 && !"from".startsWith(string.trim())) break;
                        completionResultSet.addItem((CompletionItem)new KeywordCompletionItem("01", "from", tokenSequence.offset() + (n2 > -1 ? n2 : 0) + string.length(), string.trim().length()));
                        break;
                    }
                    case DOT: {
                        tokenSequence.movePrevious();
                        if (!tokenSequence.token().toString().trim().toLowerCase().equals("heap")) break;
                        tokenSequence.moveNext();
                        for (String string : OQLCompletionProvider.this.heapMethods) {
                            completionResultSet.addItem((CompletionItem)new FunctionCompletionItem("00", string, tokenSequence.offset() + 1));
                        }
                        break;
                    }
                    case CLAZZ_E: 
                    case CLAZZ: {
                        Object object;
                        Serializable serializable;
                        String string;
                        OQLEngine oQLEngine = (OQLEngine)document.getProperty(OQLEngine.class);
                        String string4 = token.toString().replace("\n", " ").trim();
                        String string5 = ".*?" + string4.replace("[", "\\[").replace("]", "\\]").replace("$", "\\$") + ".*";
                        String string6 = null;
                        if (string4.trim().equals(string4.trim().toUpperCase())) {
                            string = string4.trim();
                            serializable = new StringBuilder(".*?");
                            for (int i = 0; i < string.length(); ++i) {
                                if (string.charAt(i) < 'A' || string.charAt(i) > 'Z') {
                                    serializable = null;
                                    break;
                                }
                                ((StringBuilder)serializable).append(string.charAt(i));
                                ((StringBuilder)serializable).append("[a-z]*?");
                            }
                            if (serializable != null) {
                                ((StringBuilder)serializable).append(".*");
                                string6 = ((StringBuilder)serializable).toString();
                            }
                        }
                        string = "^" + string4.replace("[", "\\[").replace("]", "\\]").replace("$", "\\$") + ".*";
                        serializable = new HashSet();
                        Iterator iterator = oQLEngine.getHeap().getJavaClassesByRegExp(string).iterator();
                        while (iterator.hasNext()) {
                            object = ((JavaClass)iterator.next()).getName();
                            serializable.add("00 " + (String)object);
                        }
                        if (string6 != null) {
                            iterator = oQLEngine.getHeap().getJavaClassesByRegExp(string6).iterator();
                            while (iterator.hasNext()) {
                                object = ((JavaClass)iterator.next()).getName();
                                serializable.add("01 " + (String)object);
                            }
                        }
                        iterator = oQLEngine.getHeap().getJavaClassesByRegExp(string5).iterator();
                        while (iterator.hasNext()) {
                            object = ((JavaClass)iterator.next()).getName();
                            serializable.add("02 " + (String)object);
                        }
                        object = serializable.iterator();
                        while (object.hasNext()) {
                            String string7 = (String)object.next();
                            StringTokenizer stringTokenizer = new StringTokenizer(string7);
                            completionResultSet.addItem((CompletionItem)new ClassnameCompletionItem(stringTokenizer.nextToken(), stringTokenizer.nextToken(), tokenSequence.offset(), string4.length()));
                        }
                        break;
                    }
                }
                completionResultSet.finish();
            }
        };
        return asyncCompletionQuery != null ? new AsyncCompletionTask(asyncCompletionQuery) : null;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        if (string.endsWith(".")) {
            return 1;
        }
        return 0;
    }

    private Token<OQLTokenId> findCurrentToken(JTextComponent jTextComponent, TokenSequence<OQLTokenId> tokenSequence) {
        Token token = null;
        tokenSequence.moveStart();
        int n = jTextComponent.getCaretPosition();
        int n2 = 0;
        while (tokenSequence.moveNext()) {
            n2 = tokenSequence.offset();
            if (n2 >= n) {
                tokenSequence.movePrevious();
                break;
            }
            token = tokenSequence.token();
        }
        return token;
    }
}

