/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class FileSearchOptions {
    private static final String CASE_SENSITIVE = "caseSensitive";
    private static final String SHOW_HIDDEN_FILES = "showHiddenFiles";
    private static final String PREFER_MAIN_PROJECT = "preferMainProject";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static Preferences node;

    public static boolean getCaseSensitive() {
        return FileSearchOptions.getNode().getBoolean(CASE_SENSITIVE, false);
    }

    public static void setCaseSensitive(boolean bl) {
        FileSearchOptions.getNode().putBoolean(CASE_SENSITIVE, bl);
    }

    public static boolean getShowHiddenFiles() {
        return FileSearchOptions.getNode().getBoolean(SHOW_HIDDEN_FILES, false);
    }

    public static void setShowHiddenFiles(boolean bl) {
        FileSearchOptions.getNode().putBoolean(SHOW_HIDDEN_FILES, bl);
    }

    public static boolean getPreferMainProject() {
        return FileSearchOptions.getNode().getBoolean(PREFER_MAIN_PROJECT, true);
    }

    public static void setPreferMainProject(boolean bl) {
        FileSearchOptions.getNode().putBoolean(PREFER_MAIN_PROJECT, bl);
    }

    public static int getHeight() {
        return FileSearchOptions.getNode().getInt(HEIGHT, 460);
    }

    public static void setHeight(int n) {
        FileSearchOptions.getNode().putInt(HEIGHT, n);
    }

    public static int getWidth() {
        return FileSearchOptions.getNode().getInt(WIDTH, 740);
    }

    public static void setWidth(int n) {
        FileSearchOptions.getNode().putInt(WIDTH, n);
    }

    static void flush() {
        try {
            FileSearchOptions.getNode().flush();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    private static synchronized Preferences getNode() {
        if (node == null) {
            node = NbPreferences.forModule(FileSearchOptions.class);
        }
        return node;
    }
}

