/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateProjectImpl
implements UpdateImplementation {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("j2seproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private static final String MINIMUM_ANT_VERSION_ELEMENT = "minimum-ant-version";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;

    UpdateProjectImpl(Project project, AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration) {
        assert (project != null && antProjectHelper != null && auxiliaryConfiguration != null);
        this.project = project;
        this.helper = antProjectHelper;
        this.cfg = auxiliaryConfiguration;
    }

    public boolean isCurrent() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                UpdateProjectImpl updateProjectImpl = UpdateProjectImpl.this;
                synchronized (updateProjectImpl) {
                    if (UpdateProjectImpl.this.isCurrent == null) {
                        if (UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true) != null || UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true) != null) {
                            UpdateProjectImpl.this.isCurrent = Boolean.FALSE;
                        } else {
                            UpdateProjectImpl.this.isCurrent = Boolean.TRUE;
                        }
                    }
                    return UpdateProjectImpl.this.isCurrent;
                }
            }
        });
    }

    public boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean bl = this.showUpdateDialog();
        if (!bl) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateProjectImpl.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpdate(EditableProperties editableProperties) throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateProjectImpl updateProjectImpl = this;
        synchronized (updateProjectImpl) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    public synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            Element element = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
            if (element != null) {
                Document document = element.getOwnerDocument();
                Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "data");
                UpdateProjectImpl.copyDocument(document, element, element2);
                Element element3 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
                Element element4 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                element4.setAttribute("id", "src.dir");
                element3.appendChild(element4);
                element2.appendChild(element3);
                Element element5 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
                element4 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                element4.setAttribute("id", "test.src.dir");
                element5.appendChild(element4);
                element2.appendChild(element5);
                this.cachedElement = element2;
            } else {
                element = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
                if (element != null) {
                    Document document = element.getOwnerDocument();
                    Element element6 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "data");
                    UpdateProjectImpl.copyDocument(document, element, element6);
                    this.cachedElement = element6;
                }
            }
        }
        if (this.cachedElement != null) {
            UpdateProjectImpl.deleteMinAntVersion(this.cachedElement);
        }
        return this.cachedElement;
    }

    public synchronized EditableProperties getUpdatedProjectProperties() {
        EditableProperties editableProperties = this.helper.getProperties("nbproject/project.properties");
        if (editableProperties.get((Object)"javadoc.additionalparam") == null) {
            editableProperties.put("javadoc.additionalparam", "");
        }
        if (editableProperties.get((Object)"build.generated.dir") == null) {
            editableProperties.put("build.generated.dir", "${build.dir}/generated");
        }
        if (editableProperties.get((Object)"meta.inf.dir") == null) {
            editableProperties.put("meta.inf.dir", "${src.dir}/META-INF");
        }
        return editableProperties;
    }

    private static void copyDocument(Document document, Element element, Element element2) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Node node2 = null;
            switch (node.getNodeType()) {
                case 1: {
                    Node node3;
                    Element element3 = (Element)node;
                    node2 = document.createElementNS("http://www.netbeans.org/ns/j2se-project/3", element3.getTagName());
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    Element element4 = (Element)node2;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        node3 = namedNodeMap.item(j);
                        element4.setAttribute(node3.getNodeName(), node3.getNodeValue());
                    }
                    UpdateProjectImpl.copyDocument(document, element3, element4);
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    node2 = document.createTextNode(text.getData());
                    break;
                }
                case 8: {
                    Node node3 = (Comment)node;
                    node2 = document.createComment(node3.getData());
                }
            }
            if (node2 == null) continue;
            element2.appendChild(node2);
        }
    }

    private static void deleteMinAntVersion(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", MINIMUM_ANT_VERSION_ELEMENT);
        if (nodeList.getLength() == 1) {
            Node node = nodeList.item(0);
            node.getParentNode().removeChild(node);
        }
    }

    private boolean showUpdateDialog() {
        JButton jButton = new JButton(NbBundle.getMessage(UpdateProjectImpl.class, (String)"CTL_UpdateOption"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateProjectImpl.class, (String)"AD_UpdateOption"));
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton)) == jButton;
    }
}

