/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.debug.Breakpoint;
import org.jruby.debug.Context;
import org.jruby.debug.Debugger;
import org.jruby.debug.RubyDebugBaseLibrary;
import org.jruby.debug.Util;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class RubyDebugger {
    static final String DEBUG_THREAD_NAME = "DebugThread";
    static final String CONTEXT_NAME = "Context";
    private static final String VERSION = "0.10.3.1";
    private static Debugger debugger;
    private static final ObjectAllocator BREAKPOINT_ALLOCATOR;
    private static final ObjectAllocator CONTEXT_ALLOCATOR;

    private RubyDebugger() {
    }

    public static RubyModule createDebuggerModule(Ruby runtime) {
        RubyModule debuggerMod = runtime.defineModule("Debugger");
        debuggerMod.defineConstant("VERSION", (IRubyObject)runtime.newString(VERSION));
        debuggerMod.defineAnnotatedMethods(RubyDebugger.class);
        debuggerMod.defineClassUnder("ThreadsTable", runtime.getObject(), runtime.getObject().getAllocator());
        RubyClass debugThread = debuggerMod.defineClassUnder(DEBUG_THREAD_NAME, runtime.getClass("Thread"), runtime.getClass("Thread").getAllocator());
        debugThread.defineAnnotatedMethods(RubyDebugBaseLibrary.DebugThread.class);
        RubyClass breakpoint = debuggerMod.defineClassUnder("Breakpoint", runtime.getObject(), BREAKPOINT_ALLOCATOR);
        breakpoint.defineAnnotatedMethods(Breakpoint.class);
        RubyClass context = debuggerMod.defineClassUnder(CONTEXT_NAME, runtime.getObject(), CONTEXT_ALLOCATOR);
        context.defineAnnotatedMethods(Context.class);
        return debuggerMod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Debugger debugger() {
        Class<RubyDebugger> clazz = RubyDebugger.class;
        synchronized (RubyDebugger.class) {
            if (debugger == null) {
                debugger = new Debugger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return debugger;
        }
    }

    @JRubyMethod(name={"start_"}, module=true)
    public static IRubyObject start(IRubyObject recv, Block block) {
        return RubyDebugger.debugger().start(recv, block);
    }

    @JRubyMethod(name={"stop"}, module=true)
    public static IRubyObject stop(IRubyObject recv, Block block) {
        boolean stopped = RubyDebugger.debugger().stop(recv.getRuntime());
        return Util.toRBoolean(recv, stopped);
    }

    @JRubyMethod(name={"started?"}, module=true)
    public static IRubyObject started_p(IRubyObject recv, Block block) {
        return Util.toRBoolean(recv, RubyDebugger.debugger().isStarted());
    }

    @JRubyMethod(name={"breakpoints"}, module=true)
    public static IRubyObject breakpoints(IRubyObject recv, Block block) {
        RubyDebugger.debugger().checkStarted(recv);
        return RubyDebugger.debugger().getBreakpoints();
    }

    @JRubyMethod(name={"add_breakpoint"}, module=true, required=2, optional=1)
    public static IRubyObject add_breakpoint(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyDebugger.debugger().addBreakpoint(recv, args);
    }

    @JRubyMethod(name={"remove_breakpoint"}, module=true, required=1)
    public static IRubyObject remove_breakpoint(IRubyObject recv, IRubyObject breakpointId, Block block) {
        return RubyDebugger.debugger().removeBreakpoint(recv, breakpointId);
    }

    @JRubyMethod(name={"catchpoints"}, module=true)
    public static IRubyObject catchpoint(IRubyObject recv, Block block) {
        RubyDebugger.debugger().checkStarted(recv);
        return RubyDebugger.debugger().getCatchpoints();
    }

    @JRubyMethod(name={"add_catchpoint"}, module=true, required=1)
    public static IRubyObject addCatchpoint(IRubyObject recv, IRubyObject catchpoint, Block block) {
        RubyDebugger.debugger().addCatchpoint(recv, catchpoint);
        return catchpoint;
    }

    @JRubyMethod(name={"last_context"}, module=true)
    public static IRubyObject last_context(IRubyObject recv, Block block) {
        return RubyDebugger.debugger().lastInterrupted(recv);
    }

    @JRubyMethod(name={"contexts"}, module=true)
    public static IRubyObject contexts(IRubyObject recv, Block block) {
        return RubyDebugger.debugger().getDebugContexts(recv);
    }

    @JRubyMethod(name={"current_context"}, module=true)
    public static IRubyObject current_context(IRubyObject recv, Block block) {
        return RubyDebugger.debugger().getCurrentContext(recv);
    }

    @JRubyMethod(name={"thread_context"}, module=true, required=1)
    public static IRubyObject thread_context(IRubyObject recv, IRubyObject context, Block block) {
        return RubyDebugger.debugger().getCurrentContext(recv);
    }

    @JRubyMethod(name={"suspend"}, module=true)
    public static IRubyObject suspend(IRubyObject recv, Block block) {
        RubyDebugger.debugger().suspend(recv);
        return recv;
    }

    @JRubyMethod(name={"resume"}, module=true)
    public static IRubyObject resume(IRubyObject recv, Block block) {
        RubyDebugger.debugger().resume(recv);
        return recv;
    }

    @JRubyMethod(name={"tracing"}, module=true)
    public static IRubyObject tracing(IRubyObject recv, Block block) {
        return recv.getRuntime().newBoolean(RubyDebugger.debugger().isTracing());
    }

    @JRubyMethod(name={"tracing="}, module=true, required=1)
    public static IRubyObject tracing_set(IRubyObject recv, IRubyObject tracing, Block block) {
        RubyDebugger.debugger().setTracing(tracing.isTrue());
        return tracing;
    }

    @JRubyMethod(name={"debug_load"}, module=true, required=1, optional=2)
    public static IRubyObject debug_load(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyDebugger.debugger().load(recv, args);
        return Util.nil(recv);
    }

    @JRubyMethod(name={"skip"}, module=true)
    public static IRubyObject skip(IRubyObject recv, Block block) {
        return RubyDebugger.debugger().skip(recv, block);
    }

    @JRubyMethod(name={"debug_at_exit"}, module=true)
    public static IRubyObject debug_at_exit(IRubyObject recv, Block block) {
        RubyProc proc = RubyKernel.proc((ThreadContext)recv.getRuntime().getCurrentContext(), (IRubyObject)recv, (Block)block);
        recv.getRuntime().pushExitBlock(proc);
        return proc;
    }

    @JRubyMethod(name={"post_mortem?"}, module=true)
    public static IRubyObject post_mortem_p(IRubyObject recv, Block block) {
        return Util.toRBoolean(recv, RubyDebugger.debugger().isPostMortem());
    }

    @JRubyMethod(name={"post_mortem="}, module=true, required=1)
    public static IRubyObject post_mortem_set(IRubyObject recv, IRubyObject postMortem, Block block) {
        throw recv.getRuntime().newRuntimeError("Post mortem debugging is not (yet) supported");
    }

    @JRubyMethod(name={"keep_frame_binding?"}, module=true)
    public static IRubyObject keep_frame_binding_p(IRubyObject recv, Block block) {
        return recv.getRuntime().newBoolean(RubyDebugger.debugger().isKeepFrameBinding());
    }

    @JRubyMethod(name={"keep_frame_binding="}, module=true, required=1)
    public static IRubyObject keep_frame_binding_set(IRubyObject recv, IRubyObject keepFrameBinding, Block block) {
        RubyDebugger.debugger().setKeepFrameBinding(keepFrameBinding.isTrue());
        return keepFrameBinding;
    }

    @JRubyMethod(name={"track_frame_args?"}, module=true)
    public static IRubyObject track_frame_args_p(IRubyObject recv, Block block) {
        return recv.getRuntime().newBoolean(RubyDebugger.debugger().isTrackFrameArgs());
    }

    @JRubyMethod(name={"track_frame_args="}, module=true, required=1)
    public static IRubyObject track_frame_args_set(IRubyObject recv, IRubyObject traceFrameArgs, Block block) {
        RubyDebugger.debugger().setTrackFrameArgs(traceFrameArgs.isTrue());
        return traceFrameArgs;
    }

    @JRubyMethod(name={"debug"}, module=true)
    public static IRubyObject debug(IRubyObject recv, Block block) {
        return Util.toRBoolean(recv, RubyDebugger.debugger().isDebug());
    }

    @JRubyMethod(name={"debug="}, module=true, required=1)
    public static IRubyObject debug_set(IRubyObject recv, IRubyObject debug, Block block) {
        RubyDebugger.debugger().setDebug(debug.isTrue());
        return debug;
    }

    static {
        BREAKPOINT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Breakpoint(runtime, klass);
            }
        };
        CONTEXT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Context(runtime, klass, RubyDebugger.debugger());
            }
        };
    }
}

