/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.ruby.railsprojects.GenerateAction;
import org.netbeans.modules.ruby.railsprojects.Generator;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class TreeRootNode
extends FilterNode
implements PropertyChangeListener {
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
    private final SourceGroup g;
    private final Generator generator;
    private static final Image PACKAGE_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/railsprojects/ui/packageBadge.gif");
    private Action[] actionCache;

    public TreeRootNode(SourceGroup sourceGroup, Generator generator) {
        this(DataFolder.findFolder((FileObject)sourceGroup.getRootFolder()), sourceGroup, generator);
    }

    private TreeRootNode(DataFolder dataFolder, SourceGroup sourceGroup, Generator generator) {
        this((Node)new FilterNode(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER)), sourceGroup, generator);
    }

    private TreeRootNode(Node node, SourceGroup sourceGroup, Generator generator) {
        super(node, (Children)new PackageFilterChildren(node), (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.singleton((Object)generator), Lookups.singleton((Object)new PathFinder(sourceGroup))}));
        this.g = sourceGroup;
        this.generator = generator;
        sourceGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup));
    }

    private Image computeIcon(boolean bl, int n) {
        Icon icon = this.g.getIcon(bl);
        if (icon == null) {
            Image image = bl ? super.getOpenedIcon(n) : super.getIcon(n);
            return ImageUtilities.mergeImages((Image)image, (Image)PACKAGE_BADGE, (int)7, (int)7);
        }
        return ImageUtilities.icon2Image((Icon)icon);
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    public String getName() {
        return this.g.getName();
    }

    public String getDisplayName() {
        return this.g.getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Action[] getActions(boolean bl) {
        return this.initActions(bl);
    }

    private Action[] initActions(boolean bl) {
        if (this.actionCache == null) {
            Action[] actionArray = super.getActions(bl);
            Action[] actionArray2 = this.generator == Generator.NONE ? new Action[]{CommonProjectActions.newFileAction(), null} : new Action[]{SystemAction.get(GenerateAction.class), null, CommonProjectActions.newFileAction(), null};
            if (actionArray != null && actionArray.length > 0) {
                this.actionCache = new Action[actionArray.length + actionArray2.length];
                System.arraycopy(actionArray2, 0, this.actionCache, 0, actionArray2.length);
                System.arraycopy(actionArray, 0, this.actionCache, actionArray2.length, actionArray.length);
            } else {
                this.actionCache = actionArray2;
            }
        }
        return this.actionCache;
    }

    private static final class PackageFilterChildren
    extends FilterNode.Children {
        public PackageFilterChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            return dataObject instanceof DataFolder ? new FilterNode(node, (Children)new PackageFilterChildren(node)) : super.copyNode(node);
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private static final long serialVersionUID = 1L;
        private final EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }

    public static final class PathFinder {
        private final SourceGroup g;

        PathFinder(SourceGroup sourceGroup) {
            this.g = sourceGroup;
        }

        public Node findPath(Node node, Object object) {
            FileObject fileObject;
            if (object instanceof FileObject) {
                fileObject = (FileObject)object;
            } else if (object instanceof DataObject) {
                fileObject = ((DataObject)object).getPrimaryFile();
            } else {
                return null;
            }
            FileObject fileObject2 = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
                String string;
                FileObject fileObject3 = fileObject.isFolder() ? fileObject : fileObject.getParent();
                String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject3);
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    arrayList.add(string);
                }
                try {
                    Object object2 = string = fileObject3.equals(fileObject2) ? node : NodeOp.findPath((Node)node, Collections.enumeration(arrayList));
                    if (fileObject.isFolder()) {
                        return string;
                    }
                    Node[] nodeArray = string.getChildren().getNodes(true);
                    for (int i = 0; i < nodeArray.length; ++i) {
                        DataObject dataObject = (DataObject)nodeArray[i].getLookup().lookup(DataObject.class);
                        if (dataObject == null || !dataObject.getPrimaryFile().getNameExt().equals(fileObject.getNameExt())) continue;
                        return nodeArray[i];
                    }
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    nodeNotFoundException.printStackTrace();
                }
            } else if (fileObject2.equals(fileObject)) {
                return node;
            }
            return null;
        }
    }
}

