/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.server.GlassFishGem;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class RailsServerUiUtils {
    public static JComboBox getServerComboBox(RubyPlatform rubyPlatform) {
        JComboBox jComboBox = new JComboBox();
        if (rubyPlatform != null) {
            jComboBox.setModel(new ServerListModel(rubyPlatform));
        }
        jComboBox.setRenderer(new ServerListCellRendered());
        return jComboBox;
    }

    public static void addDefaultGlassFishGem(ComboBoxModel comboBoxModel, RubyPlatform rubyPlatform) {
        Object object;
        if (rubyPlatform == null || !rubyPlatform.isJRuby()) {
            return;
        }
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            object = comboBoxModel.getElementAt(i);
            if (!(object instanceof GlassFishGem)) continue;
            return;
        }
        ServerListModel serverListModel = (ServerListModel)comboBoxModel;
        object = new FakeGlassFishGem();
        serverListModel.addServer((RubyInstance)object);
    }

    public static boolean isValidServer(Object object) {
        return !(object instanceof FakeGlassFishGem);
    }

    public static boolean isGlassFishGem(Object object) {
        return object instanceof FakeGlassFishGem || object instanceof GlassFishGem;
    }

    public static void replaceFakeGlassFish(WizardDescriptor wizardDescriptor) {
        GemInfo gemInfo;
        RubyInstance rubyInstance = (RubyInstance)wizardDescriptor.getProperty("serverInstance");
        if (!(rubyInstance instanceof FakeGlassFishGem)) {
            return;
        }
        RubyPlatform rubyPlatform = (RubyPlatform)wizardDescriptor.getProperty("platform");
        GemManager gemManager = rubyPlatform.getGemManager();
        if (gemManager == null) {
            return;
        }
        List list = gemManager.getVersions("glassfish");
        GemInfo gemInfo2 = gemInfo = list.isEmpty() ? null : (GemInfo)list.get(0);
        if (gemInfo == null) {
            return;
        }
        GlassFishGem glassFishGem = new GlassFishGem(rubyPlatform, gemInfo);
        wizardDescriptor.putProperty("serverInstance", (Object)glassFishGem);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeGlassFishGem
    implements RubyInstance {
        @Override
        public String getServerUri() {
            return "";
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(RailsServerUiUtils.class, (String)"LBL_FakeGlassFish");
        }

        @Override
        public RubyInstance.ServerState getServerState() {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> startServer(RubyPlatform rubyPlatform) {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> stopServer() {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> deploy(String string, File file) {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> stop(String string) {
            return null;
        }

        @Override
        public Future<RubyInstance.OperationState> runApplication(RubyPlatform rubyPlatform, String string, File file) {
            return null;
        }

        @Override
        public boolean isPlatformSupported(RubyPlatform rubyPlatform) {
            return false;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public String getContextRoot(String string) {
            return "";
        }

        @Override
        public int getRailsPort() {
            return -1;
        }

        @Override
        public String getServerCommand(RubyPlatform rubyPlatform, String string, File file, int n, boolean bl) {
            return null;
        }
    }

    private static class ServerListCellRendered
    extends JLabel
    implements ListCellRenderer {
        public ServerListCellRendered() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            RubyInstance rubyInstance = (RubyInstance)object;
            if (rubyInstance != null) {
                this.setText(rubyInstance.getDisplayName());
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            }
            return this;
        }
    }

    public static class ServerListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<RubyInstance> servers;
        private Object selected;

        public ServerListModel(RubyPlatform rubyPlatform) {
            this.servers = ServerRegistry.getDefault().getServers(rubyPlatform);
            if (!this.servers.isEmpty()) {
                this.selected = this.servers.get(0);
            }
        }

        public int getSize() {
            return this.servers.size();
        }

        public Object getElementAt(int n) {
            return this.servers.get(n);
        }

        public void setSelectedItem(Object object) {
            if (this.selected != object) {
                this.selected = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        void addServer(RubyInstance rubyInstance) {
            boolean bl = false;
            for (RubyInstance rubyInstance2 : this.servers) {
                if (rubyInstance2 instanceof RubyServer) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.servers.add(0, rubyInstance);
                this.setSelectedItem(rubyInstance);
            } else {
                this.servers.add(1, rubyInstance);
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

