/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.ui.customizer.RailsProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsJdbcConnection
extends RailsDatabaseConfiguration {
    private final DatabaseConnection development;
    private final DatabaseConnection test;
    private final DatabaseConnection production;

    public RailsJdbcConnection(DatabaseConnection databaseConnection, DatabaseConnection databaseConnection2, DatabaseConnection databaseConnection3) {
        this.development = databaseConnection;
        this.test = databaseConnection2;
        this.production = databaseConnection3;
    }

    @Override
    public String railsGenerationParam() {
        return null;
    }

    @Override
    public void editConfig(RailsProject railsProject) {
        RailsJdbcConnection.insertActiveJdbcHook(railsProject.getProjectDirectory());
        this.editDatabaseYml(railsProject.getProjectDirectory());
        RailsJdbcConnection.bundleDrivers(railsProject, this.getDriverClass(this.development), this.getDriverClass(this.test), this.getDriverClass(this.production));
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    private String getDriverClass(DatabaseConnection databaseConnection) {
        return databaseConnection != null ? databaseConnection.getDriverClass() : null;
    }

    private static void insertActiveJdbcHook(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("config/environment.rb");
        if (fileObject2 != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    String string = styledDocument.getText(0, styledDocument.getLength());
                    int n = string.indexOf("jdbc");
                    if (n != -1) {
                        return;
                    }
                    n = string.indexOf("Rails::Initializer.run do |config|");
                    if (n != -1) {
                        String string2 = "# Inserted by NetBeans Ruby support to support JRuby\nif defined?(JRUBY_VERSION)\n  require 'rubygems'\n  gem 'activerecord-jdbc-adapter'\n  require 'jdbc_adapter'\nend\n\n";
                        styledDocument.insertString(n, string2, null);
                        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                        if (saveCookie != null) {
                            saveCookie.save();
                        } else {
                            LifecycleManager.getDefault().saveAll();
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editDatabaseYml(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getFileObject("config/database.yml");
        if (fileObject2 != null) {
            BaseDocument baseDocument = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    StyledDocument styledDocument = editorCookie.openDocument();
                    if (styledDocument instanceof BaseDocument) {
                        baseDocument = (BaseDocument)styledDocument;
                        baseDocument.atomicLock();
                    }
                    styledDocument.remove(0, styledDocument.getLength());
                    String string = null;
                    string = "# JDBC Setup\n# Adjust JDBC driver URLs as necessary.\ndevelopment:\n" + this.buildConnectionConf(this.development) + "\n" + "# Warning: The database defined as 'test' will be erased and\n" + "# re-generated from your development database when you run 'rake'.\n" + "# Do not set this db to the same as development or production.\n" + "test:\n" + this.buildConnectionConf(this.test) + "\n" + "production:\n" + this.buildConnectionConf(this.production);
                    styledDocument.insertString(0, string, null);
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                    if (saveCookie != null) {
                        saveCookie.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (baseDocument != null) {
                    baseDocument.atomicUnlock();
                }
            }
        }
    }

    private String buildConnectionConf(DatabaseConnection databaseConnection) {
        if (databaseConnection == null) {
            return "      host: localhost\n      adapter: jdbc\n";
        }
        String string = databaseConnection.getPassword() == null ? "" : databaseConnection.getPassword();
        return "      host: localhost\n      adapter: jdbc\n      driver: " + databaseConnection.getDriverClass() + "\n" + "      url: " + databaseConnection.getDatabaseURL() + "\n" + "      username: " + databaseConnection.getUser() + "\n" + "      password: " + string + "\n";
    }

    static void bundleDrivers(RailsProject railsProject, String ... stringArray) {
        ProjectPropertyExtender projectPropertyExtender = new ProjectPropertyExtender(railsProject.evaluator(), railsProject.getReferenceHelper(), railsProject.getRakeProjectHelper(), RailsProjectProperties.WELL_KNOWN_PATHS, "${libs.", ".classpath}", "${reference.");
        HashSet<ProjectPropertyExtender.Item> hashSet = new HashSet<ProjectPropertyExtender.Item>();
        for (String string : stringArray) {
            if (string == null) continue;
            hashSet.addAll(RailsJdbcConnection.getDriverItems(string));
        }
        String[] stringArray2 = projectPropertyExtender.encodeToStrings(hashSet.iterator());
        EditableProperties editableProperties = railsProject.getRakeProjectHelper().getProperties("nbproject/project.properties");
        editableProperties.setProperty("javac.classpath", stringArray2);
        railsProject.getRakeProjectHelper().putProperties("nbproject/project.properties", editableProperties);
    }

    private static Set<ProjectPropertyExtender.Item> getDriverItems(String string) {
        HashSet<ProjectPropertyExtender.Item> hashSet = new HashSet<ProjectPropertyExtender.Item>();
        for (URL uRL : RailsJdbcConnection.getDriverURLs(string)) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            hashSet.add(ProjectPropertyExtender.Item.create((File)FileUtil.toFile((FileObject)fileObject), null));
        }
        return hashSet;
    }

    private static List<URL> getDriverURLs(String string) {
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (JDBCDriver jDBCDriver : jDBCDriverArray) {
            for (URL uRL : jDBCDriver.getURLs()) {
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    @Override
    public JdbcInfo getJdbcInfo() {
        return null;
    }

    @Override
    public String getDatabaseName(String string) {
        return string + "_development";
    }

    @Override
    public String getTestDatabaseName(String string) {
        return RailsAdapters.getTestDatabaseName(string);
    }

    @Override
    public String getProductionDatabaseName(String string) {
        return RailsAdapters.getProductionDatabaseName(string);
    }
}

