/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.util.Exceptions;

class JdbcMySQlAdapter
extends RailsDatabaseConfiguration {
    static final String GEM_NAME = "activerecord-jdbcmysql-adapter";

    JdbcMySQlAdapter() {
    }

    public String railsGenerationParam() {
        return "mysql";
    }

    public void editConfig(RailsProject railsProject) {
        Document document = RailsAdapters.getDatabaseYml(railsProject.getProjectDirectory());
        if (document == null) {
            return;
        }
        try {
            RailsAdapters.removeProperty(document, "socket:");
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        try {
            RailsAdapters.changeAttribute(document, "adapter:", "jdbcmysql", null);
            this.editComments(document);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private void editComments(Document document) throws BadLocationException {
        String string = document.getText(0, document.getLength());
        int n = string.indexOf("development:");
        if (n == -1) {
            return;
        }
        document.remove(0, n);
        String string2 = "# MySQL.  Versions 4.1 and 5.0 are recommended.\n#\n#\n# Be sure to use new-style password hashing:\n#   http://dev.mysql.com/doc/refman/5.0/en/old-client.html\n";
        document.insertString(0, string2, null);
    }

    public JdbcInfo getJdbcInfo() {
        return null;
    }

    public boolean requiresJdbc() {
        return true;
    }

    public String getDisplayName() {
        return "mysql (jdbc)";
    }

    public String getDatabaseName(String string) {
        return string + "_development";
    }

    public String getTestDatabaseName(String string) {
        return RailsAdapters.getTestDatabaseName(string);
    }

    public String getProductionDatabaseName(String string) {
        return RailsAdapters.getProductionDatabaseName(string);
    }
}

