/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.PrimaryKey;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.View;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataElementHandle<T extends MetadataElement> {
    private static final int CATALOG = 0;
    private static final int SCHEMA = 1;
    private static final int TABLE = 2;
    private static final int VIEW = 2;
    private static final int PROCEDURE = 2;
    private static final int COLUMN = 3;
    private static final int PARAMETER = 3;
    private static final int INDEX = 3;
    private static final int FOREIGN_KEY = 3;
    private static final int FOREIGN_KEY_COLUMN = 4;
    private static final int INDEX_COLUMN = 4;
    private final String[] names;
    private final Kind[] kinds;

    public static <T extends MetadataElement> MetadataElementHandle<T> create(T t) {
        Parameters.notNull((CharSequence)"element", t);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Kind> arrayList2 = new ArrayList<Kind>();
        for (Object object = t; object != null; object = object.getParent()) {
            arrayList.add(object.getInternalName());
            arrayList2.add(Kind.of(object));
        }
        Collections.reverse(arrayList);
        Collections.reverse(arrayList2);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Kind[] kindArray = arrayList2.toArray(new Kind[arrayList2.size()]);
        return new MetadataElementHandle<T>(stringArray, kindArray);
    }

    static <T extends MetadataElement> MetadataElementHandle<T> create(Class<T> clazz, String[] stringArray, Kind[] kindArray) {
        return new MetadataElementHandle<T>(stringArray, kindArray);
    }

    private MetadataElementHandle(String[] stringArray, Kind[] kindArray) {
        this.names = stringArray;
        this.kinds = kindArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MetadataElementHandle metadataElementHandle = (MetadataElementHandle)object;
        if (!Arrays.equals((Object[])this.kinds, (Object[])metadataElementHandle.kinds)) {
            return false;
        }
        return Arrays.equals(this.names, metadataElementHandle.names);
    }

    public int hashCode() {
        int n = 7;
        for (String string : this.names) {
            if (string != null) {
                n ^= string.hashCode();
                continue;
            }
            ++n;
        }
        for (Kind kind : this.kinds) {
            n ^= kind.hashCode();
        }
        return n;
    }

    public T resolve(Metadata metadata) {
        int n = this.kinds.length;
        switch (this.kinds[n - 1]) {
            case CATALOG: {
                return (T)this.resolveCatalog(metadata);
            }
            case SCHEMA: {
                return (T)this.resolveSchema(metadata);
            }
            case TABLE: {
                return (T)this.resolveTable(metadata);
            }
            case VIEW: {
                return (T)this.resolveView(metadata);
            }
            case PROCEDURE: {
                return (T)this.resolveProcedure(metadata);
            }
            case COLUMN: {
                return (T)this.resolveColumn(metadata);
            }
            case PRIMARY_KEY: {
                return (T)this.resolvePrimaryKey(metadata);
            }
            case PARAMETER: {
                return (T)this.resolveParameter(metadata);
            }
            case FOREIGN_KEY: {
                return (T)this.resolveForeignKey(metadata);
            }
            case INDEX: {
                return (T)this.resolveIndex(metadata);
            }
            case FOREIGN_KEY_COLUMN: {
                return (T)this.resolveForeignKeyColumn(metadata);
            }
            case INDEX_COLUMN: {
                return (T)this.resolveIndexColumn(metadata);
            }
        }
        throw new IllegalStateException("Unhandled kind " + (Object)((Object)this.kinds[this.kinds.length - 1]));
    }

    private Catalog resolveCatalog(Metadata metadata) {
        return metadata.getCatalog(this.names[0]);
    }

    private Schema resolveSchema(Metadata metadata) {
        Catalog catalog = this.resolveCatalog(metadata);
        if (catalog != null) {
            String string = this.names[1];
            if (string != null) {
                return catalog.getSchema(string);
            }
            return catalog.getSyntheticSchema();
        }
        return null;
    }

    private Table resolveTable(Metadata metadata) {
        Schema schema = this.resolveSchema(metadata);
        if (schema != null) {
            return schema.getTable(this.names[2]);
        }
        return null;
    }

    private View resolveView(Metadata metadata) {
        Schema schema = this.resolveSchema(metadata);
        if (schema != null) {
            return schema.getView(this.names[2]);
        }
        return null;
    }

    private Procedure resolveProcedure(Metadata metadata) {
        Schema schema = this.resolveSchema(metadata);
        if (schema != null) {
            return schema.getProcedure(this.names[2]);
        }
        return null;
    }

    private PrimaryKey resolvePrimaryKey(Metadata metadata) {
        Table table = this.resolveTable(metadata);
        if (table != null) {
            return table.getPrimaryKey();
        }
        return null;
    }

    private Column resolveColumn(Metadata metadata) {
        switch (this.kinds[2]) {
            case TABLE: {
                Table table = this.resolveTable(metadata);
                if (table != null) {
                    return table.getColumn(this.names[3]);
                }
                return null;
            }
            case PROCEDURE: {
                Procedure procedure = this.resolveProcedure(metadata);
                if (procedure != null) {
                    return procedure.getColumn(this.names[3]);
                }
                return null;
            }
            case VIEW: {
                View view = this.resolveView(metadata);
                if (view != null) {
                    return view.getColumn(this.names[3]);
                }
                return null;
            }
        }
        throw new IllegalStateException("Unhandled kind " + (Object)((Object)this.kinds[2]));
    }

    private Parameter resolveParameter(Metadata metadata) {
        Procedure procedure = this.resolveProcedure(metadata);
        if (procedure != null) {
            return procedure.getParameter(this.names[3]);
        }
        return null;
    }

    private Index resolveIndex(Metadata metadata) {
        Table table = this.resolveTable(metadata);
        if (table != null) {
            return table.getIndex(this.names[3]);
        }
        return null;
    }

    private ForeignKey resolveForeignKey(Metadata metadata) {
        Table table = this.resolveTable(metadata);
        if (table != null) {
            return table.getForeignKeyByInternalName(this.names[3]);
        }
        return null;
    }

    private ForeignKeyColumn resolveForeignKeyColumn(Metadata metadata) {
        ForeignKey foreignKey = this.resolveForeignKey(metadata);
        if (foreignKey != null) {
            return foreignKey.getColumn(this.names[4]);
        }
        return null;
    }

    private IndexColumn resolveIndexColumn(Metadata metadata) {
        Index index = this.resolveIndex(metadata);
        if (index != null) {
            return index.getColumn(this.names[4]);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Kind {
        CATALOG(Catalog.class),
        SCHEMA(Schema.class),
        TABLE(Table.class),
        VIEW(View.class),
        PROCEDURE(Procedure.class),
        PARAMETER(Parameter.class),
        COLUMN(Column.class),
        PRIMARY_KEY(PrimaryKey.class),
        FOREIGN_KEY(ForeignKey.class),
        INDEX(Index.class),
        FOREIGN_KEY_COLUMN(ForeignKeyColumn.class),
        INDEX_COLUMN(IndexColumn.class);

        private final Class<? extends MetadataElement> clazz;

        public static Kind of(MetadataElement metadataElement) {
            return Kind.of(metadataElement.getClass());
        }

        public static Kind of(Class<? extends MetadataElement> clazz) {
            for (Kind kind : Kind.values()) {
                if (!kind.clazz.equals(clazz)) continue;
                return kind;
            }
            throw new IllegalStateException("Unhandled class " + clazz);
        }

        private Kind(Class<? extends MetadataElement> clazz) {
            this.clazz = clazz;
        }
    }
}

