/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.catalog.lib.IteratorIterator;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.lookup.Lookups;

public final class CatalogSettings
implements Externalizable {
    private static final long serialVersionUID = 7895789034L;
    public static final int VERSION_1 = 1;
    public static final String PROP_MOUNTED_CATALOGS = "catalogs";
    private static final String REGISTRATIONS = "Plugins/XML/UserCatalogs";
    private static Lookup userCatalogLookup;
    private List mountedCatalogs = new ArrayList(5);
    private PropertyChangeSupport listeners = null;
    private final CatalogListener catalogListener = new CL();
    private static CatalogSettings instance;

    public CatalogSettings() {
        this.init();
    }

    private void init() {
        this.listeners = new PropertyChangeSupport(this);
    }

    public static synchronized CatalogSettings getDefault() {
        if (instance == null) {
            instance = (CatalogSettings)Lookup.getDefault().lookup(CatalogSettings.class);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCatalog(CatalogReader catalogReader) {
        CatalogSettings catalogSettings = this;
        synchronized (catalogSettings) {
            if (catalogReader == null) {
                throw new IllegalArgumentException("null provider not permited");
            }
            if (!this.mountedCatalogs.contains(catalogReader)) {
                this.mountedCatalogs.add(catalogReader);
            }
        }
        this.firePropertyChange(PROP_MOUNTED_CATALOGS, null, null);
        try {
            catalogReader.addCatalogListener(this.catalogListener);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCatalog(CatalogReader catalogReader) {
        CatalogSettings catalogSettings = this;
        synchronized (catalogSettings) {
            this.mountedCatalogs.remove(catalogReader);
        }
        this.firePropertyChange(PROP_MOUNTED_CATALOGS, null, null);
        try {
            catalogReader.removeCatalogListener(this.catalogListener);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public final boolean isRemovable(CatalogReader catalogReader) {
        return this.mountedCatalogs.contains(catalogReader);
    }

    public final synchronized Iterator getCatalogs(Class[] classArray) {
        IteratorIterator iteratorIterator = new IteratorIterator();
        iteratorIterator.add(this.mountedCatalogs.iterator());
        Lookup.Template template = new Lookup.Template(CatalogReader.class);
        Lookup.Result result = CatalogSettings.getUserCatalogsLookup().lookup(template);
        iteratorIterator.add(result.allInstances().iterator());
        if (classArray == null) {
            return iteratorIterator;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iteratorIterator.hasNext()) {
            Object object = iteratorIterator.next();
            boolean bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].isAssignableFrom(object.getClass())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(object);
        }
        return arrayList.iterator();
    }

    private static Lookup getUserCatalogsLookup() {
        if (userCatalogLookup == null) {
            userCatalogLookup = Lookups.forPath((String)REGISTRATIONS);
        }
        return userCatalogLookup;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n != 1) {
            throw new StreamCorruptedException("Unsupported catalog externalization protocol version (" + n + ").");
        }
        int n2 = objectInput.readInt();
        for (int i = 0; i < n2; ++i) {
            String string = (String)objectInput.readObject();
            NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)objectInput.readObject();
            try {
                Object object = nbMarshalledObject.get();
                if (this.mountedCatalogs.contains(object)) continue;
                this.mountedCatalogs.add(object);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.emgr().annotate((Throwable)classNotFoundException, NbBundle.getMessage(CatalogSettings.class, (String)"EXC_deserialization_failed", (Object)string));
                this.emgr().notify(1, (Throwable)classNotFoundException);
                continue;
            }
            catch (IOException iOException) {
                this.emgr().annotate((Throwable)iOException, NbBundle.getMessage(CatalogSettings.class, (String)"EXC_deserialization_failed", (Object)string));
                this.emgr().notify(1, (Throwable)iOException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.emgr().annotate((Throwable)runtimeException, NbBundle.getMessage(CatalogSettings.class, (String)"EXC_deserialization_failed", (Object)string));
                this.emgr().notify(1, (Throwable)runtimeException);
            }
        }
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        int n = 0;
        for (Object e : this.mountedCatalogs) {
            if (!(e instanceof Serializable)) continue;
            ++n;
        }
        Iterator iterator = this.mountedCatalogs.iterator();
        objectOutput.writeInt(n);
        while (iterator.hasNext()) {
            Object e;
            e = iterator.next();
            if (!(e instanceof Serializable)) continue;
            try {
                NbMarshalledObject nbMarshalledObject = new NbMarshalledObject(e);
                objectOutput.writeObject(e.getClass().getName());
                objectOutput.writeObject(nbMarshalledObject);
            }
            catch (IOException iOException) {
                this.emgr().annotate((Throwable)iOException, NbBundle.getMessage(CatalogSettings.class, (String)"EXC_serialization_failed", e.getClass()));
                this.emgr().notify(1, (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                this.emgr().annotate((Throwable)runtimeException, NbBundle.getMessage(CatalogSettings.class, (String)"EXC_serialization_failed", e.getClass()));
                this.emgr().notify(1, (Throwable)runtimeException);
            }
        }
    }

    private ErrorManager emgr() {
        return ErrorManager.getDefault();
    }

    public String toString() {
        Lookup.Template template = new Lookup.Template(CatalogReader.class);
        Lookup.Result result = CatalogSettings.getUserCatalogsLookup().lookup(template);
        return "CatalogSettings[ global-scope: " + result.allInstances() + ", project-scope: " + this.mountedCatalogs + " ]";
    }

    static {
        instance = null;
    }

    private class CL
    implements CatalogListener {
        private CL() {
        }

        public void notifyRemoved(String string) {
        }

        public void notifyNew(String string) {
        }

        public void notifyUpdate(String string) {
        }

        public void notifyInvalidate() {
            CatalogSettings.this.firePropertyChange("settings changed!", null, CatalogSettings.this);
        }
    }
}

