/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.CustomTextToken;
import org.netbeans.lib.lexer.token.DefaultToken;
import org.netbeans.lib.lexer.token.PropertyToken;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LexerInputOperation<T extends TokenId> {
    static final Logger LOG = Logger.getLogger(LexerInputOperation.class.getName());
    static final Logger LexerInputLOG = Logger.getLogger(LexerInput.class.getName());
    protected final TokenList<T> tokenList;
    protected int readOffset;
    protected int tokenStartOffset;
    private int lookaheadOffset;
    protected int tokenLength;
    protected Lexer<T> lexer;
    protected final LanguageOperation<T> innerLanguageOperation;
    private int flyTokenSequenceLength;

    public LexerInputOperation(TokenList<T> tokenList, int n, Object object) {
        this.tokenList = tokenList;
        LanguagePath languagePath = tokenList.languagePath();
        this.innerLanguageOperation = LexerUtilsConstants.innerLanguageOperation(languagePath);
        while (--n >= 0 && tokenList.tokenOrEmbedding(n).token().isFlyweight()) {
            ++this.flyTokenSequenceLength;
        }
        LanguageHierarchy languageHierarchy = LexerApiPackageAccessor.get().languageHierarchy(LexerUtilsConstants.innerLanguage(languagePath));
        TokenFactory tokenFactory = LexerSpiPackageAccessor.get().createTokenFactory(this);
        LexerInput lexerInput = LexerSpiPackageAccessor.get().createLexerInput(this);
        LexerRestartInfo lexerRestartInfo = LexerSpiPackageAccessor.get().createLexerRestartInfo(lexerInput, tokenFactory, object, languagePath, tokenList.inputAttributes());
        this.lexer = LexerSpiPackageAccessor.get().createLexer(languageHierarchy, lexerRestartInfo);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.INFO, "LexerInputOperation created for " + tokenList.tokenHierarchyOperation().inputSource(), new Exception());
        }
    }

    public abstract int read(int var1);

    public abstract char readExisting(int var1);

    protected abstract void fillTokenData(AbstractToken<T> var1);

    public final int read() {
        int n;
        if ((n = this.read(this.readOffset++)) == -1) {
            this.lookaheadOffset = this.readOffset--;
        }
        return n;
    }

    public final int readLength() {
        return this.readOffset - this.tokenStartOffset;
    }

    public final char readExistingAtIndex(int n) {
        return this.readExisting(this.tokenStartOffset + n);
    }

    public final void backup(int n) {
        if (this.lookaheadOffset < this.readOffset) {
            this.lookaheadOffset = this.readOffset;
        }
        this.readOffset -= n;
    }

    public final int lookahead() {
        return Math.max(this.lookaheadOffset, this.readOffset) - this.tokenStartOffset;
    }

    public AbstractToken<T> nextToken() {
        AbstractToken abstractToken;
        do {
            if ((abstractToken = (AbstractToken)this.lexer.nextToken()) == null) {
                this.checkLexerInputFinished();
                return null;
            }
            Language<T> language = this.innerLanguageOperation.language();
            if (!this.isSkipToken(abstractToken) && !language.tokenIds().contains(abstractToken.id())) {
                String string = "Invalid TokenId=" + abstractToken.id() + " returned from lexer=" + this.lexer + " for language=" + language + ":\n";
                if (abstractToken.id().ordinal() > language.maxOrdinal()) {
                    throw new IllegalStateException(string + "Language.maxOrdinal()=" + language.maxOrdinal() + " < " + abstractToken.id().ordinal());
                }
                throw new IllegalStateException(string + "Language contains no or different tokenId with ordinal=" + abstractToken.id().ordinal() + ": " + language.tokenId(abstractToken.id().ordinal()));
            }
            this.tokenStartOffset += this.tokenLength;
        } while (this.isSkipToken(abstractToken));
        return abstractToken;
    }

    public int lastTokenEndOffset() {
        return this.tokenStartOffset;
    }

    public AbstractToken<T> getFlyweightToken(T t, String string) {
        assert (string.length() <= this.readLength());
        if (LOG.isLoggable(Level.FINE)) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == this.readExistingAtIndex(i)) continue;
                throw new IllegalArgumentException("Flyweight text in TokenFactory.getFlyweightToken(" + t + ", \"" + CharSequenceUtilities.debugText((CharSequence)string) + "\") " + "differs from recognized text: '" + CharSequenceUtilities.debugChar((char)this.readExisting(i)) + "' != '" + CharSequenceUtilities.debugChar((char)string.charAt(i)) + "' at index=" + i);
            }
        }
        this.logTokenContent("getFlyweightToken", t, string.length());
        this.assignTokenLength(string.length());
        AbstractToken<T> abstractToken = this.checkSkipToken(t);
        if (abstractToken == null) {
            if (this.isFlyTokenAllowed()) {
                abstractToken = this.innerLanguageOperation.getFlyweightToken(t, string);
                ++this.flyTokenSequenceLength;
            } else {
                abstractToken = this.createDefaultTokenInstance(t);
                this.fillTokenData(abstractToken);
                this.flyTokenSequenceLength = 0;
            }
        }
        return abstractToken;
    }

    private AbstractToken<T> checkSkipToken(T t) {
        if (this.isSkipTokenId(t)) {
            this.flyTokenSequenceLength = 5;
            return this.skipToken();
        }
        return null;
    }

    public AbstractToken<T> createToken(T t, int n) {
        this.logTokenContent("createToken", t, n);
        this.assignTokenLength(n);
        AbstractToken<T> abstractToken = this.checkSkipToken(t);
        if (abstractToken == null) {
            abstractToken = this.createDefaultTokenInstance(t);
            this.fillTokenData(abstractToken);
            this.flyTokenSequenceLength = 0;
        }
        return abstractToken;
    }

    private void logTokenContent(String string, T t, int n) {
        if (LexerInputLOG.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("TokenFactory.").append(string).append("(");
            stringBuilder.append(t).append(", ").append(n);
            stringBuilder.append("): \"");
            for (int i = 0; i < n; ++i) {
                CharSequenceUtilities.debugChar((StringBuilder)stringBuilder, (char)this.readExistingAtIndex(i));
            }
            stringBuilder.append("\"\n");
            LexerInputLOG.fine(stringBuilder.toString());
        }
    }

    protected AbstractToken<T> createDefaultTokenInstance(T t) {
        return new DefaultToken<T>(t, this.tokenLength);
    }

    public AbstractToken<T> createToken(T t, int n, PartType partType) {
        if (partType == null) {
            throw new IllegalArgumentException("partType must be non-null");
        }
        if (partType == PartType.COMPLETE) {
            return this.createToken(t, n);
        }
        return this.createPropertyToken(t, n, null, partType);
    }

    public AbstractToken<T> createPropertyToken(T t, int n, TokenPropertyProvider<T> tokenPropertyProvider, PartType partType) {
        if (partType == null) {
            partType = PartType.COMPLETE;
        }
        this.logTokenContent("createPropertyToken", t, n);
        this.assignTokenLength(n);
        AbstractToken<T> abstractToken = this.checkSkipToken(t);
        if (abstractToken == null) {
            abstractToken = this.createPropertyTokenInstance(t, tokenPropertyProvider, partType);
            this.fillTokenData(abstractToken);
            this.flyTokenSequenceLength = 0;
        }
        return abstractToken;
    }

    protected AbstractToken<T> createPropertyTokenInstance(T t, TokenPropertyProvider<T> tokenPropertyProvider, PartType partType) {
        return new PropertyToken<T>(t, this.tokenLength, tokenPropertyProvider, partType);
    }

    public AbstractToken<T> createCustomTextToken(T t, int n, CharSequence charSequence) {
        this.logTokenContent("createCustomTextToken", t, n);
        this.assignTokenLength(n);
        AbstractToken<T> abstractToken = this.checkSkipToken(t);
        if (abstractToken == null) {
            abstractToken = this.createCustomTextTokenInstance(t, charSequence);
            this.fillTokenData(abstractToken);
            this.flyTokenSequenceLength = 0;
        }
        return abstractToken;
    }

    protected AbstractToken<T> createCustomTextTokenInstance(T t, CharSequence charSequence) {
        return new CustomTextToken<T>(t, charSequence, this.tokenLength);
    }

    public boolean isSkipTokenId(T t) {
        Set<T> set = this.tokenList.skipTokenIds();
        return set != null && set.contains(t);
    }

    protected final int tokenLength() {
        return this.tokenLength;
    }

    public void assignTokenLength(int n) {
        if (n > this.readLength()) {
            throw new IndexOutOfBoundsException("tokenLength=" + n + " >" + this.readLength());
        }
        this.tokenLength = n;
    }

    public final Object lexerState() {
        return this.lexer.state();
    }

    protected boolean isFlyTokenAllowed() {
        return this.flyTokenSequenceLength < 5;
    }

    public final boolean isSkipToken(AbstractToken<T> abstractToken) {
        return abstractToken == LexerUtilsConstants.SKIP_TOKEN;
    }

    public final AbstractToken<T> skipToken() {
        return LexerUtilsConstants.SKIP_TOKEN;
    }

    public final void release() {
        if (this.lexer != null) {
            this.lexer.release();
            this.lexer = null;
        }
    }

    private void checkLexerInputFinished() {
        if (this.read() != -1 || this.readLength() > 0) {
            StringBuilder stringBuilder = new StringBuilder(100);
            int n = this.readLength();
            stringBuilder.append("Lexer ").append(this.lexer);
            stringBuilder.append("\n  returned null token but lexerInput.readLength()=");
            stringBuilder.append(n);
            stringBuilder.append("\n  lexer-state: ").append(this.lexer.state());
            stringBuilder.append("\n  ").append(this);
            stringBuilder.append("\n  Chars: \"");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(CharSequenceUtilities.debugChar((char)this.readExistingAtIndex(i)));
            }
            stringBuilder.append("\" - these characters need to be tokenized.");
            stringBuilder.append("\nFix the lexer to not return null token in this state.");
            throw new IllegalStateException(stringBuilder.toString());
        }
    }

    public String toString() {
        return "tokenStartOffset=" + this.tokenStartOffset + ", readOffset=" + this.readOffset + ", lookaheadOffset=" + this.lookaheadOffset;
    }
}

