/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.glassfish.common.EnableComet;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InstanceCustomizer
extends JPanel {
    private GlassfishModule commonSupport;
    private boolean cometEnabledChanged = false;
    private boolean monitorEnabledChanged = false;
    private boolean jdbcDriverDeployEnabledChanged = false;
    private boolean sessionEnabledChanged = false;
    private boolean startDerbyChanged = false;
    private JCheckBox cometCheckBox;
    private JCheckBox enableSessionsCheckBox;
    private JCheckBox jdbcDriverDeployCheckBox;
    private JLabel labelDomainName;
    private JLabel labelDomainsFolder;
    private JLabel labelLocation;
    private JCheckBox monitorCheckBox;
    private JCheckBox startDerby;
    private JTextField textDomainName;
    private JTextField textDomainsFolder;
    private JTextField textLocation;

    public InstanceCustomizer(GlassfishModule glassfishModule) {
        this.commonSupport = glassfishModule;
        this.initComponents();
    }

    private void initFields() {
        Map<String, String> map = this.commonSupport.getInstanceProperties();
        this.textLocation.setText(map.get("host") + ":" + map.get("httpportnumber"));
        this.textDomainsFolder.setText(map.get("domainsfolder"));
        this.textDomainName.setText(map.get("domainname"));
        String string = map.get("v3.grizzly.cometSupport");
        if (string == null) {
            string = System.getProperty("v3.grizzly.cometSupport");
        }
        boolean bl = Boolean.parseBoolean(string);
        this.cometCheckBox.setSelected(bl);
        String string2 = map.get("httpMonitorOn");
        boolean bl2 = Boolean.parseBoolean(string2);
        this.monitorCheckBox.setSelected(bl2);
        String string3 = map.get("driverDeployOn");
        boolean bl3 = Boolean.parseBoolean(string3);
        this.jdbcDriverDeployCheckBox.setSelected(bl3);
        String string4 = map.get("preserveSessionsOn");
        boolean bl4 = Boolean.parseBoolean(string4);
        this.enableSessionsCheckBox.setSelected(bl4);
        String string5 = map.get("derbyStartOn");
        boolean bl5 = Boolean.parseBoolean(string5);
        this.startDerby.setSelected(bl5);
        boolean bl6 = map.get("domainsfolder") != null;
        this.cometCheckBox.setEnabled(bl6);
        this.monitorCheckBox.setEnabled(bl6);
        this.jdbcDriverDeployCheckBox.setEnabled(bl6);
        this.startDerby.setEnabled(bl6);
    }

    private void persistFields() {
        String string;
        if (this.cometEnabledChanged) {
            string = Boolean.toString(this.cometCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("v3.grizzly.cometSupport", string, true);
            RequestProcessor.getDefault().post((Runnable)new EnableComet(this.commonSupport));
        }
        if (this.monitorEnabledChanged) {
            string = Boolean.toString(this.monitorCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("httpMonitorOn", string, true);
        }
        if (this.jdbcDriverDeployEnabledChanged) {
            string = Boolean.toString(this.jdbcDriverDeployCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("driverDeployOn", string, true);
        }
        if (this.sessionEnabledChanged) {
            string = Boolean.toString(this.enableSessionsCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("preserveSessionsOn", string, true);
        }
        if (this.startDerbyChanged) {
            string = Boolean.toString(this.startDerby.isSelected());
            this.commonSupport.setEnvironmentProperty("derbyStartOn", string, true);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.labelLocation = new JLabel();
        this.textLocation = new JTextField();
        this.labelDomainsFolder = new JLabel();
        this.textDomainsFolder = new JTextField();
        this.labelDomainName = new JLabel();
        this.textDomainName = new JTextField();
        this.cometCheckBox = new JCheckBox();
        this.monitorCheckBox = new JCheckBox();
        this.jdbcDriverDeployCheckBox = new JCheckBox();
        this.enableSessionsCheckBox = new JCheckBox();
        this.startDerby = new JCheckBox();
        this.setName(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_Common"));
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_Location"));
        this.textLocation.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.labelDomainsFolder, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_DomainsFolder"));
        this.textDomainsFolder.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.labelDomainName, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_DomainName"));
        this.textDomainName.setEditable(false);
        this.cometCheckBox.setText(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableCometSupport"));
        this.cometCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceCustomizer.this.cometCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.monitorCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableHttpMonitor"));
        this.monitorCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceCustomizer.this.monitorCheckBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jdbcDriverDeployCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableJDBCDiverDeployment"));
        this.jdbcDriverDeployCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceCustomizer.this.jdbcDriverDeployCheckBoxActionPerformed(actionEvent);
            }
        });
        this.enableSessionsCheckBox.setText(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_PreserverSessions"));
        this.enableSessionsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceCustomizer.this.enableSessionsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.startDerby.setText(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_START_DERBY"));
        this.startDerby.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstanceCustomizer.this.startDerby(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.startDerby).add((Component)this.jdbcDriverDeployCheckBox).add((Component)this.monitorCheckBox).add((Component)this.cometCheckBox, -1, 392, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.labelLocation).add((Component)this.labelDomainsFolder).add((Component)this.labelDomainName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.textLocation, -1, 291, Short.MAX_VALUE).add((Component)this.textDomainsFolder, -1, 291, Short.MAX_VALUE).add((Component)this.textDomainName, -1, 291, Short.MAX_VALUE))).add((Component)this.enableSessionsCheckBox)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelLocation).add((Component)this.textLocation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelDomainsFolder).add((Component)this.textDomainsFolder, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelDomainName).add((Component)this.textDomainName, -2, -1, -2)).addPreferredGap(1).add((Component)this.cometCheckBox).addPreferredGap(0).add((Component)this.monitorCheckBox).addPreferredGap(0).add((Component)this.jdbcDriverDeployCheckBox).addPreferredGap(0).add((Component)this.enableSessionsCheckBox).addPreferredGap(0).add((Component)this.startDerby).addContainerGap(13, Short.MAX_VALUE)));
    }

    private void cometCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.cometEnabledChanged = true;
    }

    private void monitorCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.monitorEnabledChanged = true;
        if (this.monitorCheckBox.isSelected()) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(this.getClass(), (String)"TXT_WARNING_HTTP_MONITOR_ON"), NbBundle.getMessage(this.getClass(), (String)"TITLE_WARNING_HTTP_MONITOR_ON"), -1, 2, null, null);
            if (DialogDisplayer.getDefault().notify(notifyDescriptor).equals(NotifyDescriptor.CANCEL_OPTION)) {
                this.monitorCheckBox.setSelected(false);
                this.monitorEnabledChanged = false;
            }
        } else {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(this.getClass(), (String)"TXT_WARNING_HTTP_MONITOR_OFF"), NbBundle.getMessage(this.getClass(), (String)"TITLE_WARNING_HTTP_MONITOR_OFF"), -1, 2, null, null);
            if (DialogDisplayer.getDefault().notify(notifyDescriptor).equals(NotifyDescriptor.CANCEL_OPTION)) {
                this.monitorCheckBox.setSelected(true);
                this.monitorEnabledChanged = false;
            }
        }
    }

    private void jdbcDriverDeployCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jdbcDriverDeployEnabledChanged = true;
    }

    private void enableSessionsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.sessionEnabledChanged = true;
    }

    private void startDerby(ActionEvent actionEvent) {
        this.startDerbyChanged = true;
    }
}

