/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.RegisteredDDCatalog;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlassfishInstanceProvider
implements ServerInstanceProvider {
    static final String INSTANCE_FO_ATTR = "InstanceFOPath";
    private static volatile GlassfishInstanceProvider preludeProvider;
    private static volatile GlassfishInstanceProvider ee6Provider;
    private static String EE6_PROP_ROOT;
    private static String INSTALL_ROOT_SUFFIX;
    private static String EE6_INSTALL_ROOT_PROP;
    private static String PRELUDE_PROP_ROOT;
    private static String PRELUDE_INSTALL_ROOT_PROP;
    private static String ENABLE_EXPERIMENTAL_SUFFIX;
    private static String DISABLE_PRELUDE_SUFFIX;
    private static String EE6_DEPLOYER_FRAGMENT;
    private static String PRELUDE_DEPLOYER_FRAGMENT;
    private static String EE6_INSTANCES_PATH;
    private static String PRELUDE_INSTANCES_PATH;
    public static String PRELUDE_DEFAULT_NAME;
    public static final Set<String> activeRegistrationSet;
    private final Map<String, GlassfishInstance> instanceMap = Collections.synchronizedMap(new HashMap());
    private static final Set<String> activeDisplayNames;
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private String[] instancesDirNames;
    private String displayName;
    private String[] uriFragments;
    private String installRootPropName;
    private String defaultDomainName;
    private String defaultPersonalDomainName;
    private String defaultInstallName;
    private String directDownloadUrl;
    private String indirectDownloadUrl;
    private String installRootKey;
    private String[] requiredFiles;
    private String[] excludedFiles;
    private boolean needsJdk6;
    private String[] javadocFilenames;
    private List noPasswordOptions;
    private CommandFactory cf;

    public static List<GlassfishInstanceProvider> getProviders(boolean bl) {
        ArrayList<GlassfishInstanceProvider> arrayList = new ArrayList<GlassfishInstanceProvider>();
        if (bl) {
            GlassfishInstanceProvider.getPrelude();
            GlassfishInstanceProvider.getEe6();
        }
        if (preludeProvider != null) {
            arrayList.add(preludeProvider);
        }
        if (ee6Provider != null) {
            arrayList.add(ee6Provider);
        }
        return arrayList;
    }

    public static synchronized GlassfishInstanceProvider getEe6() {
        if (ee6Provider == null) {
            ee6Provider = new GlassfishInstanceProvider(new String[]{EE6_DEPLOYER_FRAGMENT}, new String[]{EE6_INSTANCES_PATH}, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_SERVER_NAME", (Object[])new Object[0]), EE6_INSTALL_ROOT_PROP, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_AUTO_REGISTERED_NAME", (Object[])new Object[0]), NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_AUTO_CREATED_NAME", (Object[])new Object[0]), "GlassFish_v3", "http://java.net/download/glassfish/v3/promoted/latest-glassfish.zip", "http://serverplugins.netbeans.org/glassfishv3/v3fcszipfilename.txt", "last-v3ee6-install-root", new String[]{"lib" + File.separator + "schemas" + File.separator + "web-app_3_0.xsd"}, new String[0], true, new String[]{"docs/javaee6-doc-api.zip"}, new String[]{"--nopassword"}, new CommandFactory(){

                public ServerCommand.SetPropertyCommand getSetPropertyCommand(String string, String string2) {
                    return new ServerCommand.SetPropertyCommand(string, string2, "DEFAULT={0}={1}");
                }
            });
            ee6Provider.init();
        }
        return ee6Provider;
    }

    public static synchronized GlassfishInstanceProvider getPrelude() {
        String[] stringArray = new String[]{PRELUDE_DEPLOYER_FRAGMENT};
        String[] stringArray2 = new String[]{PRELUDE_INSTANCES_PATH};
        if (preludeProvider == null) {
            preludeProvider = new GlassfishInstanceProvider(stringArray, stringArray2, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_SERVER_NAME", (Object[])new Object[0]), PRELUDE_PROP_ROOT + INSTALL_ROOT_SUFFIX, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_AUTO_REGISTERED_NAME", (Object[])new Object[0]), NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_AUTO_CREATED_NAME", (Object[])new Object[0]), PRELUDE_DEFAULT_NAME, "http://java.net/download/glassfish/v3-prelude/release/glassfish-v3-prelude-ml.zip", "http://serverplugins.netbeans.org/glassfishv3/preludezipfilename.txt", "last-install-root", new String[0], new String[]{"lib" + File.separator + "schemas" + File.separator + "web-app_3_0.xsd"}, false, new String[]{"docs/javaee6-doc-api.zip"}, null, new CommandFactory(){

                public ServerCommand.SetPropertyCommand getSetPropertyCommand(String string, String string2) {
                    return new ServerCommand.SetPropertyCommand(string, string2, "target={0}&value={1}");
                }
            });
            preludeProvider.init();
        }
        return preludeProvider;
    }

    private GlassfishInstanceProvider(String[] stringArray, String[] stringArray2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String[] stringArray3, String[] stringArray4, boolean bl, String[] stringArray5, String[] stringArray6, CommandFactory commandFactory) {
        this.instancesDirNames = stringArray2;
        this.displayName = string;
        this.uriFragments = stringArray;
        this.installRootPropName = string2;
        this.defaultDomainName = string3;
        this.defaultPersonalDomainName = string4;
        this.defaultInstallName = string5;
        this.directDownloadUrl = string6;
        this.indirectDownloadUrl = string7;
        this.installRootKey = string8;
        this.requiredFiles = stringArray3;
        this.excludedFiles = stringArray4;
        this.needsJdk6 = bl;
        this.javadocFilenames = stringArray5;
        this.noPasswordOptions = new ArrayList();
        if (null != stringArray6) {
            this.noPasswordOptions.addAll(Arrays.asList(stringArray6));
        }
        this.cf = commandFactory;
    }

    public static synchronized boolean initialized() {
        return preludeProvider != null || ee6Provider != null;
    }

    public static Logger getLogger() {
        return Logger.getLogger("glassfish");
    }

    private static RegisteredDDCatalog getDDCatalog() {
        return (RegisteredDDCatalog)Lookup.getDefault().lookup(RegisteredDDCatalog.class);
    }

    private static void refreshCatalogFromFirstInstance(GlassfishInstanceProvider glassfishInstanceProvider, RegisteredDDCatalog registeredDDCatalog) {
        GlassfishInstance glassfishInstance = glassfishInstanceProvider.getFirstServerInstance();
        if (null != glassfishInstance) {
            registeredDDCatalog.refreshRunTimeDDCatalog(glassfishInstanceProvider, glassfishInstance.getGlassfishRoot());
        }
    }

    public String[] getAssociatedJavaDoc() {
        return (String[])this.javadocFilenames.clone();
    }

    private GlassfishInstance getFirstServerInstance() {
        if (!this.instanceMap.isEmpty()) {
            return this.instanceMap.values().iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerInstance(GlassfishInstance glassfishInstance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                RegisteredDDCatalog registeredDDCatalog;
                this.instanceMap.put(glassfishInstance.getDeployerUri(), glassfishInstance);
                activeDisplayNames.add(glassfishInstance.getDisplayName());
                if (this.instanceMap.size() == 1 && null != (registeredDDCatalog = GlassfishInstanceProvider.getDDCatalog())) {
                    registeredDDCatalog.refreshRunTimeDDCatalog(this, glassfishInstance.getGlassfishRoot());
                }
                this.writeInstanceToFile(glassfishInstance);
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
        this.support.fireChange();
    }

    public String getDefaultInstallName() {
        return this.defaultInstallName;
    }

    public String getDirectDownloadUrl() {
        return this.directDownloadUrl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIndirectDownloadUrl() {
        return this.indirectDownloadUrl;
    }

    public String getInstallRootKey() {
        return this.installRootKey;
    }

    public String getInstallRootProperty() {
        return this.installRootPropName;
    }

    public String[] getRequiredFiles() {
        return (String[])this.requiredFiles.clone();
    }

    public String[] getExcludedFiles() {
        return (String[])this.excludedFiles.clone();
    }

    public String getNameOfBits() {
        return this.displayName;
    }

    public String getUriFragment() {
        return this.uriFragments[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerInstance(GlassfishInstance glassfishInstance) {
        boolean bl = false;
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.remove(glassfishInstance.getDeployerUri()) != null) {
                RegisteredDDCatalog registeredDDCatalog;
                bl = true;
                this.removeInstanceFromFile(glassfishInstance.getDeployerUri());
                activeDisplayNames.remove(glassfishInstance.getDisplayName());
                if (this.instanceMap.size() == 0 && null != (registeredDDCatalog = GlassfishInstanceProvider.getDDCatalog())) {
                    registeredDDCatalog.refreshRunTimeDDCatalog(this, null);
                }
            }
        }
        if (bl) {
            this.support.fireChange();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookupFor(ServerInstance serverInstance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                if (!glassfishInstance.getCommonInstance().equals(serverInstance)) continue;
                return glassfishInstance.getLookup();
            }
            return null;
        }
    }

    public ServerInstanceImplementation getInternalInstance(String string) {
        return this.instanceMap.get(string);
    }

    public <T> T getInstanceByCapability(String string, Class<T> clazz) {
        Object object = null;
        GlassfishInstance glassfishInstance = this.instanceMap.get(string);
        if (glassfishInstance != null) {
            object = glassfishInstance.getLookup().lookup(clazz);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getInstancesByCapability(Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                Object object = glassfishInstance.getLookup().lookup(clazz);
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                arrayList.add(glassfishInstance.getCommonInstance());
            }
        }
        return arrayList;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.support.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.support.removeChangeListener(changeListener);
    }

    public boolean hasServer(String string) {
        return this.getInstance(string) != null;
    }

    public ServerInstance getInstance(String string) {
        GlassfishInstance glassfishInstance = this.instanceMap.get(string);
        return glassfishInstance == null ? null : glassfishInstance.getCommonInstance();
    }

    public String formatUri(String string, String string2, int n) {
        return "[" + string + "]" + this.uriFragments[0] + ":" + string2 + ":" + n;
    }

    String getInstancesDirName() {
        return this.instancesDirNames[0];
    }

    Collection<GlassfishInstance> getInternalInstances() {
        return this.instanceMap.values();
    }

    boolean requiresJdk6OrHigher() {
        return this.needsJdk6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                this.loadServerInstances();
                this.registerDefaultInstance();
            }
            catch (RuntimeException runtimeException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, runtimeException);
            }
            RegisteredDDCatalog registeredDDCatalog = GlassfishInstanceProvider.getDDCatalog();
            if (null != registeredDDCatalog) {
                if (this.equals(preludeProvider)) {
                    registeredDDCatalog.registerPreludeRunTimeDDCatalog(this);
                } else {
                    registeredDDCatalog.registerEE6RunTimeDDCatalog(this);
                }
                GlassfishInstanceProvider.refreshCatalogFromFirstInstance(this, registeredDDCatalog);
            }
        }
    }

    private void loadServerInstances() {
        for (int i = 0; i < this.instancesDirNames.length; ++i) {
            FileObject[] fileObjectArray;
            FileObject object = this.getRepositoryDir(this.instancesDirNames[i], false);
            if (object == null || (fileObjectArray = object.getChildren()) == null || fileObjectArray.length <= 0) continue;
            for (int j = 0; j < fileObjectArray.length; ++j) {
                try {
                    GlassfishInstance glassfishInstance = this.readInstanceFromFile(fileObjectArray[j], this.uriFragments[i]);
                    if (glassfishInstance != null) {
                        this.instanceMap.put(glassfishInstance.getDeployerUri(), glassfishInstance);
                        activeDisplayNames.add(glassfishInstance.getDisplayName());
                        continue;
                    }
                    GlassfishInstanceProvider.getLogger().finer("Unable to create glassfish instance for " + fileObjectArray[j].getPath());
                    continue;
                }
                catch (IOException iOException) {
                    GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
                }
            }
        }
        for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
            glassfishInstance.updateModuleSupport();
        }
    }

    private GlassfishInstance readInstanceFromFile(FileObject fileObject, String string) throws IOException {
        GlassfishInstance glassfishInstance = null;
        String string2 = GlassfishInstanceProvider.getStringAttribute(fileObject, "installfolder");
        String string3 = GlassfishInstanceProvider.getStringAttribute(fileObject, "homefolder");
        if (string2 == null) {
            string2 = string3;
        }
        if (GlassfishInstanceProvider.isValidHomeFolder(string2) && GlassfishInstanceProvider.isValidGlassfishFolder(string3)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration enumeration = fileObject.getAttributes();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = GlassfishInstanceProvider.getStringAttribute(fileObject, string4);
                hashMap.put(string4, string5);
            }
            hashMap.put(INSTANCE_FO_ATTR, fileObject.getName());
            glassfishInstance = GlassfishInstance.create(hashMap, this, false);
        } else {
            GlassfishInstanceProvider.getLogger().finer("GlassFish folder " + fileObject.getPath() + " is not a valid install.");
            fileObject.delete();
        }
        return glassfishInstance;
    }

    private void writeInstanceToFile(GlassfishInstance glassfishInstance) throws IOException {
        String string = glassfishInstance.getGlassfishRoot();
        if (string == null) {
            GlassfishInstanceProvider.getLogger().log(Level.SEVERE, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"MSG_NullServerFolder"));
            return;
        }
        String string2 = glassfishInstance.getDeployerUri();
        FileObject fileObject = this.getRepositoryDir(this.instancesDirNames[0], true);
        FileObject[] fileObjectArray = fileObject.getChildren();
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!string2.equals(fileObjectArray[i].getAttribute("url"))) continue;
            fileObject2 = fileObjectArray[i];
        }
        if (fileObject2 == null) {
            String string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"instance", null);
            fileObject2 = fileObject.createData(string3);
        }
        CommonServerSupport commonServerSupport = glassfishInstance.getCommonSupport();
        Map<String, String> map = commonServerSupport.getInstanceProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string4 = entry.getKey();
            if (GlassfishInstanceProvider.filterKey(string4)) continue;
            fileObject2.setAttribute(string4, (Object)entry.getValue());
        }
        commonServerSupport.setProperty(INSTANCE_FO_ATTR, fileObject2.getName());
        commonServerSupport.setFileObject(fileObject2);
    }

    private static boolean filterKey(String string) {
        return INSTANCE_FO_ATTR.equals(string);
    }

    private void removeInstanceFromFile(String string) {
        FileObject fileObject = this.getInstanceFileObject(string);
        if (fileObject != null && fileObject.isValid()) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
    }

    private FileObject getInstanceFileObject(String string) {
        for (String string2 : this.instancesDirNames) {
            FileObject fileObject = this.getRepositoryDir(string2, false);
            if (fileObject == null) continue;
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string3 = GlassfishInstanceProvider.getStringAttribute(fileObjectArray[i], "url");
                if (string3 == null || !string3.equals(string)) continue;
                return fileObjectArray[i];
            }
        }
        return null;
    }

    private FileObject getRepositoryDir(String string, boolean bl) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject == null && bl) {
            try {
                fileObject = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)string);
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
        return fileObject;
    }

    private static boolean isValidHomeFolder(String string) {
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = file.exists();
            bl = bl && file.isDirectory();
            bl = bl && file.canRead();
        }
        return bl;
    }

    private static boolean isValidGlassfishFolder(String string) {
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = file.exists();
            bl = bl && file.isDirectory();
            bl = bl && file.canRead();
        }
        return bl;
    }

    private static String getStringAttribute(FileObject fileObject, String string) {
        return GlassfishInstanceProvider.getStringAttribute(fileObject, string, null);
    }

    private static String getStringAttribute(FileObject fileObject, String string, String string2) {
        String string3 = string2;
        Object object = fileObject.getAttribute(string);
        if (object instanceof String) {
            string3 = (String)object;
        }
        return string3;
    }

    private static int getIntAttribute(FileObject fileObject, String string, int n) {
        int n2 = n;
        String string2 = GlassfishInstanceProvider.getStringAttribute(fileObject, string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                GlassfishInstanceProvider.getLogger().log(Level.FINER, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
        }
        return n2;
    }

    private void registerDefaultInstance() {
        String string;
        String string2 = System.getProperty(this.installRootPropName);
        if (null == string2) {
            return;
        }
        if (GlassfishInstanceProvider.isValidHomeFolder(string2 = new File(string2).getAbsolutePath())) {
            string = string2 + File.separator + "glassfish";
            if (!GlassfishInstanceProvider.isValidGlassfishFolder(string)) {
                string = string2;
                if (!GlassfishInstanceProvider.isValidHomeFolder(string2 = new File(string).getParentFile().getAbsolutePath()) || !GlassfishInstanceProvider.isValidGlassfishFolder(string)) {
                    GlassfishInstanceProvider.getLogger().log(Level.INFO, "Invalid value set for installRoot: " + System.getProperty(this.installRootPropName));
                    return;
                }
                GlassfishInstanceProvider.getLogger().log(Level.INFO, "Fixed incorrect value set for installRoot: " + System.getProperty(this.installRootPropName));
            }
        } else {
            GlassfishInstanceProvider.getLogger().log(Level.INFO, "Invalid installRoot: " + System.getProperty(this.installRootPropName));
            return;
        }
        string = NbPreferences.forModule(this.getClass()).get("first_run" + this.getInstallRootKey(), "false");
        if ("false".equals(string)) {
            string = NbPreferences.forModule(this.getClass()).get("first_run", "false");
        }
        boolean bl = GlassfishInstanceProvider.computeNeedToRegister(string, string2, this.getInstallRoots());
        if ("true".equals(string) && !bl && null != string2) {
            NbPreferences.forModule(this.getClass()).put("first_run" + this.getInstallRootKey(), new File(string2).getAbsolutePath());
        }
        if (bl) {
            try {
                NbPreferences.forModule(this.getClass()).put("first_run" + this.getInstallRootKey(), new File(string2).getAbsolutePath());
                if (null != string2) {
                    File file = new File(string2);
                    if (GlassfishInstanceProvider.isValidHomeFolder(string2) && file.exists()) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("installfolder", file.getCanonicalPath());
                        hashMap.put("homefolder", file.getCanonicalPath() + File.separator + "glassfish");
                        if (Utils.canWrite(file)) {
                            String string3 = this.getUniqueName(this.defaultDomainName);
                            hashMap.put("displayName", string3);
                            hashMap.put("httpportnumber", Integer.toString(8080));
                            hashMap.put("adminPort", Integer.toString(4848));
                            hashMap.put("domainsfolder", (String)hashMap.get("homefolder") + File.separator + "domains");
                            hashMap.put("domainname", "domain1");
                            GlassfishInstance glassfishInstance = GlassfishInstance.create(hashMap, this);
                        } else {
                            hashMap.put("displayName", this.defaultPersonalDomainName);
                            String string4 = System.getProperty("netbeans.user");
                            String string5 = this.defaultInstallName;
                            hashMap.put("domainsfolder", string4);
                            hashMap.put("domainname", string5);
                            CreateDomain createDomain = new CreateDomain("anonymous", "", new File(file, "glassfish"), hashMap, this, true);
                            createDomain.start();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                NbPreferences.forModule(this.getClass()).put("first_run" + this.getInstallRootKey(), "false");
                GlassfishInstanceProvider.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    String[] getNoPasswordCreatDomainCommand(String string, String string2, String string3, String string4, String string5, String string6) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(string, "-client", "-jar", string2, "create-domain", "--user", string5, "--domaindir", string3, "--portbase", string4));
        if (this.noPasswordOptions.size() > 0) {
            arrayList.addAll(this.noPasswordOptions);
        }
        arrayList.add(string6);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static boolean computeNeedToRegister(String string, String string2, Collection<String> collection) {
        boolean bl;
        if ("false".equals(string)) {
            bl = true;
        } else if ("true".equals(string)) {
            if (null != string2) {
                bl = true;
                for (String string3 : collection) {
                    if (!string2.equals(string3)) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
        } else {
            bl = !string.equals(string2);
        }
        return bl;
    }

    private Collection<String> getInstallRoots() {
        HashSet<String> hashSet = new HashSet<String>();
        for (GlassfishInstance glassfishInstance : this.getInternalInstances()) {
            hashSet.add(glassfishInstance.getInstallRoot());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueName(String string) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            String string2 = string;
            int n = 1;
            while (activeDisplayNames.contains(string2)) {
                string2 = string + " " + n++;
            }
            return string2;
        }
    }

    CommandFactory getCommandFactory() {
        return this.cf;
    }

    static {
        EE6_PROP_ROOT = "org.glassfish.v3ee6.";
        INSTALL_ROOT_SUFFIX = "installRoot";
        EE6_INSTALL_ROOT_PROP = EE6_PROP_ROOT + INSTALL_ROOT_SUFFIX;
        PRELUDE_PROP_ROOT = "org.glassfish.v3.";
        PRELUDE_INSTALL_ROOT_PROP = PRELUDE_PROP_ROOT + INSTALL_ROOT_SUFFIX;
        ENABLE_EXPERIMENTAL_SUFFIX = "enableExperimentalFeatures";
        DISABLE_PRELUDE_SUFFIX = "disablePreludeSupport";
        EE6_DEPLOYER_FRAGMENT = "deployer:gfv3ee6";
        PRELUDE_DEPLOYER_FRAGMENT = "deployer:gfv3";
        EE6_INSTANCES_PATH = "/GlassFishEE6/Instances";
        PRELUDE_INSTANCES_PATH = "/GlassFish/Instances";
        PRELUDE_DEFAULT_NAME = "GlassFish_v3_Prelude";
        activeRegistrationSet = Collections.synchronizedSet(new HashSet());
        activeDisplayNames = Collections.synchronizedSet(new HashSet());
    }
}

