/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.Commands;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.RestartTask;
import org.netbeans.modules.glassfish.common.StartTask;
import org.netbeans.modules.glassfish.common.StopTask;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonServerSupport
implements GlassfishModule,
RefreshModulesCookie {
    private final transient Lookup lookup;
    private final Map<String, String> properties = Collections.synchronizedMap(new HashMap(37));
    private volatile GlassfishModule.ServerState serverState = GlassfishModule.ServerState.STOPPED;
    private final Object stateMonitor = new Object();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject instanceFO;
    private volatile boolean startedByIde = false;
    private transient boolean isRemote = false;
    private GlassfishInstanceProvider instanceProvider;
    private boolean stopDisabled = false;
    private final AtomicBoolean refreshRunning = new AtomicBoolean(false);

    CommonServerSupport(Lookup lookup, Map<String, String> map, GlassfishInstanceProvider glassfishInstanceProvider) {
        this.lookup = lookup;
        this.instanceProvider = glassfishInstanceProvider;
        this.isRemote = map.get("domainsfolder") == null;
        String string = CommonServerSupport.updateString(map, "host", "localhost");
        String string2 = CommonServerSupport.updateString(map, "homefolder", "");
        int n = CommonServerSupport.updateInt(map, "httpportnumber", 8080);
        CommonServerSupport.updateString(map, "displayName", "Bogus display name");
        int n2 = CommonServerSupport.updateInt(map, "adminPort", 4848);
        CommonServerSupport.updateString(map, "preserveSessionsOn", "true");
        CommonServerSupport.updateString(map, "derbyStartOn", this.isRemote ? "false" : "true");
        CommonServerSupport.updateString(map, "useIDEProxyOn", "true");
        CommonServerSupport.updateString(map, "driverDeployOn", "true");
        if (map.get("url") == null) {
            String string3 = glassfishInstanceProvider.formatUri(string2, string, n2);
            map.put("url", string3);
        }
        map.put("jvmMode", this.isRemote ? "debugMode" : "normalMode");
        this.properties.putAll(map);
        this.properties.put("username", "admin");
        this.properties.put("password", "adminadmin");
        this.instanceFO = this.getInstanceFileObject();
        this.refresh();
    }

    private static String updateString(Map<String, String> map, String string, String string2) {
        String string3 = map.get(string);
        if (string3 == null) {
            map.put(string, string2);
            string3 = string2;
        }
        return string3;
    }

    private static int updateInt(Map<String, String> map, String string, int n) {
        int n2;
        String string2 = map.get(string);
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            map.put(string, Integer.toString(n));
            n2 = n;
        }
        return n2;
    }

    private FileObject getInstanceFileObject() {
        String string;
        FileObject fileObject = FileUtil.getConfigFile((String)this.instanceProvider.getInstancesDirName());
        if (fileObject != null && (string = this.properties.get("InstanceFOPath")) != null) {
            return fileObject.getFileObject(string);
        }
        return null;
    }

    public String getInstallRoot() {
        return this.properties.get("installfolder");
    }

    public String getGlassfishRoot() {
        return this.properties.get("homefolder");
    }

    public String getDisplayName() {
        return this.properties.get("displayName");
    }

    public String getDeployerUri() {
        return this.properties.get("url");
    }

    public String getUserName() {
        return this.properties.get("username");
    }

    public String getPassword() {
        return this.properties.get("password");
    }

    public String getAdminPort() {
        return this.properties.get("adminPort");
    }

    public String getHttpPort() {
        return this.properties.get("httpportnumber");
    }

    public int getHttpPortNumber() {
        int n = -1;
        try {
            n = Integer.parseInt(this.properties.get("httpportnumber"));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish").log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
        }
        return n;
    }

    public int getAdminPortNumber() {
        int n = -1;
        try {
            n = Integer.parseInt(this.properties.get("adminPort"));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish").log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
        }
        return n;
    }

    public String getHostName() {
        return this.properties.get("host");
    }

    public String getDomainsRoot() {
        String string = this.properties.get("domainsfolder");
        return string;
    }

    public String getDomainName() {
        String string = this.properties.get("domainname");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerState(GlassfishModule.ServerState serverState) {
        boolean bl = false;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.serverState != serverState) {
                this.serverState = serverState;
                bl = true;
            }
        }
        if (bl) {
            this.changeSupport.fireChange();
        }
    }

    boolean isStartedByIde() {
        return this.startedByIde;
    }

    @Override
    public Map<String, String> getInstanceProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public GlassfishInstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener operationStateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"" + Thread.currentThread().getName() + "\"");
        StartOperationStateListener startOperationStateListener = new StartOperationStateListener(GlassfishModule.ServerState.RUNNING);
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, this.getRecognizers(), startOperationStateListener, operationStateListener));
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener operationStateListener, FileObject fileObject, String[] stringArray) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"" + Thread.currentThread().getName() + "\"");
        StartOperationStateListener startOperationStateListener = new StartOperationStateListener(GlassfishModule.ServerState.STOPPED_JVM_PROFILER);
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, this.getRecognizers(), fileObject, stringArray, startOperationStateListener, operationStateListener));
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    private List<Recognizer> getRecognizers() {
        List<Recognizer> list;
        Collection collection = this.lookup.lookupAll(RecognizerCookie.class);
        if (!collection.isEmpty()) {
            list = new LinkedList();
            for (RecognizerCookie recognizerCookie : collection) {
                list.addAll(recognizerCookie.getRecognizers());
            }
            list = Collections.unmodifiableList(list);
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public Future<GlassfishModule.OperationState> stopServer(OperationStateListener operationStateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.stopServer called on thread \"" + Thread.currentThread().getName() + "\"");
        OperationStateListener operationStateListener2 = new OperationStateListener(){

            public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                if (operationState == GlassfishModule.OperationState.RUNNING) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
                } else if (operationState == GlassfishModule.OperationState.COMPLETED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                } else if (operationState == GlassfishModule.OperationState.FAILED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                }
            }
        };
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new StopTask(this, operationStateListener2, operationStateListener));
        if (this.stopDisabled) {
            operationStateListener2.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            operationStateListener.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            return futureTask;
        }
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    @Override
    public Future<GlassfishModule.OperationState> restartServer(OperationStateListener operationStateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.restartServer called on thread \"" + Thread.currentThread().getName() + "\"");
        FutureTask<GlassfishModule.OperationState> futureTask = new FutureTask<GlassfishModule.OperationState>(new RestartTask(this, operationStateListener));
        RequestProcessor.getDefault().post(futureTask);
        return futureTask;
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener operationStateListener, File file, String string) {
        return this.deploy(operationStateListener, file, string, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener operationStateListener, File file, String string, String string2) {
        return this.deploy(operationStateListener, file, string, string2, (Map)null);
    }

    public Future<GlassfishModule.OperationState> deploy(OperationStateListener operationStateListener, File file, String string, String string2, Map map) {
        CommandRunner commandRunner = new CommandRunner(this.getCommandFactory(), this.getInstanceProperties(), operationStateListener);
        return commandRunner.deploy(file, string, string2, map);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener operationStateListener, String string) {
        return this.redeploy(operationStateListener, string, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener operationStateListener, String string, String string2) {
        CommandRunner commandRunner = new CommandRunner(this.getCommandFactory(), this.getInstanceProperties(), operationStateListener);
        return commandRunner.redeploy(string, string2);
    }

    @Override
    public Future<GlassfishModule.OperationState> undeploy(OperationStateListener operationStateListener, String string) {
        CommandRunner commandRunner = new CommandRunner(this.getCommandFactory(), this.getInstanceProperties(), operationStateListener);
        return commandRunner.undeploy(string);
    }

    @Override
    public Future<GlassfishModule.OperationState> execute(ServerCommand serverCommand) {
        CommandRunner commandRunner = new CommandRunner(this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        return commandRunner.execute(serverCommand);
    }

    @Override
    public AppDesc[] getModuleList(String string) {
        CommandRunner commandRunner = new CommandRunner(this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        int n = 0;
        Map<String, List<AppDesc>> map = commandRunner.getApplications(string);
        Collection<List<AppDesc>> collection = map.values();
        for (List<AppDesc> list : collection) {
            n += list.size();
        }
        AppDesc[] appDescArray = new AppDesc[n];
        int n2 = 0;
        for (List<AppDesc> list : collection) {
            for (AppDesc appDesc : list) {
                appDescArray[n2++] = appDesc;
            }
        }
        return appDescArray;
    }

    @Override
    public Map<String, ResourceDesc> getResourcesMap(String string) {
        CommandRunner commandRunner = new CommandRunner(this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        HashMap<String, ResourceDesc> hashMap = new HashMap<String, ResourceDesc>();
        List<ResourceDesc> list = commandRunner.getResources(string);
        for (ResourceDesc resourceDesc : list) {
            hashMap.put(resourceDesc.getName(), resourceDesc);
        }
        return hashMap;
    }

    @Override
    public GlassfishModule.ServerState getServerState() {
        return this.serverState;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setEnvironmentProperty(String string, String string2, boolean bl) {
        String string3 = null;
        Map<String, String> map = this.properties;
        synchronized (map) {
            string3 = this.properties.get(string);
            if (string3 == null || bl) {
                this.properties.put(string, string2);
                this.setInstanceAttr(string, string2);
                string3 = string2;
            }
        }
        return string3;
    }

    void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    void getProperty(String string) {
        this.properties.get(string);
    }

    void setInstanceAttr(String string, String string2) {
        if (this.instanceFO == null || !this.instanceFO.isValid()) {
            this.instanceFO = this.getInstanceFileObject();
        }
        if (this.instanceFO != null) {
            try {
                this.instanceFO.setAttribute(string, (Object)string2);
            }
            catch (IOException iOException) {
                Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute " + string + " for " + this.getDeployerUri(), iOException);
            }
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute " + string + " for " + this.getDeployerUri());
        }
    }

    void setFileObject(FileObject fileObject) {
        this.instanceFO = fileObject;
    }

    public static boolean isRunning(String string, int n) {
        if (null == string) {
            return false;
        }
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            Socket socket = new Socket();
            socket.connect(inetSocketAddress, 100);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isReallyRunning() {
        return CommonServerSupport.isRunning(this.getHostName(), this.getAdminPortNumber()) && this.isReady(false, 30, TimeUnit.SECONDS);
    }

    public boolean isReady(boolean bl, int n, TimeUnit timeUnit) {
        boolean bl2 = false;
        int n2 = bl ? 3 : 1;
        int n3 = 0;
        while (!bl2 && n3++ < n2) {
            if (n3 > 1) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger("glassfish").log(Level.INFO, null, interruptedException);
                }
            }
            long l = System.nanoTime();
            Commands.LocationCommand locationCommand = new Commands.LocationCommand();
            try {
                long l2;
                Future<GlassfishModule.OperationState> future = this.execute(locationCommand);
                if (future.get(n, timeUnit) == GlassfishModule.OperationState.COMPLETED) {
                    l2 = System.nanoTime();
                    Logger.getLogger("glassfish").log(Level.FINE, locationCommand.getCommand() + " responded in " + (l2 - l) / 1000000L + "ms");
                    String string = this.getDomainsRoot() + File.separator + this.getDomainName();
                    String string2 = locationCommand.getDomainRoot();
                    if (this.getDomainsRoot() != null && string2 != null) {
                        File file = FileUtil.normalizeFile((File)new File(string));
                        File file2 = FileUtil.normalizeFile((File)new File(string2));
                        bl2 = file.equals(file2);
                        break;
                    }
                    boolean bl3 = bl2 = null != string2;
                    if (!bl2) break;
                    this.updateHttpPort();
                    break;
                }
                if (!locationCommand.retry()) {
                    future = this.execute(new Commands.VersionCommand());
                    bl2 = future.get(n, timeUnit) == GlassfishModule.OperationState.COMPLETED;
                    break;
                }
                l2 = System.nanoTime();
                Logger.getLogger("glassfish").log(Level.FINE, locationCommand.getCommand() + " timed out inside server after " + (l2 - l) / 1000000L + "ms");
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.INFO, locationCommand.getCommand() + " timed out.", exception);
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    private static Future<GlassfishModule.OperationState> failedOperation() {
        return new Future<GlassfishModule.OperationState>(){

            @Override
            public boolean cancel(boolean bl) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public GlassfishModule.OperationState get() throws InterruptedException, ExecutionException {
                return GlassfishModule.OperationState.FAILED;
            }

            @Override
            public GlassfishModule.OperationState get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return GlassfishModule.OperationState.FAILED;
            }
        };
    }

    private static Future<GlassfishModule.OperationState> successfulOperation() {
        return new Future<GlassfishModule.OperationState>(){

            @Override
            public boolean cancel(boolean bl) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public GlassfishModule.OperationState get() throws InterruptedException, ExecutionException {
                return GlassfishModule.OperationState.COMPLETED;
            }

            @Override
            public GlassfishModule.OperationState get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return GlassfishModule.OperationState.COMPLETED;
            }
        };
    }

    @Override
    public void refresh() {
        if (this.refreshRunning.compareAndSet(false, true)) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    boolean bl = CommonServerSupport.this.isReallyRunning();
                    GlassfishModule.ServerState serverState = CommonServerSupport.this.getServerState();
                    if (serverState == GlassfishModule.ServerState.STOPPED && bl) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                    } else if (serverState == GlassfishModule.ServerState.RUNNING && !bl) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                    } else if (serverState == GlassfishModule.ServerState.STOPPED_JVM_PROFILER && bl) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                    }
                    CommonServerSupport.this.refreshRunning.set(false);
                }
            });
        }
    }

    void disableStop() {
        this.stopDisabled = true;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.instanceProvider.getCommandFactory();
    }

    private void updateHttpPort() {
        ServerCommand.GetPropertyCommand getPropertyCommand = new ServerCommand.GetPropertyCommand("*.http-listener-1.port");
        Future<GlassfishModule.OperationState> future = this.execute(getPropertyCommand);
        try {
            if (future.get(10L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                Map<String, String> map = getPropertyCommand.getData();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getValue();
                    if (null == string || string.trim().length() <= 0) continue;
                    this.setEnvironmentProperty("httpportnumber", string, true);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, interruptedException);
        }
        catch (ExecutionException executionException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, executionException);
        }
        catch (TimeoutException timeoutException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, timeoutException);
        }
    }

    class StartOperationStateListener
    implements OperationStateListener {
        private GlassfishModule.ServerState endState;

        StartOperationStateListener(GlassfishModule.ServerState serverState) {
            this.endState = serverState;
        }

        public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
            if (operationState == GlassfishModule.OperationState.RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
            } else if (operationState == GlassfishModule.OperationState.COMPLETED) {
                CommonServerSupport.this.startedByIde = CommonServerSupport.this.isReady(false, 300, TimeUnit.MILLISECONDS);
                CommonServerSupport.this.setServerState(this.endState);
            } else if (operationState == GlassfishModule.OperationState.FAILED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
            }
        }
    }
}

