/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.openide.ErrorManager;

public class BugzillaIssueFinder
extends IssueFinder {
    private static final int[] EMPTY_INT_ARR = new int[0];

    public int[] getIssueSpans(CharSequence charSequence) {
        int[] nArray = BugzillaIssueFinder.findBoundaries(charSequence);
        return nArray != null ? nArray : EMPTY_INT_ARR;
    }

    public String getIssueId(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && Impl.isDigit(string.charAt(n)); --n) {
        }
        return string.substring(n + 1);
    }

    private static int[] findBoundaries(CharSequence charSequence) {
        try {
            return BugzillaIssueFinder.getImpl().findBoundaries(charSequence);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
            return null;
        }
    }

    private static Impl getImpl() {
        return new Impl();
    }

    static BugzillaIssueFinder getTestInstance() {
        return new BugzillaIssueFinder();
    }

    private static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        if (charSequence2.length() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if ((charSequence2.charAt(i) | 0x20) == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static final class Impl {
        private static final String[] BUGWORDS = new String[]{"bug", "issue"};
        private static final String BUG_NUMBER_PREFIX = "duplicate of";
        private static final String[] BUGNUM_PREFIX_PARTS = "duplicate of".split(" ");
        private static final String PUNCT_CHARS = ".,:;()[]{}";
        private static final int LOWER_A = 97;
        private static final int LOWER_Z = 122;
        private static final int INIT = 0;
        private static final int CHARS = 1;
        private static final int HASH = 2;
        private static final int HASH_SPC = 3;
        private static final int NUM = 4;
        private static final int BUGWORD = 5;
        private static final int BUGWORD_NL = 6;
        private static final int STAR = 7;
        private static final int GARBAGE = 8;
        private CharSequence str;
        private int pos;
        private int state;
        private int bugnumPrefixPartsProcessed;
        int startOfWord;
        int start;
        int end;
        int[] result;

        private Impl() {
        }

        private int[] findBoundaries(CharSequence charSequence) {
            this.reset();
            this.str = charSequence;
            this.pos = 0;
            while (this.pos < charSequence.length()) {
                this.handleChar(charSequence.charAt(this.pos));
                ++this.pos;
            }
            if (this.state == 4) {
                this.storeResult(this.start, this.pos);
            }
            return this.result;
        }

        private void reset() {
            this.str = null;
            this.pos = 0;
            this.state = 0;
            this.bugnumPrefixPartsProcessed = 0;
            this.startOfWord = -1;
            this.start = -1;
            this.end = -1;
            this.result = null;
        }

        private void handleChar(int n) {
            int n2;
            switch (this.state) {
                case 0: {
                    if (n == 35) {
                        this.rememberIsStart();
                        n2 = 2;
                        break;
                    }
                    if (Impl.isLetter(n)) {
                        this.rememberIsStart();
                        n2 = 1;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 1: {
                    if (Impl.isLetter(n)) {
                        n2 = 1;
                        break;
                    }
                    if (n == 32 || n == 9 || n == 13 || n == 10) {
                        if (this.bugnumPrefixPartsProcessed == 0 && this.isBugword() || this.tryHandleBugnumPrefixPart()) {
                            n2 = n == 32 || n == 9 ? 5 : 6;
                            break;
                        }
                        n2 = this.getInitialState(n);
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 2: {
                    if (n == 32 || n == 9) {
                        n2 = 3;
                        break;
                    }
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 3: {
                    if (n == 32 || n == 9) {
                        n2 = 3;
                        break;
                    }
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 4: {
                    if (Impl.isDigit(n)) {
                        n2 = 4;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 5: 
                case 6: {
                    if (this.state == 6 && n == 42) {
                        n2 = 7;
                        break;
                    }
                    if (n == 32 || n == 9) {
                        n2 = this.state;
                        break;
                    }
                    if (n == 13 || n == 10) {
                        n2 = 6;
                        break;
                    }
                    if (n == 35) {
                        n2 = 2;
                        if (!this.isBugnumPrefix()) break;
                        this.start = this.pos;
                        break;
                    }
                    if (Impl.isDigit(n)) {
                        if (this.isPartialBugnumPrefix()) {
                            n2 = this.getInitialState(n);
                            break;
                        }
                        n2 = 4;
                        if (!this.isFullBugnumPrefix()) break;
                        this.start = this.pos;
                        break;
                    }
                    if (Impl.isLetter(n)) {
                        n2 = 1;
                        if (this.isPartialBugnumPrefix()) {
                            this.startOfWord = this.pos;
                            break;
                        }
                        this.bugnumPrefixPartsProcessed = 0;
                        this.rememberIsStart();
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 7: {
                    if (n == 32 || n == 9) {
                        n2 = 5;
                        break;
                    }
                    if (n == 13 || n == 10) {
                        n2 = 6;
                        break;
                    }
                    n2 = this.getInitialState(n);
                    break;
                }
                case 8: {
                    n2 = this.getInitialState(n);
                    break;
                }
                default: {
                    assert (false);
                    n2 = this.getInitialState(n);
                }
            }
            if (this.state == 4 && n2 != 4 && Impl.isSpaceOrPunct(n)) {
                this.storeResult(this.start, this.pos);
            }
            if (n2 == 0 || n2 == 8) {
                this.start = -1;
            }
            this.state = n2;
        }

        private int getInitialState(int n) {
            return Impl.isSpaceOrPunct(n) ? 0 : 8;
        }

        private void rememberIsStart() {
            this.start = this.pos;
            this.startOfWord = this.pos;
        }

        private void storeResult(int n, int n2) {
            assert (n != -1);
            if (this.result == null) {
                this.result = new int[]{n, n2};
            } else {
                int[] nArray = new int[this.result.length + 2];
                System.arraycopy(this.result, 0, nArray, 0, this.result.length);
                nArray[this.result.length] = n;
                nArray[this.result.length + 1] = n2;
                this.result = nArray;
            }
        }

        private static boolean isLetter(int n) {
            return (n |= 0x20) >= 97 && n <= 122;
        }

        private static boolean isDigit(int n) {
            return n >= 48 && n <= 57;
        }

        private static boolean isSpaceOrPunct(int n) {
            return n == 13 || n == 10 || Character.isSpaceChar(n) || Impl.isPunct(n);
        }

        private static boolean isPunct(int n) {
            return PUNCT_CHARS.indexOf(n) != -1;
        }

        private boolean isBugword() {
            CharSequence charSequence = this.str.subSequence(this.start, this.pos);
            for (int i = 0; i < BUGWORDS.length; ++i) {
                if (!BugzillaIssueFinder.equalsIgnoreCase(Impl.BUGWORDS[i], charSequence)) continue;
                return true;
            }
            return false;
        }

        private boolean tryHandleBugnumPrefixPart() {
            CharSequence charSequence = this.str.subSequence(this.startOfWord, this.pos);
            if (BugzillaIssueFinder.equalsIgnoreCase(Impl.BUGNUM_PREFIX_PARTS[this.bugnumPrefixPartsProcessed], charSequence)) {
                ++this.bugnumPrefixPartsProcessed;
                return true;
            }
            if (this.bugnumPrefixPartsProcessed != 0 && BugzillaIssueFinder.equalsIgnoreCase(Impl.BUGNUM_PREFIX_PARTS[0], charSequence)) {
                this.bugnumPrefixPartsProcessed = 1;
                this.start = this.startOfWord;
                return true;
            }
            return false;
        }

        private boolean isBugnumPrefix() {
            return this.bugnumPrefixPartsProcessed != 0;
        }

        private boolean isPartialBugnumPrefix() {
            return this.bugnumPrefixPartsProcessed > 0 && this.bugnumPrefixPartsProcessed < BUGNUM_PREFIX_PARTS.length;
        }

        private boolean isFullBugnumPrefix() {
            return this.bugnumPrefixPartsProcessed == BUGNUM_PREFIX_PARTS.length;
        }

        static {
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl) {
                int n;
                for (n = 0; n < BUGWORDS.length; ++n) {
                    assert (BUGWORDS[n].equals(BUGWORDS[n].toLowerCase()));
                }
                for (n = 0; n < BUGNUM_PREFIX_PARTS.length; ++n) {
                    assert (BUGNUM_PREFIX_PARTS[n].equals(BUGNUM_PREFIX_PARTS[n].toLowerCase()));
                }
                HashSet<String> hashSet = new HashSet<String>(7);
                hashSet.addAll(Arrays.asList(BUGNUM_PREFIX_PARTS));
                assert (hashSet.size() == BUGNUM_PREFIX_PARTS.length);
            }
        }
    }
}

