/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.diff.PatchUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugzilla.issue.AttachmentPanel;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(220, 220, 220);
    private BugzillaIssue issue;
    private List<AttachmentPanel> newAttachments;
    private JLabel noneLabel;
    private LinkButton createNewButton;
    private JLabel dummyLabel = new JLabel();
    private PropertyChangeListener deletedListener;

    public AttachmentsPanel() {
        this.setBackground(UIManager.getColor("EditorPane.background"));
        ResourceBundle resourceBundle = NbBundle.getBundle(AttachmentsPanel.class);
        this.noneLabel = new JLabel(resourceBundle.getString("AttachmentsPanel.noneLabel.text"));
        this.createNewButton = new LinkButton((Action)new CreateNewAction());
        this.createNewButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AttachmentPanels.createNewButton.AccessibleContext.accessibleDescription"));
    }

    public void setIssue(BugzillaIssue bugzillaIssue) {
        this.issue = bugzillaIssue;
        this.newAttachments = new LinkedList<AttachmentPanel>();
        this.removeAll();
        GroupLayout groupLayout = new GroupLayout((Container)this);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(1);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        ResourceBundle resourceBundle = NbBundle.getBundle(AttachmentsPanel.class);
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        BugzillaIssue.Attachment[] attachmentArray = bugzillaIssue.getAttachments();
        boolean bl = attachmentArray.length == 0;
        parallelGroup.add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.noneLabel).addPreferredGap(0).add((Component)(bl ? this.createNewButton : this.dummyLabel)).add(0, 0, Short.MAX_VALUE));
        sequentialGroup.add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.noneLabel).add((Component)(bl ? this.createNewButton : this.dummyLabel)));
        this.dummyLabel.setVisible(false);
        this.noneLabel.setVisible(bl);
        this.updateCreateNewButton(bl);
        if (bl) {
            sequentialGroup.add((GroupLayout.Group)sequentialGroup2);
        } else {
            JLabel jLabel = new JLabel(resourceBundle.getString("AttachmentsPanel.table.description"));
            JLabel jLabel2 = new JLabel(resourceBundle.getString("AttachmentsPanel.table.filename"));
            JLabel jLabel3 = new JLabel(resourceBundle.getString("AttachmentsPanel.table.date"));
            JLabel jLabel4 = new JLabel(resourceBundle.getString("AttachmentsPanel.table.author"));
            this.makeBold(jLabel);
            this.makeBold(jLabel2);
            this.makeBold(jLabel3);
            this.makeBold(jLabel4);
            GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup();
            GroupLayout.ParallelGroup parallelGroup3 = groupLayout.createParallelGroup();
            GroupLayout.ParallelGroup parallelGroup4 = groupLayout.createParallelGroup();
            GroupLayout.ParallelGroup parallelGroup5 = groupLayout.createParallelGroup();
            int n = Math.max(jLabel.getPreferredSize().width, 150);
            parallelGroup2.add((Component)jLabel, -2, n, -2);
            parallelGroup3.add((Component)jLabel2);
            parallelGroup4.add((Component)jLabel3);
            parallelGroup5.add((Component)jLabel4);
            JPanel jPanel = this.createHighlightPanel();
            GroupLayout.ParallelGroup parallelGroup6 = groupLayout.createParallelGroup(1, false);
            parallelGroup.add((GroupLayout.Group)parallelGroup6.add((Component)jPanel, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)parallelGroup2).addPreferredGap(1).add((GroupLayout.Group)parallelGroup3).addPreferredGap(1).add((GroupLayout.Group)parallelGroup4).addPreferredGap(1).add((GroupLayout.Group)parallelGroup5)));
            sequentialGroup.add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)jPanel, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)jLabel2).add((Component)jLabel3).add((Component)jLabel4)));
            for (BugzillaIssue.Attachment attachment : attachmentArray) {
                boolean bl2 = "1".equals(attachment.getIsPatch());
                String string = attachment.getDesc();
                String string2 = attachment.getFilename();
                Date date = attachment.getDate();
                String string3 = attachment.getAuthor();
                jLabel = new JLabel(string);
                LinkButton linkButton = new LinkButton();
                LinkButton linkButton2 = null;
                JLabel jLabel5 = null;
                JLabel jLabel6 = null;
                GroupLayout.SequentialGroup sequentialGroup3 = null;
                if (bl2) {
                    linkButton2 = new LinkButton();
                    jLabel5 = new JLabel("(");
                    jLabel6 = new JLabel(")");
                    sequentialGroup3 = groupLayout.createSequentialGroup().add((Component)linkButton).addPreferredGap(0).add((Component)jLabel5).add((Component)linkButton2).add((Component)jLabel6);
                }
                JPopupMenu jPopupMenu = this.menuFor(attachment, linkButton2);
                linkButton.setAction((Action)new DefaultAttachmentAction(attachment));
                linkButton.setText(string2);
                linkButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.filenameButton.AccessibleContext.accessibleDescription"));
                jLabel3 = new JLabel(date != null ? DateFormat.getDateInstance().format(date) : "");
                jLabel4 = new JLabel(string3);
                jLabel.setComponentPopupMenu(jPopupMenu);
                linkButton.setComponentPopupMenu(jPopupMenu);
                jLabel3.setComponentPopupMenu(jPopupMenu);
                jLabel4.setComponentPopupMenu(jPopupMenu);
                parallelGroup2.add((Component)jLabel);
                if (bl2) {
                    jLabel5.setComponentPopupMenu(jPopupMenu);
                    linkButton2.setComponentPopupMenu(jPopupMenu);
                    jLabel6.setComponentPopupMenu(jPopupMenu);
                    parallelGroup3.add((GroupLayout.Group)sequentialGroup3);
                } else {
                    parallelGroup3.add((Component)linkButton);
                }
                parallelGroup4.add((Component)jLabel3);
                parallelGroup5.add((Component)jLabel4);
                jPanel = this.createHighlightPanel();
                jPanel.addMouseListener(new MouseAdapter(){});
                jPanel.setComponentPopupMenu(jPopupMenu);
                parallelGroup6.add((Component)jPanel, 0, 0, Short.MAX_VALUE);
                GroupLayout.ParallelGroup parallelGroup7 = groupLayout.createParallelGroup(3);
                parallelGroup7.add((Component)jLabel);
                parallelGroup7.add((Component)linkButton);
                if (bl2) {
                    parallelGroup7.add((Component)jLabel5);
                    parallelGroup7.add((Component)linkButton2);
                    parallelGroup7.add((Component)jLabel6);
                }
                parallelGroup7.add((Component)jLabel3);
                parallelGroup7.add((Component)jLabel4);
                sequentialGroup.addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)jPanel, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)parallelGroup7));
            }
            sequentialGroup.add((GroupLayout.Group)sequentialGroup2);
        }
        parallelGroup.add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)(bl ? this.dummyLabel : this.createNewButton)).add(0, 0, Short.MAX_VALUE));
        sequentialGroup.addPreferredGap(0);
        sequentialGroup.add((Component)(bl ? this.dummyLabel : this.createNewButton));
        groupLayout.setHorizontalGroup((GroupLayout.Group)parallelGroup);
        groupLayout.setVerticalGroup((GroupLayout.Group)sequentialGroup);
        ((CreateNewAction)this.createNewButton.getAction()).setLayoutGroups(parallelGroup, sequentialGroup2);
        this.setLayout((LayoutManager)groupLayout);
    }

    private JPopupMenu menuFor(BugzillaIssue.Attachment attachment, LinkButton linkButton) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new DefaultAttachmentAction(attachment));
        jPopupMenu.add(new SaveAttachmentAction(attachment));
        if ("1".equals(attachment.getIsPatch())) {
            ApplyPatchAction applyPatchAction = new ApplyPatchAction(attachment);
            jPopupMenu.add(applyPatchAction);
            linkButton.setAction((Action)applyPatchAction);
            String string = linkButton.getText();
            linkButton.setText(string.substring(0, 1).toLowerCase() + string.substring(1));
            linkButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentPanels.patchButton.AccessibleContext.accessibleDescription"));
        }
        return jPopupMenu;
    }

    private void updateCreateNewButton(boolean bl) {
        String string = NbBundle.getMessage(AttachmentsPanel.class, (String)"AttachmentsPanel.createNewButton.text");
        this.createNewButton.setText(bl ? '(' + string + ')' : string);
    }

    private void makeBold(JLabel jLabel) {
        Font font = jLabel.getFont().deriveFont(1);
        jLabel.setFont(font);
    }

    private JPanel createHighlightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(BG_COLOR);
        this.add(jPanel);
        return jPanel;
    }

    PropertyChangeListener getDeletedListener() {
        if (this.deletedListener == null) {
            this.deletedListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("attachmentDeleted".equals(propertyChangeEvent.getPropertyName())) {
                        for (AttachmentPanel attachmentPanel : AttachmentsPanel.this.newAttachments) {
                            if (attachmentPanel.isDeleted()) continue;
                            return;
                        }
                        AttachmentsPanel.this.noneLabel.setVisible(true);
                        AttachmentsPanel.this.switchHelper();
                        AttachmentsPanel.this.updateCreateNewButton(true);
                    }
                }
            };
        }
        return this.deletedListener;
    }

    private void switchHelper() {
        JLabel jLabel = new JLabel();
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        groupLayout.replace((Component)this.dummyLabel, (Component)jLabel);
        groupLayout.replace((Component)this.createNewButton, (Component)this.dummyLabel);
        groupLayout.replace((Component)jLabel, (Component)this.createNewButton);
    }

    List<AttachmentInfo> getNewAttachments() {
        LinkedList<AttachmentInfo> linkedList = new LinkedList<AttachmentInfo>();
        for (AttachmentPanel attachmentPanel : this.newAttachments) {
            if (attachmentPanel.isDeleted()) continue;
            AttachmentInfo attachmentInfo = new AttachmentInfo();
            attachmentInfo.file = attachmentPanel.getFile();
            attachmentInfo.description = attachmentPanel.getDescription();
            attachmentInfo.contentType = attachmentPanel.getContentType();
            attachmentInfo.isPatch = attachmentPanel.isPatch();
            linkedList.add(attachmentInfo);
        }
        return linkedList;
    }

    static File saveToTempFile(BugzillaIssue.Attachment attachment) throws IOException {
        String string;
        String string2 = attachment.getFilename();
        int n = string2.lastIndexOf(46);
        String string3 = n == -1 ? string2 : string2.substring(0, n);
        String string4 = string = n == -1 ? null : string2.substring(n);
        if (string3.length() < 3) {
            string3 = string3 + "tmp";
        }
        File file = File.createTempFile(string3, string);
        attachment.getAttachementData(new FileOutputStream(file));
        return file;
    }

    static class ApplyPatchAction
    extends AbstractAction {
        private BugzillaIssue.Attachment attachment;

        public ApplyPatchAction(BugzillaIssue.Attachment attachment) {
            this.attachment = attachment;
            this.putValue("Name", NbBundle.getMessage(ApplyPatchAction.class, (String)"AttachmentsPanel.ApplyPatchAction.name"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final File file = BugtrackingUtil.selectPatchContext();
            if (file != null) {
                String string = NbBundle.getMessage(ApplyPatchAction.class, (String)"AttachmentsPanel.ApplyPatchAction.progress");
                String string2 = MessageFormat.format(string, this.attachment.getFilename());
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            File file2 = AttachmentsPanel.saveToTempFile(ApplyPatchAction.this.attachment);
                            PatchUtils.applyPatch((File)file2, (File)file);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        finally {
                            progressHandle.finish();
                        }
                    }
                });
            }
        }
    }

    static class SaveAttachmentAction
    extends AbstractAction {
        private BugzillaIssue.Attachment attachment;

        public SaveAttachmentAction(BugzillaIssue.Attachment attachment) {
            this.attachment = attachment;
            this.putValue("Name", NbBundle.getMessage(SaveAttachmentAction.class, (String)"AttachmentsPanel.SaveAttachmentAction.name"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final File file = new FileChooserBuilder(AttachmentsPanel.class).setFilesOnly(true).showSaveDialog();
            if (file != null) {
                String string = NbBundle.getMessage(SaveAttachmentAction.class, (String)"AttachmentsPanel.SaveAttachmentAction.progress");
                String string2 = MessageFormat.format(string, this.attachment.getFilename());
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SaveAttachmentAction.this.attachment.getAttachementData(new FileOutputStream(file));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        finally {
                            progressHandle.finish();
                        }
                    }
                });
            }
        }
    }

    static class DefaultAttachmentAction
    extends AbstractAction {
        private BugzillaIssue.Attachment attachment;

        public DefaultAttachmentAction(BugzillaIssue.Attachment attachment) {
            this.attachment = attachment;
            this.putValue("Name", NbBundle.getMessage(DefaultAttachmentAction.class, (String)"AttachmentsPanel.DefaultAttachmentAction.name"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = NbBundle.getMessage(DefaultAttachmentAction.class, (String)"AttachmentsPanel.DefaultAttachmentAction.progress");
            String string2 = MessageFormat.format(string, this.attachment.getFilename());
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
            progressHandle.start();
            progressHandle.switchToIndeterminate();
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        File file = AttachmentsPanel.saveToTempFile(DefaultAttachmentAction.this.attachment);
                        String string = DefaultAttachmentAction.this.attachment.getContentType();
                        if ("image/png".equals(string) || "image/gif".equals(string) || "image/jpeg".equals(string)) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(file.toURI().toURL());
                        } else {
                            FileObject fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
                            DataObject dataObject = DataObject.find((FileObject)fileObject);
                            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                            if (openCookie != null) {
                                openCookie.open();
                            }
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        dataObjectNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            });
        }
    }

    class CreateNewAction
    extends AbstractAction {
        private GroupLayout.ParallelGroup horizontalGroup;
        private GroupLayout.SequentialGroup verticalGroup;

        CreateNewAction() {
        }

        void setLayoutGroups(GroupLayout.ParallelGroup parallelGroup, GroupLayout.SequentialGroup sequentialGroup) {
            this.horizontalGroup = parallelGroup;
            this.verticalGroup = sequentialGroup;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AttachmentPanel attachmentPanel = new AttachmentPanel();
            attachmentPanel.setBackground(BG_COLOR);
            this.horizontalGroup.add((Component)attachmentPanel, -2, -1, -2);
            this.verticalGroup.addPreferredGap(0);
            this.verticalGroup.add((Component)attachmentPanel, -2, -1, -2);
            if (AttachmentsPanel.this.noneLabel.isVisible()) {
                AttachmentsPanel.this.noneLabel.setVisible(false);
                AttachmentsPanel.this.switchHelper();
                AttachmentsPanel.this.updateCreateNewButton(false);
            }
            if (AttachmentsPanel.this.issue.getAttachments().length == 0) {
                attachmentPanel.addPropertyChangeListener(AttachmentsPanel.this.getDeletedListener());
            }
            AttachmentsPanel.this.newAttachments.add(attachmentPanel);
            BugtrackingUtil.keepFocusedComponentVisible((Component)attachmentPanel);
            AttachmentsPanel.this.revalidate();
        }
    }

    class AttachmentInfo {
        File file;
        String description;
        String contentType;
        boolean isPatch;

        AttachmentInfo() {
        }
    }
}

