/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AttachmentPanel
extends JPanel {
    static final String PROP_DELETED = "attachmentDeleted";
    private JButton browseButton;
    private LinkButton deleteButton;
    private JTextField descriptionField;
    private JLabel descriptionLabel;
    private JTextField fileField;
    private JComboBox fileTypeCombo;
    private JLabel fileTypeLabel;
    private JCheckBox patchChoice;
    private JLabel patchLabel;

    public AttachmentPanel() {
        this.initComponents();
        this.initFileTypeCombo();
    }

    private void initFileTypeCombo() {
        DefaultComboBoxModel<FileType> defaultComboBoxModel = new DefaultComboBoxModel<FileType>();
        ResourceBundle resourceBundle = NbBundle.getBundle(AttachmentPanel.class);
        defaultComboBoxModel.addElement(new FileType(null, resourceBundle.getString("AttachmentPanel.fileType.automatic")));
        defaultComboBoxModel.addElement(new FileType("text/plain", resourceBundle.getString("AttachmentPanel.fileType.textPlain")));
        defaultComboBoxModel.addElement(new FileType("text/html", resourceBundle.getString("AttachmentPanel.fileType.textHTML")));
        defaultComboBoxModel.addElement(new FileType("application/xml", resourceBundle.getString("AttachmentPanel.fileType.applicationXML")));
        defaultComboBoxModel.addElement(new FileType("image/gif", resourceBundle.getString("AttachmentPanel.fileType.imageGIF")));
        defaultComboBoxModel.addElement(new FileType("image/jpeg", resourceBundle.getString("AttachmentPanel.fileType.imageJPEG")));
        defaultComboBoxModel.addElement(new FileType("image/png", resourceBundle.getString("AttachmentPanel.fileType.imagePNG")));
        defaultComboBoxModel.addElement(new FileType("application/octet-stream", resourceBundle.getString("AttachmentPanel.fileType.binary")));
        this.fileTypeCombo.setModel(defaultComboBoxModel);
    }

    public File getFile() {
        File file = null;
        if (!this.isDeleted()) {
            file = new File(this.fileField.getText());
        }
        return file;
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public String getContentType() {
        String string = null;
        Object object = this.fileTypeCombo.getSelectedItem();
        string = object instanceof FileType ? ((FileType)object).getContentType() : object.toString();
        return string;
    }

    public boolean isPatch() {
        return this.patchChoice.isSelected();
    }

    public boolean isDeleted() {
        return !this.isVisible();
    }

    private void initComponents() {
        this.fileField = new JTextField();
        this.browseButton = new JButton();
        this.deleteButton = new LinkButton();
        this.descriptionLabel = new JLabel();
        this.descriptionField = new JTextField();
        this.fileTypeLabel = new JLabel();
        this.fileTypeCombo = new JComboBox();
        this.patchLabel = new JLabel();
        this.patchChoice = new JCheckBox();
        this.fileField.setColumns(30);
        this.browseButton.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachmentPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.deleteButton.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.deleteButton.text"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachmentPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        this.descriptionLabel.setLabelFor(this.descriptionField);
        this.descriptionLabel.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.descriptionLabel.text"));
        this.fileTypeLabel.setLabelFor(this.fileTypeCombo);
        this.fileTypeLabel.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileTypeLabel.text"));
        this.fileTypeCombo.setEditable(true);
        this.patchLabel.setLabelFor(this.patchChoice);
        this.patchLabel.setText(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.patchLabel.text"));
        this.patchChoice.setBorder(null);
        this.patchChoice.setMargin(new Insets(0, 0, 0, 0));
        this.patchChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachmentPanel.this.patchChoiceActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.fileField).addPreferredGap(0).add((Component)this.browseButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.fileTypeLabel).add((Component)this.descriptionLabel).add((Component)this.patchLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileTypeCombo, -2, -1, -2).add((Component)this.descriptionField, -1, 260, Short.MAX_VALUE).add((Component)this.patchChoice)))).addPreferredGap(0).add((Component)this.deleteButton, -2, -1, -2).add(0, 0, 0)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileField, -2, -1, -2).add((Component)this.browseButton).add((Component)this.deleteButton, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.descriptionLabel).add((Component)this.descriptionField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileTypeLabel).add((Component)this.fileTypeCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.patchLabel).add((Component)this.patchChoice))));
        this.fileField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileField.AccessibleContext.accessibleName"));
        this.fileField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileField.AccessibleContext.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.browseButton.AccessibleContext.accessibleDescription"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.deleteButton.AccessibleContext.accessibleDescription"));
        this.descriptionField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.descriptionField.AccessibleContext.accessibleDescription"));
        this.fileTypeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.fileTypeCombo.AccessibleContext.accessibleDescription"));
        this.patchChoice.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.patchChoice.AccessibleContext.accessibleName"));
        this.patchChoice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachmentPanel.class, (String)"AttachmentPanel.patchChoice.AccessibleContext.accessibleDescription"));
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.firePropertyChange(PROP_DELETED, null, null);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        File file = new FileChooserBuilder(AttachmentPanel.class).showOpenDialog();
        if (file != null) {
            file = FileUtil.normalizeFile((File)file);
            this.fileField.setText(file.getAbsolutePath());
        }
    }

    private void patchChoiceActionPerformed(ActionEvent actionEvent) {
        this.fileTypeCombo.setEnabled(!this.patchChoice.isSelected());
        if (this.patchChoice.isSelected()) {
            this.fileTypeCombo.setSelectedIndex(1);
        }
    }

    static class FileType {
        private String contentType;
        private String displayName;

        FileType(String string, String string2) {
            this.contentType = string;
            this.displayName = string2;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String toString() {
            return this.displayName + (this.contentType == null ? "" : " (" + this.contentType + ')');
        }
    }
}

