/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.autoupdate;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.autoupdate.AutoupdatePanel;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BugzillaAutoupdate {
    static final BugzillaVersion SUPPORTED_BUGZILLA_VERSION;
    static final String BUGZILLA_MODULE_CODE_NAME = "org.netbeans.modules.bugzilla";
    private static Map<String, Long> lastChecks;
    private static final Pattern VERSION_PATTERN;
    private static BugzillaAutoupdate instance;
    private Map<String, Boolean> updateAvailableMap = new HashMap<String, Boolean>();

    private BugzillaAutoupdate() {
    }

    public static BugzillaAutoupdate getInstance() {
        if (instance == null) {
            instance = new BugzillaAutoupdate();
        }
        return instance;
    }

    public boolean isUpdateAvailable(BugzillaRepository bugzillaRepository) {
        Boolean bl = this.updateAvailableMap.get(bugzillaRepository.getUrl());
        return bl != null ? bl : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndNotify(BugzillaRepository bugzillaRepository) {
        Bugzilla.LOG.fine("BugzillaAutoupdate.checkAndNotify start");
        try {
            if (this.wasCheckedToday(this.getLastCheck(bugzillaRepository))) {
                boolean bl = true;
                return bl;
            }
            if (!BugzillaConfig.getInstance().getCheckUpdates()) {
                boolean bl = true;
                return bl;
            }
            if (!this.checkSupportedBugzillaServerVersion(bugzillaRepository) && this.checkNewBugzillaPluginAvailable()) {
                this.updateAvailableMap.put(bugzillaRepository.getUrl(), Boolean.TRUE);
                AutoupdatePanel autoupdatePanel = new AutoupdatePanel();
                if (BugzillaUtil.show(autoupdatePanel, NbBundle.getMessage(BugzillaAutoupdate.class, (String)"CTL_AutoupdateTitle"), NbBundle.getMessage(BugzillaAutoupdate.class, (String)"CTL_Yes"), new HelpCtx(BugzillaAutoupdate.class))) {
                    BugtrackingUtil.openPluginManager();
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            Bugzilla.LOG.fine("BugzillaAutoupdate.checkAndNotify finish");
        }
        return true;
    }

    boolean checkNewBugzillaPluginAvailable() {
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        for (UpdateUnit updateUnit : list) {
            if (!updateUnit.getCodeName().equals(BUGZILLA_MODULE_CODE_NAME)) continue;
            List list2 = updateUnit.getAvailableUpdates();
            if (list2 != null) {
                for (UpdateElement updateElement : list2) {
                    String string = updateElement.getDescription();
                    BugzillaVersion bugzillaVersion = this.getVersion(string);
                    if (bugzillaVersion == null || SUPPORTED_BUGZILLA_VERSION.compareTo(bugzillaVersion) >= 0) continue;
                    return true;
                }
                return list2.size() > 0;
            }
            return false;
        }
        return false;
    }

    boolean checkSupportedBugzillaServerVersion(BugzillaRepository bugzillaRepository) {
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (!bugzillaConfiguration.isValid()) {
            return true;
        }
        BugzillaVersion bugzillaVersion = bugzillaConfiguration.getInstalledVersion();
        if (bugzillaVersion == null) {
            return true;
        }
        boolean bl = this.isSupportedVersion(bugzillaVersion);
        if (!bl) {
            Bugzilla.LOG.log(Level.INFO, "Bugzilla repository [{0}] has version {1}. ", new Object[]{bugzillaRepository.getUrl(), bugzillaVersion});
        }
        return bl;
    }

    boolean isSupportedVersion(BugzillaVersion bugzillaVersion) {
        return bugzillaVersion.compareTo(SUPPORTED_BUGZILLA_VERSION) <= 0;
    }

    boolean wasCheckedToday(long l) {
        if (l < 0L) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, calendar.get(13) * -1);
        calendar.add(12, calendar.get(12) * -1);
        calendar.add(10, calendar.get(10) * -1);
        return l > calendar.getTime().getTime();
    }

    private long getLastCheck(BugzillaRepository bugzillaRepository) {
        Long l;
        if (lastChecks == null) {
            lastChecks = new HashMap<String, Long>(1);
        }
        if ((l = lastChecks.get(bugzillaRepository.getUrl())) == null) {
            lastChecks.put(bugzillaRepository.getUrl(), System.currentTimeMillis());
            return -1L;
        }
        return l;
    }

    BugzillaVersion getVersion(String string) {
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (matcher.matches()) {
            return new BugzillaVersion(matcher.group(1));
        }
        return null;
    }

    static {
        String string = System.getProperty("netbeans.t9y.bugzilla.supported.version");
        SUPPORTED_BUGZILLA_VERSION = string != null ? new BugzillaVersion(string) : new BugzillaVersion("3.2.2");
        lastChecks = null;
        VERSION_PATTERN = Pattern.compile("^.*version ((\\d+?\\.\\d+?\\.\\d+?)|(\\d+?\\.\\d+?)).*$");
    }
}

