/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;

public class StrutsConfigEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            StrutsConfigDataObject strutsConfigDataObject = (StrutsConfigDataObject)StrutsConfigEditorSupport.this.getDataObject();
            StrutsConfigEditorSupport.this.restartTimer();
            strutsConfigDataObject.parsingDocument();
            if (strutsConfigDataObject.isDocumentValid()) {
                StrutsConfigEditorSupport.this.saveDocument();
            } else {
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)NbBundle.getMessage(StrutsConfigEditorSupport.class, (String)"MSG_invalidXmlWarning"), NbBundle.getMessage(StrutsConfigEditorSupport.class, (String)"TTL_invalidXmlWarning"));
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    StrutsConfigEditorSupport.this.saveDocument();
                }
            }
        }
    };
    private StrutsConfigDataObject dataObject;
    private RequestProcessor.Task parsingDocumentTask;
    private static final int AUTO_PARSING_DELAY = 2000;

    public StrutsConfigEditorSupport(StrutsConfigDataObject strutsConfigDataObject) {
        super((DataObject)strutsConfigDataObject, (CloneableEditorSupport.Env)new XmlEnv(strutsConfigDataObject));
        this.setMIMEType("text/x-struts+xml");
        this.dataObject = strutsConfigDataObject;
        this.initialize();
    }

    private void initialize() {
        final DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            private void change(DocumentEvent documentEvent) {
                if (!StrutsConfigEditorSupport.this.dataObject.isNodeDirty()) {
                    StrutsConfigEditorSupport.this.restartTimer();
                }
            }
        };
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StyledDocument styledDocument;
                if ("document".equals(propertyChangeEvent.getPropertyName()) && StrutsConfigEditorSupport.this.isDocumentLoaded() && (styledDocument = StrutsConfigEditorSupport.this.getDocument()) != null) {
                    styledDocument.addDocumentListener(documentListener);
                }
            }
        });
    }

    public void saveDocument() throws IOException {
        CharsetEncoder charsetEncoder;
        final StyledDocument styledDocument = this.getDocument();
        String string = "UTF-8";
        String string2 = EncodingUtil.detectEncoding((Document)styledDocument);
        boolean bl = false;
        if (string2 == null) {
            string2 = string;
        }
        if (!this.isSupportedEncoding(string2)) {
            charsetEncoder = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(StrutsConfigEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string2, string}), 0, 2);
            charsetEncoder.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)charsetEncoder);
            if (charsetEncoder.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
            bl = true;
        }
        if (!bl) {
            try {
                charsetEncoder = Charset.forName(string2).newEncoder();
                if (!charsetEncoder.canEncode(styledDocument.getText(0, styledDocument.getLength()))) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(StrutsConfigEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string2}), 0, 2);
                    confirmation.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        } else {
            try {
                int n;
                int n2 = Math.min(1000, styledDocument.getLength());
                final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                int n3 = 0;
                if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                    for (n = 3; n < n2; ++n) {
                        if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                        n3 = n + 1;
                        break;
                    }
                }
                n = n3;
                Runnable runnable = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                styledDocument.remove(0, n + 1);
                                styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                            }
                            catch (BadLocationException badLocationException) {
                                if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                badLocationException.printStackTrace();
                            }
                        }
                    }
                };
                NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                super.saveDocument();
                this.getDataObject().setModified(false);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
            }
        }
    }

    private boolean isSupportedEncoding(String string) {
        boolean bl;
        try {
            bl = Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            bl = false;
        }
        return bl;
    }

    public void restartTimer() {
        if (this.parsingDocumentTask == null || this.parsingDocumentTask.isFinished() || this.parsingDocumentTask.cancel()) {
            this.dataObject.setDocumentDirty(true);
            Runnable runnable = new Runnable(){

                public void run() {
                    StrutsConfigEditorSupport.this.dataObject.parsingDocument();
                }
            };
            this.parsingDocumentTask = this.parsingDocumentTask != null ? RequestProcessor.getDefault().post(runnable, 2000) : RequestProcessor.getDefault().post(runnable, 100);
        }
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        StrutsConfigDataObject strutsConfigDataObject = (StrutsConfigDataObject)this.getDataObject();
        if (strutsConfigDataObject.getCookie(SaveCookie.class) == null) {
            strutsConfigDataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            strutsConfigDataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        StrutsConfigDataObject strutsConfigDataObject = (StrutsConfigDataObject)this.getDataObject();
        Node.Cookie cookie = strutsConfigDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            strutsConfigDataObject.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            strutsConfigDataObject.setModified(false);
        }
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(StrutsConfigDataObject strutsConfigDataObject) {
            super((DataObject)strutsConfigDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((StrutsConfigDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (StrutsConfigEditorSupport)this.getDataObject().getCookie(StrutsConfigEditorSupport.class);
        }
    }
}

