/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class LivenessMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle");
    private static final String MEMORY_LIVENESS_MSG = messages.getString("LivenessMemoryResultsSnapshot_MemoryLivenessMsg");
    private float[] avgObjectAge;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private int currentEpoch;
    private int nInstrClasses;
    private int nTotalTracked;
    private int nTrackedItems;
    private long maxValue;
    private long nTotalTrackedBytes;

    public LivenessMemoryResultsSnapshot() {
    }

    public LivenessMemoryResultsSnapshot(long l, long l2, MemoryCCTProvider memoryCCTProvider, ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        super(l, l2, memoryCCTProvider, profilerClient);
    }

    public float[] getAvgObjectAge() {
        return this.avgObjectAge;
    }

    public int[] getMaxSurvGen() {
        return this.maxSurvGen;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public int getNAlloc() {
        return this.nInstrClasses;
    }

    public int getNInstrClasses() {
        return this.nInstrClasses;
    }

    public long getNTotalTracked() {
        return this.nTotalTracked;
    }

    public long getNTotalTrackedBytes() {
        return this.nTotalTrackedBytes;
    }

    public long[] getNTrackedAllocObjects() {
        return this.nTrackedAllocObjects;
    }

    public int getNTrackedItems() {
        return this.nTrackedItems;
    }

    public int[] getNTrackedLiveObjects() {
        return this.nTrackedLiveObjects;
    }

    public long[] getTrackedLiveObjectsSize() {
        return this.trackedLiveObjectsSize;
    }

    public int[] getnTotalAllocObjects() {
        return this.nTotalAllocObjects;
    }

    public void performInit(ProfilerClient profilerClient, MemoryCCTProvider memoryCCTProvider) throws ClientUtils.TargetAppOrVMTerminated {
        int n;
        MemoryCCTProvider.ObjectNumbersContainer objectNumbersContainer = memoryCCTProvider.getLivenessObjectNumbers();
        int n2 = objectNumbersContainer.nTrackedAllocObjects.length;
        this.nTrackedAllocObjects = new long[n2];
        System.arraycopy(objectNumbersContainer.nTrackedAllocObjects, 0, this.nTrackedAllocObjects, 0, n2);
        n2 = objectNumbersContainer.nTrackedLiveObjects.length;
        this.nTrackedLiveObjects = new int[n2];
        System.arraycopy(objectNumbersContainer.nTrackedLiveObjects, 0, this.nTrackedLiveObjects, 0, n2);
        n2 = objectNumbersContainer.trackedLiveObjectsSize.length;
        this.trackedLiveObjectsSize = new long[n2];
        System.arraycopy(objectNumbersContainer.trackedLiveObjectsSize, 0, this.trackedLiveObjectsSize, 0, n2);
        n2 = objectNumbersContainer.avgObjectAge.length;
        this.avgObjectAge = new float[n2];
        System.arraycopy(objectNumbersContainer.avgObjectAge, 0, this.avgObjectAge, 0, n2);
        n2 = objectNumbersContainer.maxSurvGen.length;
        this.maxSurvGen = new int[n2];
        System.arraycopy(objectNumbersContainer.maxSurvGen, 0, this.maxSurvGen, 0, n2);
        this.nInstrClasses = objectNumbersContainer.nInstrClasses;
        int[] nArray = profilerClient.getAllocatedObjectsCountResults();
        n2 = nArray.length;
        this.nTotalAllocObjects = new int[n2];
        System.arraycopy(nArray, 0, this.nTotalAllocObjects, 0, n2);
        this.nTrackedItems = Math.min(this.nTrackedAllocObjects.length, this.nTrackedLiveObjects.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.trackedLiveObjectsSize.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.avgObjectAge.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.maxSurvGen.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nInstrClasses);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nTotalAllocObjects.length);
        for (n = 0; n < this.nTrackedItems; ++n) {
            if (this.nTrackedAllocObjects[n] != -1L) continue;
            this.nTotalAllocObjects[n] = 0;
        }
        this.maxValue = 0L;
        this.nTotalTrackedBytes = 0L;
        this.nTotalTracked = 0;
        for (n = 0; n < this.nTrackedItems; ++n) {
            if (this.maxValue < this.trackedLiveObjectsSize[n]) {
                this.maxValue = this.trackedLiveObjectsSize[n];
            }
            this.nTotalTrackedBytes += this.trackedLiveObjectsSize[n];
            this.nTotalTracked += this.nTrackedLiveObjects[n];
        }
        this.currentEpoch = memoryCCTProvider.getCurrentEpoch();
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n;
        super.readFromStream(dataInputStream);
        int n2 = dataInputStream.readInt();
        this.nTrackedAllocObjects = new long[n2];
        for (n = 0; n < n2; ++n) {
            this.nTrackedAllocObjects[n] = dataInputStream.readLong();
        }
        n2 = dataInputStream.readInt();
        this.nTrackedLiveObjects = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.nTrackedLiveObjects[n] = dataInputStream.readInt();
        }
        n2 = dataInputStream.readInt();
        this.maxSurvGen = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.maxSurvGen[n] = dataInputStream.readInt();
        }
        n2 = dataInputStream.readInt();
        this.trackedLiveObjectsSize = new long[n2];
        for (n = 0; n < n2; ++n) {
            this.trackedLiveObjectsSize[n] = dataInputStream.readLong();
        }
        n2 = dataInputStream.readInt();
        this.avgObjectAge = new float[n2];
        for (n = 0; n < n2; ++n) {
            this.avgObjectAge[n] = dataInputStream.readFloat();
        }
        this.nInstrClasses = dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        this.nTotalAllocObjects = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.nTotalAllocObjects[n] = dataInputStream.readInt();
        }
        this.nTrackedItems = dataInputStream.readInt();
        this.maxValue = dataInputStream.readLong();
        this.nTotalTrackedBytes = dataInputStream.readLong();
        this.nTotalTracked = dataInputStream.readInt();
        this.currentEpoch = dataInputStream.readInt();
    }

    public String toString() {
        return MessageFormat.format(MEMORY_LIVENESS_MSG, super.toString());
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        int n;
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.nTrackedAllocObjects.length);
        for (n = 0; n < this.nTrackedAllocObjects.length; ++n) {
            dataOutputStream.writeLong(this.nTrackedAllocObjects[n]);
        }
        dataOutputStream.writeInt(this.nTrackedLiveObjects.length);
        for (n = 0; n < this.nTrackedLiveObjects.length; ++n) {
            dataOutputStream.writeInt(this.nTrackedLiveObjects[n]);
        }
        dataOutputStream.writeInt(this.maxSurvGen.length);
        for (n = 0; n < this.maxSurvGen.length; ++n) {
            dataOutputStream.writeInt(this.maxSurvGen[n]);
        }
        dataOutputStream.writeInt(this.trackedLiveObjectsSize.length);
        for (n = 0; n < this.trackedLiveObjectsSize.length; ++n) {
            dataOutputStream.writeLong(this.trackedLiveObjectsSize[n]);
        }
        dataOutputStream.writeInt(this.avgObjectAge.length);
        for (n = 0; n < this.avgObjectAge.length; ++n) {
            dataOutputStream.writeFloat(this.avgObjectAge[n]);
        }
        dataOutputStream.writeInt(this.nInstrClasses);
        dataOutputStream.writeInt(this.nTotalAllocObjects.length);
        for (n = 0; n < this.nTotalAllocObjects.length; ++n) {
            dataOutputStream.writeInt(this.nTotalAllocObjects[n]);
        }
        dataOutputStream.writeInt(this.nTrackedItems);
        dataOutputStream.writeLong(this.maxValue);
        dataOutputStream.writeLong(this.nTotalTrackedBytes);
        dataOutputStream.writeInt(this.nTotalTracked);
        dataOutputStream.writeInt(this.currentEpoch);
    }

    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, boolean bl) {
        return PresoObjLivenessCCTNode.createPresentationCCTFromSnapshot(this, runtimeMemoryCCTNode, this.getClassName(n), this.currentEpoch, bl);
    }

    void debugValues() {
        super.debugValues();
        LOGGER.finest("nTrackedAllocObjects.length: " + this.debugLength(this.nTrackedAllocObjects));
        LOGGER.finest("nTrackedLiveObjects.length: " + this.debugLength(this.nTrackedLiveObjects));
        LOGGER.finest("maxSurvGen.length: " + this.debugLength(this.maxSurvGen));
        LOGGER.finest("trackedLiveObjectsSize.length: " + this.debugLength(this.trackedLiveObjectsSize));
        LOGGER.finest("avgObjectAge.length: " + this.debugLength(this.avgObjectAge));
        LOGGER.finest("nInstrClasses: " + this.nInstrClasses);
        LOGGER.finest("nTotalAllocObjects.length: " + this.debugLength(this.nTotalAllocObjects));
        LOGGER.finest("nTrackedItems: " + this.nTrackedItems);
        LOGGER.finest("maxValue: " + this.maxValue);
        LOGGER.finest("nTotalTrackedBytes: " + this.nTotalTrackedBytes);
        LOGGER.finest("nTotalTracked: " + this.nTotalTracked);
        LOGGER.finest("currentEpoch: " + this.currentEpoch);
    }
}

